/* m100rom.h */

/* $Id: m100rom.h,v 1.1.1.1 2004/08/05 06:46:12 deuce Exp $ */

/*
 * Copyright 2004 Stephen Hurd and Ken Pettit
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


Std_ROM_Table_t	gM100_Tables[] = {
	{ 0x0003, 5,   TABLE_TYPE_STRING },
	{ 0x0040, 64,  TABLE_TYPE_JUMP },
	{ 0x0080, 271, TABLE_TYPE_MODIFIED_STRING },
	{ 0x018F, 97,  TABLE_TYPE_MODIFIED_STRING },
	{ 0x01F0, 112, TABLE_TYPE_MODIFIED_STRING },
	{ 0x0262, 140, TABLE_TYPE_JUMP },
	{ 0x02EE, 46,  TABLE_TYPE_JUMP },
	{ 0x031C, 62,  TABLE_TYPE_2BYTE },
	{ 0x036F, 123, TABLE_TYPE_CODE },
	{ 0x03EA, 23,  TABLE_TYPE_STRING },
	{ 0x0C74, 19,  TABLE_TYPE_STRING },
	{ 0x0D71, 17,  TABLE_TYPE_STRING },
	{ 0x14D2, 6,   TABLE_TYPE_JUMP },
	{ 0x14F2, 6,   TABLE_TYPE_JUMP },
	{ 0x14FC, 10,  TABLE_TYPE_JUMP },
	{ 0x167F, 10,  TABLE_TYPE_JUMP },
	{ 0x1754, 6,   TABLE_TYPE_JUMP },
	{ 0x1762, 10,  TABLE_TYPE_JUMP },
	{ 0x17D1, 10,  TABLE_TYPE_JUMP },
	{ 0x1877, 8,   TABLE_TYPE_JUMP },
	{ 0x1978, 21,  TABLE_TYPE_3BYTE },
	{ 0x2481, 16,  TABLE_TYPE_STRING },
	{ 0x25d5, 18,  TABLE_TYPE_STRING },
	{ 0x26FE, 14,  TABLE_TYPE_STRING },
	{ 0x26FE, 14,  TABLE_TYPE_STRING },
	{ 0x325C, 32,  TABLE_TYPE_CODE },
	{ 0x327C, 2,   TABLE_TYPE_CODE },
	{ 0x327E, 88,  TABLE_TYPE_CODE },
	{ 0x32D6, 1,   TABLE_TYPE_CODE },
	{ 0x32D7, 32,  TABLE_TYPE_CODE },
	{ 0x32F7, 1,   TABLE_TYPE_CODE },
	{ 0x32F8, 24,  TABLE_TYPE_CODE },
	{ 0x3310, 1,   TABLE_TYPE_CODE },
	{ 0x3311, 32,  TABLE_TYPE_CODE },
	{ 0x3331, 1,   TABLE_TYPE_CODE },
	{ 0x3332, 40,  TABLE_TYPE_CODE },
	{ 0x335A, 1,   TABLE_TYPE_CODE },
	{ 0x335B, 64,  TABLE_TYPE_CODE },
	{ 0x339B, 1,   TABLE_TYPE_CODE },
	{ 0x339C, 64,  TABLE_TYPE_CODE },
	{ 0x438A, 24,  TABLE_TYPE_BYTE_LOOKUP },
	{ 0x43B8, 66,  TABLE_TYPE_BYTE_LOOKUP },
	{ 0x50F1, 33,  TABLE_TYPE_CTRL_DELIM },
	{ 0x5113, 16,  TABLE_TYPE_JUMP },
	{ 0x5185, 30,  TABLE_TYPE_4BYTE_CMD },
	{ 0x51A3, 1,   TABLE_TYPE_CODE },
	{ 0x51A4, 28,  TABLE_TYPE_CTRL_DELIM },
	{ 0x5244, 9,   TABLE_TYPE_STRING },
	{ 0x5443, 18,  TABLE_TYPE_CTRL_DELIM },
	{ 0x550D, 16,  TABLE_TYPE_JUMP },
	{ 0x551D, 1,   TABLE_TYPE_CODE },
	{ 0x5583, 18,  TABLE_TYPE_STRING },
	{ 0x5595, 6,   TABLE_TYPE_STRING },
	{ 0x559B, 2,   TABLE_TYPE_STRING },
	{ 0x5751, 64,  TABLE_TYPE_STRING },
	{ 0x5AE9, 36,  TABLE_TYPE_3BYTE },
	{ 0x5B0D, 17,  TABLE_TYPE_STRING },
	{ 0x5B1E, 6,   TABLE_TYPE_CODE },
	{ 0x5B24, 19,  TABLE_TYPE_STRING },
	{ 0x5B37, 15,  TABLE_TYPE_CODE },
	{ 0x5B46, 34,  TABLE_TYPE_CTRL_DELIM },
	{ 0x5CCE, 33,  TABLE_TYPE_STRING },
	{ 0x5CEF, 18,  TABLE_TYPE_4BYTE_CMD },
	{ 0x5E15, 13,  TABLE_TYPE_STRING },
	{ 0x5E22, 8,   TABLE_TYPE_CODE },
	{ 0x5E2A, 37,  TABLE_TYPE_CTRL_DELIM },
	{ 0x5F38, 17,  TABLE_TYPE_STRING },
	{ 0x5F49, 2,   TABLE_TYPE_CODE },
	{ 0x5F4B, 21,  TABLE_TYPE_STRING },
	{ 0x5F60, 5,   TABLE_TYPE_STRING },
	{ 0x6018, 62,  TABLE_TYPE_JUMP },
	{ 0x6BF1, 88,  TABLE_TYPE_CATALOG },
	{ 0x6E94, 18,  TABLE_TYPE_JUMP },
	{ 0x7551, 240, TABLE_TYPE_CODE },
	{ 0x7643, 20,  TABLE_TYPE_CODE },
	{ 0x770B, 6,   TABLE_TYPE_CODE },
	{ 0x7711, 96*5,   TABLE_TYPE_CODE },
	{ 0x78F1, 128*6,  TABLE_TYPE_CODE },
	{ 0x7BF1, 322, TABLE_TYPE_CODE },
	{ 0x7F01, 14,  TABLE_TYPE_CODE },
	{ 0x7F98, 39,  TABLE_TYPE_STRING },
	{ 0x7FBF, 23,  TABLE_TYPE_STRING },
	{ -1, 0, 0 }
};

Std_ROM_Addresses_t gM100_Vars[] = {
	{ 0x0040, "Function vector table for SGN to MID$" },
	{ 0x0080, "BASIC statement keyword table END to NEW" },
	{ 0x018E, "Function keyword table TAB to <" },
	{ 0x01F0, "Function keyword table SGN to MID$" },
	{ 0x0262, "BASIC statement vector table for END to NEW" },
	{ 0x02EE, "Vector table for math operations" },
	{ 0x031C, "BASIC error message text" },
	{ 0x035A, "Initialization image loaded to F5F0H" },
	{ 0x036F, "External ROM detect image loaded at F605H" },
	{ 0x03EA, "BASIC message strings" },
	{ 0x1F24, "Cassette frequency cycle count" },
	{ 0x4349, "Cassette frequency cycle count" },
	{ 0x551D, "TERM Mode function key vector table" },
	{ 0x5B1E, "Directory file-type display order table" },
	{ 0x5E22, "TEXT Function key table - empty" },
	{ 0x6BF1, "ROM programs catalog entries" },
	{ 0x71F7, "Interrupt exit routine (pop all regs & RET)" },
	{ 0x71F8, "Interrupt exit routine (pop all regs & RET)" },
	{ 0x7551, "8155 PIO chip bit patterns for Upper LCD drivers" },
	{ 0x7551, "8155 PIO chip bit patterns for Lower LCD drivers" },
	{ 0x7643, "8155 PIO chip bit patterns for LCD drivers" },
	{ 0x7F01, "Initial clock chip register values" },
	{ 0x7F98, "MENU Text Strings" },
	{ 0x7FA4, "TRS-80 model number string" },
	{ 0xF5F0, "Active system signature -- Warm vs Cold boot" },
	{ 0xF5F4, "HIMEM" },
	{ 0xF5F9, "RST 5.5 RAM Vector" },
	{ 0xF5FC, "RST 6.5 RAM Vector" },
	{ 0xF5FF, "RST 7.5 RAM Vector" },
	{ 0xF602, "RAM vector for TRAP interrupt" },
	{ 0xF62A, "Option ROM flag" },
	{ 0xF62B, "Dial speed (1=10pps, 2=20pps" },
	{ 0xF630, "Function key status table (1 = on)" },
	{ 0xF638, "New Console device flag" },
	{ 0xF639, "Cursor row (1-8)" },
	{ 0xF63A, "Cursor column (1-40)" },
	{ 0xF63B, "Active rows count (1-8)" },
	{ 0xF63C, "Active columns count (1-40)" },
	{ 0xf63d, "Label line protect status" },
	{ 0xF63e, "Scroll disable flag" },
	{ 0xF63f, "Cursor status (0 = off)" },
	{ 0xF640, "Cursor row (1-8)" },
	{ 0xF641, "Cursor column (1-40)" },
	{ 0xF646, "ESC mode flag for RST 20H" },
	{ 0xF648, "Reverse video switch" },
	{ 0xF64E, "X coord of last point plotted" },
	{ 0xF64F, "Y coord of last point plotted" },
	{ 0xF656, "Power off exit condition switch" },
	{ 0xF658, "Full/Half duplex switch" },
	{ 0xF65A, "RS232 auto linefeed switch" },
	{ 0xF65B, "RS232 parameter setting table" },
	{ 0xF661, "Address last called" },
	{ 0xF667, "OUT statement hook" },
	{ 0xF66A, "INP function hook" },
	{ 0xF672, "Last Error code" },
	{ 0xF674, "Line printer head position" },
	{ 0xF675, "Output device for RST 20H (0=screen)" },
	{ 0xF678, "BASIC string buffer pointer" },
	{ 0xF67A, "Current executing line number" },
	{ 0xF67C, "Start of BASIC program pointer" },
	{ 0xF680, "End of statement marker" },
	{ 0xF685, "Keyboard buffer" },
	{ 0xF788, "Horiz. position of cursor (0-39)" },
	{ 0xF789, "Function key definition area" },
	{ 0xF80A, "Function key definition area (BASIC)" },
	{ 0xF88C, "End of RAM for file storage" },
	{ 0xF923, "Seconds (ones)" },
	{ 0xF924, "Seconds (tens)" },
	{ 0xF925, "Minutes (ones)" },
	{ 0xF926, "Minutes (tens)" },
	{ 0xF927, "Hours (ones)" },
	{ 0xF928, "Hours (tens)" },
	{ 0xF929, "Date (ones)" },
	{ 0xF92A, "Date (tens)" },
	{ 0xF92B, "Day code (0=Sun, 1=Mon, etc.)" },
	{ 0xF92C, "Month (1-12)" },
	{ 0xF92D, "Year (ones)" },
	{ 0xF92E, "Year (tens)" },
	{ 0xF933, "Seconds (ones)" },
	{ 0xF934, "Seconds (tens)" },
	{ 0xF935, "Minutes (ones)" },
	{ 0xF936, "Minutes (tens)" },
	{ 0xF937, "Hours (ones)" },
	{ 0xF938, "Hours (tens)" },
	{ 0xF939, "Date (ones)" },
	{ 0xF93A, "Date (tens)" },
	{ 0xF93B, "Day code (0=Sun, 1=Mon, etc.)" },
	{ 0xF93D, "Time for ON TIME interrupt (SSHHMM)" },
	{ 0xF944, "On Com flag" },
	{ 0xF945, "On Com routine address" },
	{ 0xF947, "On Time flag" },
	{ 0xF948, "On Time routine address" },
	{ 0xF94A, "Function key vector table" },
	{ 0xF962, "Start of RAM directory" },
	{ 0xF99A, "BASIC program not saved pointer" },
	{ 0xF9A5, "Start of Paste Buffer" },
	{ 0xFAAC, "Last char sent to printer" },
	{ 0xFAAD, "Label line enable flag" },
	{ 0xFAAE, "Contents of port A8H" },
	{ 0xFAAF, "Start of IPL filename" },
	{ 0xFABA, "Address where last BASIC list started" },
	{ 0xFABE, "SP save area for power up/down" },
	{ 0xFAC0, "Lowest RAM address used by system" },
	{ 0xFAC9, "Offset of last RST 38H call" },
	{ 0xFAD0, "Length of last program loaded/saved to tape" },
	{ 0xFADA, "Start of RST 38H vector table" },
	{ 0xFAE2, "LCD character output hook" },
	{ 0xFAE4, "Printer character output hook" },
	{ 0xFB00, "EOF function hook" },
	{ 0xFB0C, "Term F6 hook" },
	{ 0xFB0E, "Term F7 hook" },
	{ 0xFB14, "WIDTH statement hook" },
	{ 0xFB1A, "CRT open routine hook" },
	{ 0xFB1E, "CRT output file routine hook" },
	{ 0xFB20, "WAND Open routine hook" },
	{ 0xFB22, "WAND Close routine hook" },
	{ 0xFB24, "WAND Get routine hook" },
	{ 0xFB26, "WAND Special I/O routine hook" },
	{ 0xFB28, "LOF function hook" },
	{ 0xFB2A, "LOC function hook" },
	{ 0xFB2C, "LFILES statement hook" },
	{ 0xFB2E, "DSKI$ routine hook" },
	{ 0xFB30, "DSKO$ routine hook" },
	{ 0xFB64, "Variable Create/Locate switch" },
	{ 0xFB65, "Type of last variable used" },
	{ 0xFB67, "File buffer area pointer" },
	{ 0xFB94, "Line number of current data statement" },
	{ 0xFB96, "FOR/NEXT loop active flag" },
	{ 0xFB99, "Address of last variable assigned" },
	{ 0xFB9B, "Most recent or currenly running line pointer" },
	{ 0xFB9D, "SP used by BASIC to reinitialize the stack" },
	{ 0xFB9F, "Line number of last error" },
	{ 0xFBA1, "Most recent used or entered line number" },
	{ 0xFBA3, "Pointer to occurance of error" },
	{ 0xFBA5, "Address of ON ERROR routine" },
	{ 0xFBAA, "Line where break, END, or STOP occurred" },
	{ 0xFBAC, "Address where program stopped on last break, END, or STOP" },
	{ 0xFBAE, "Start of DO files pointer" },
	{ 0xFBB0, "Start of CO files pointer" },
	{ 0xFBB2, "Start of variable data pointer" },
	{ 0xFBB4, "Start of array table pointer" },
	{ 0xFBB6, "Unused memory pointer" },
	{ 0xFBB8, "Address where DATA search will begin next" },
	{ 0xFBBA, "DEF definition table" },
	{ 0xFBE7, "8-Byte floating point for double precision math" },
	{ 0xFC18, "Start of FAC1 for single and double precision" },
	{ 0xFC1A, "Start of FAC1 for integers" },
	{ 0xFC60, "8-Byte floating point for double precision math" },
	{ 0xFC69, "Start of FAC2 for single and double precision" },
	{ 0xFC6B, "Start of FAC2 for integers" },
	{ 0xFC82, "Maxfiles" },
	{ 0xFC83, "File number description table pointer" },
	{ 0xFC93, "Filename of current BASIC program" },
	{ 0xFC9C, "Filename of last program loaded from tape" },
	{ 0xFCC0, "Start of Alt LCD character buffer" },
	{ 0xFDA1, "Map of MENU entry positions to RAM directory positions" },
	{ 0xFDED, "Flag to indicate MENU entry location or command entry" },
	{ 0xFDEE, "Current MENU directory location" },
	{ 0xFDEF, "Maximum MENU directory location" },
	{ 0xFE00, "Start of LCD character buffer" },
	{ 0xFF40, "XON/XOFF protocol control" },
	{ 0xFF41, "XON/XOFF protocol control" },
	{ 0xFF42, "XON/XOFF enable flag" },
	{ 0xFF43, "RS232 initialization status" },
	{ 0xFF44, "Sound flag" },
	{ 0xFF45, "Contents of port E8H" },
	{ 0xFF46, "RS232 Character buffer" },
	{ 0xFF86, "RS232 buffer count" },
	{ 0xFF87, "RS232 buffer output position" },
	{ 0xFF88, "RS232 buffer input pointer" },
	{ 0xFF8A, "Control-S status" },
	{ 0xFF8B, "UART baud rate timer value" },
	{ 0xFF8D, "RS232 Parity Control byte" },
	{ 0xFF8E, "Cassette port pulse control" },
	{ 0xFF97, "Special key status storage" },
	{ 0xFF98, "Function key status storage" },
	{ 0xFF99, "Keyboard scan column storage #1" },
	{ 0xFFA2, "Keyboard scan column storage @2" },
	{ 0xFFA3, "Shift key status storage" },
	{ 0xFFA4, "Key repeat start delay counter" },
	{ 0xFFA6, "Key position storage" },
	{ 0xFFA8, "Pointer to entry in 2nd Storage Buffer for key" },
	{ 0xFFAA, "Keyboard buffer count" },
	{ 0xFFAB, "Keyboard typeahead buffer" },
	{ 0xFFEC, "Cursor bit pattern storage" },
	{ -1, "" }
};

Std_ROM_Addresses_t gM100_Funs[] = {
	{ 0x0000, "Reset Vector" },
	{ 0x0008, "Compare next byte with M" },
	{ 0x0010, "Get next non-white char from M" },
	{ 0x0018, "Compare DE and HL" },
	{ 0x001E, "Send a space to screen/printer" },
	{ 0x0020, "Send character in A to screen/printer" },
	{ 0x0024, "Power down TRAP" },
	{ 0x0028, "Determine type of last var used" },
	{ 0x002C, "RST 5.5 -- Bar Code Reader" },
	{ 0x0030, "Get sign of FAC1" },
	{ 0x0034, "RST 6.5 -- RS232 character pending" },
	{ 0x0038, "RAM vector table driver" },
	{ 0x003C, "RST 7.5 -- Timer background task" },
	{ 0x0040, "Function vector table for SGN to MID$" },
	{ 0x0080, "BASIC statement keyword table END to NEW" },
	{ 0x018F, "Function keyword table TAB to <" },
	{ 0x01F0, "Function keyword table SGN to MID$" },
	{ 0x0262, "BASIC statement vector table for END to NEW" },
	{ 0x02E2, "Math operator priority table" },
	{ 0x02EE, "Vector table for math operations" },
	{ 0x031C, "BASIC error message text" },
	{ 0x035A, "Initialization image loaded to F5F0H" },
	{ 0x036F, "External ROM detect image loaded at F605H" },
	{ 0x03EA, "BASIC message strings" },
	{ 0x0401, "Pop return address for NEXT or RETURN" },
	{ 0x0422, "Initialize system and go to BASIC ready" },
	{ 0x0446, "Generate Syntax error" },
	{ 0x0449, "Generate /0 error" },
	{ 0x044C, "Generate NF error" },
	{ 0x044F, "Generate DD error" },
	{ 0x0452, "Generate RW error" },
	{ 0x0455, "Generate OV error" },
	{ 0x0458, "Generate MO error" },
	{ 0x045B, "Generate TM error" },
	{ 0x045D, "Generate error in E" },
	{ 0x048D, "Restore stack & runtime and jump to BC" },
	{ 0x04C5, "Print BASIC error message - XX error in XXX" },
	{ 0x0501, "Pop stack and vector to BASIC ready" },
	{ 0x0502, "Vector to BASIC ready - print Ok" },
	{ 0x0511, "Silent vector to BASIC ready" },
	{ 0x0523, "Perform operation at M and return to ready" },
	{ 0x05F0, "Update line addresses for current BASIC program" },
	{ 0x05F0, "Update line addresses for current BASIC program" },
	{ 0x060A, "Evaluate LIST statement arguments" },
	{ 0x0628, "Find line number in DE" },
	{ 0x062B, "Find line number in DE starting at HL" },
	{ 0x0646, "Perform Token compression" },
	{ 0x0726, "FOR statement" },
	{ 0x076B, "TO statement" },
	{ 0x0783, "STEP statement" },
	{ 0x0804, "Execute BASIC program" },
	{ 0x083A, "Start executing BASIC program at HL" },
	{ 0x0840, "Execute instruction in A, HL points to args" },
	{ 0x0858, "RST 10H routine with pre-increment of HL" },
	{ 0x0858, "RST 10H routine" },
	{ 0x0872, "DEF statement" },
	{ 0x0881, "DEFDBL statement" },
	{ 0x0886, "DEFINT statement" },
	{ 0x0896, "DEFSNG statement" },
	{ 0x089F, "DEFSTR statement" },
	{ 0x08A1, "Declare variable at M to be type E" },
	{ 0x08DB, "Generate FC error" },
	{ 0x08E0, "Evaluate line number text at M" },
	{ 0x08EB, "Convert ASCII number at M to binary" },
	{ 0x08EC, "Convert ASCII number at M+1 to binary" },
	{ 0x090F, "RUN statement" },
	{ 0x091E, "GOSUB statement" },
	{ 0x0936, "GOTO statement" },
	{ 0x094D, "Generate UL error" },
	{ 0x0966, "RETURN statement" },
	{ 0x099E, "DATA statement" },
	{ 0x09A0, "REM statement" },
	{ 0x09C3, "LET statement" },
	{ 0x0A2F, "ON statement" },
	{ 0x0A34, "ON ERROR statement" },
	{ 0x0A5B, "ON KEY/TIME/COM/MDM GOSUB routine" },
	{ 0x0A94, "ON TIME$ handler" },
	{ 0x0AB0, "RESUME statement" },
	{ 0x0B0F, "ERROR statement" },
	{ 0x0B1A, "IF statement" },
	{ 0x0B4E, "LPRINT statement" },
	{ 0x0B56, "PRINT statement" },
	{ 0x0C01, "TAB statement" },
	{ 0x0C45, "LINE statement" },
	{ 0x0C99, "INPUT # statement" },
	{ 0x0CA3, "INPUT statement" },
	{ 0x0CD9, "READ statement" },
	{ 0x0DAB, "Main BASIC evaluation routine" },
	{ 0x0F0D, "Integer Divide FAC1=DE/HL" },
	{ 0x0F1C, "Evaluate function at M" },
	{ 0x0F47, "ERR function" },
	{ 0x0F56, "ERL function" },
	{ 0x0F7E, "VARPTR function" },
	{ 0x0F86, "VARPTR(#buffer) function" },
	{ 0x0F92, "VARPTR(variable) function" },
	{ 0x0FDA, "Evaluate variable" },
	{ 0x0FE8, "Get char at M and convert to uppercase" },
	{ 0x0FE9, "Convert A to uppercase" },
	{ 0x1037, "ASCII num conversion - find ASCII or tokenized '+' or '-' in A" },
	{ 0x1054, "NOT function" },
	{ 0x1069, "RST 28H routine" },
	{ 0x108C, "OR function" },
	{ 0x1097, "AND function" },
	{ 0x10A2, "XOR function" },
	{ 0x10AD, "EQV function" },
	{ 0x10B5, "IMP function" },
	{ 0x10C8, "LPOS function" },
	{ 0x10CE, "POS function" },
	{ 0x10D1, "Load integer in A into FAC1" },
	{ 0x10E6, "Check for running program" },
	{ 0x10EF, "Generate ID error" },
	{ 0x1100, "INP function" },
	{ 0x110C, "OUT statement" },
	{ 0x1112, "Evaluate expression at M" },
	{ 0x1113, "Evaluate expression at M-1" },
	{ 0x112D, "Evaluate expression at M" },
	{ 0x112E, "Evaluate expression at M-1" },
	{ 0x113B, "LLIST statement" },
	{ 0x1140, "LIST statement" },
	{ 0x11A2, "Send buffer at M to screen" },
	{ 0x1284, "PEEK function" },
	{ 0x128B, "POKE function" },
	{ 0x1297, "Evaluate expression at M" },
	{ 0x12CB, "Wait for key from keyboard" },
	{ 0x13A5, "Toggle function key label line" },
	{ 0x13DB, "Check keyboard queue for pending characters" },
	{ 0x1419, "POWER statement" },
	{ 0x1431, "Normal TRAP (low power) interrupt routine" },
	{ 0x143F, "Turn off computer" },
	{ 0x1459, "POWER CONT statement" },
	{ 0x1461, "POWER ON statement" },
	{ 0x1470, "Output character to printer" },
	{ 0x148A, "Start tape and load tape header" },
	{ 0x1494, "Generate I/O error" },
	{ 0x1499, "Turn cassette motor on and detect sync header" },
	{ 0x14A8, "Turn cassette motor on" },
	{ 0x14AA, "Turn cassette motor off" },
	{ 0x14B0, "Read byte from tape & update checksum" },
	{ 0x14C1, "Write byte to tape & update checksum" },
	{ 0x14D2, "LCD Device control block" },
	{ 0x14D8, "LCD and PRT file open routine" },
	{ 0x14E5, "Output to LCD file" },
	{ 0x14ED, "Pop AF, BC, DE, HL from stack" },
	{ 0x14F2, "CRT device control block" },
	{ 0x14FC, "RAM device control block" },
	{ 0x1506, "Open RAM file" },
	{ 0x158D, "Close RAM file" },
	{ 0x15AC, "Output to RAM file" },
	{ 0x15C4, "Input from RAM file" },
	{ 0x161B, "Special RAM file I/O" },
	{ 0x167F, "CAS device control block" },
	{ 0x1689, "Open CAS file" },
	{ 0x16AD, "Close CAS file" },
	{ 0x16C7, "Output to CAS file" },
	{ 0x16D2, "Input from CAS file" },
	{ 0x1754, "LPT device control block" },
	{ 0x175A, "Output to LPT file" },
	{ 0x1762, "COM device control block" },
	{ 0x176C, "Open MDM file" },
	{ 0x176D, "Open COM file" },
	{ 0x179E, "Close COM file" },
	{ 0x17A8, "Output to COM/MDM file" },
	{ 0x17B0, "Input from COM/MDM file" },
	{ 0x17CA, "Special COM/MDM file I/O" },
	{ 0x17D1, "MDM Device control block" },
	{ 0x17DB, "Close MDM file" },
	{ 0x17E6, "Set RS232 parameters from string at M" },
	{ 0x1877, "Wand device control block" },
	{ 0x1889, "EOF function" },
	{ 0x1904, "TIME$ function" },
	{ 0x190F, "Read time and store it at M" },
	{ 0x192F, "DATE$ function" },
	{ 0x1955, "DAY function" },
	{ 0x1962, "Read day and store at M" },
	{ 0x19A0, "Update in-memory (F923H) clock values" },
	{ 0x19AB, "TIME$ statement" },
	{ 0x19B3, "Update clock chip from memory F923H" },
	{ 0x19BD, "DATE$ statement" },
	{ 0x19F1, "DAY$ statement" },
	{ 0x1A42, "Get time string from command line" },
	{ 0x1A78, "IPL statement" },
	{ 0x1A96, "Erase current IPL program" },
	{ 0x1A9E, "COM and MDM statements" },
	{ 0x1AB2, "KEY() statement" },
	{ 0x1AC3, "KEY STOP/ON/OFF statements" },
	{ 0x1AEA, "Determine argument (ON/OFF/STOP) for TIME$ statement" },
	{ 0x1AFC, "Determine device (KEY/TIME/COM/MDM) for ON GOSUB" },
	{ 0x1B0F, "ON TIME$ statement" },
	{ 0x1B22, "ON COM handler" },
	{ 0x1B32, "RST 7.5 interrupt routine" },
	{ 0x1BB1, "Renew automatic power-off counter" },
	{ 0x1BB8, "KEY statement" },
	{ 0x1BBD, "KEY LIST statement" },
	{ 0x1BE0, "Send B characters from M to the screen" },
	{ 0x1C57, "PSET statement" },
	{ 0x1C66, "PRESET statement" },
	{ 0x1C6D, "LINE (graphic) statement" },
	{ 0x1CA6, "Draw a filled box on LCD. Coords are on stack" },
	{ 0x1CBC, "Draw an unfilled box on LCD. Coords are on stack" },
	{ 0x1D2E, "Get (X,Y) coordinate from tokenized string at M" },
	{ 0x1D90, "CSRLIN function" },
	{ 0x1D9B, "MAX function" },
	{ 0x1DA7, "MAXRAM function" },
	{ 0x1DB2, "MAXFILES function" },
	{ 0x1DB9, "HIMEM function" },
	{ 0x1DC3, "WIDTH statement" },
	{ 0x1DC5, "SOUND statement" },
	{ 0x1DE5, "SOUND OFF statement" },
	{ 0x1DE6, "SOUND ON statement" },
	{ 0x1DEC, "MOTOR statement" },
	{ 0x1DF1, "MOTOR ON statement" },
	{ 0x1DF5, "MOTOR OFF statement" },
	{ 0x1DFA, "CALL statement" },
	{ 0x1E22, "SCREEN statement" },
	{ 0x1E5E, "LCOPY statement" },
	{ 0x1F3A, "FILES statement" },
	{ 0x1F42, "Display Catalog" },
	{ 0x1F91, "KILL statement" },
	{ 0x1FBE, "Kill a text file" },
	{ 0x2037, "NAME statement" },
	{ 0x20FE, "NEW statement" },
	{ 0x21FA, "Count length of string at M" },
	{ 0x2206, "Get .DO filename and locate in RAM directory" },
	{ 0x220F, "Open a text file at (FC93H)" },
	{ 0x2280, "CSAVE statement" },
	{ 0x22B9, "Save buffer at M to tape" },
	{ 0x22CC, "SAVEM statement" },
	{ 0x22DD, "CSAVEM statement" },
	{ 0x2377, "CLOAD statement" },
	{ 0x2413, "Load record from tape and store at M" },
	{ 0x2478, "Generate Verify Failed error" },
	{ 0x2491, "LOADM and RUNM statement" },
	{ 0x24A7, "CLOADM statement" },
	{ 0x2542, "Move B bytes from M to (DE)" },
	{ 0x254B, "Launch .CO files from MENU" },
	{ 0x260B, "Open CAS for output of BASIC files" },
	{ 0x260E, "Open CAS for output of TEXT files" },
	{ 0x2611, "Open CAS for output of CO files" },
	{ 0x2650, "Open CAS for input of BASIC files" },
	{ 0x2653, "Open CAS for input of TEXT files" },
	{ 0x2656, "Open CAS for input of CO files" },
	{ 0x273A, "STR$ function" },
	{ 0x27B1, "Print buffer at M until NULL or '\"'" },
	{ 0x290F, "Move L bytes from (BC) to (DE)" },
	{ 0x2943, "LEN function" },
	{ 0x294F, "ASC function" },
	{ 0x295F, "CHR$ function" },
	{ 0x296D, "STRING$ function" },
	{ 0x298E, "SPACE$ function" },
	{ 0x29AB, "LEFT$ function" },
	{ 0x29DC, "RIGHT$ function" },
	{ 0x29E6, "MID$ function" },
	{ 0x2A07, "VAL function" },
	{ 0x2A37, "INSTR function" },
	{ 0x2B4C, "FRE function" },
	{ 0x2B69, "Double precision subtract (FAC1=FAC1-FAC2)" },
	{ 0x2B78, "Double precision addition (FAC1=FAC1+FAC2)" },
	{ 0x2C4F, "Add the BCD num in M to the one in (DE)" },
	{ 0x2CFF, "Double precision multiply (FAC1=FAC1*FAC2)" },
	{ 0x2DC7, "Double precision divide (FAC1=FAC1/FAC2)" },
	{ 0x2EE6, "Move C bytes from M to (DE)" },
	{ 0x2EEF, "COS function" },
	{ 0x2F09, "SIN function" },
	{ 0x2F58, "TAN function" },
	{ 0x2F71, "ATN function" },
	{ 0x2FCF, "LOG function" },
	{ 0x305A, "SQR function" },
	{ 0x30A4, "EXP function" },
	{ 0x313E, "RND function" },
	{ 0x31A0, "Double precision Square (FAC1=SQR(FAC1))" },
	{ 0x31A3, "Double precision math (FAC1=M * FAC2))" },
	{ 0x31B5, "Move FAC1 to FAC2" },
	{ 0x31B8, "Move floating point number M to FAC2" },
	{ 0x31C1, "Move FAC2 to FAC1" },
	{ 0x31C4, "Move floating point number M to FAC1" },
	{ 0x31CA, "Move FAC1 to M" },
	{ 0x31CA, "Double precision math (FAC1=FAC1*SQR(FAC1))" },
	{ 0x31CA, "Swap FAC1 and FAC2" },
	{ 0x31EB, "Square FAC1 & do table based math" },
	{ 0x31EB, "Square FAC1 & do table based math & muliply times FAC1" },
	{ 0x3209, "Table based math (FAC1=(((FAC1*M)+(M+1))*(M+2)+(M+3)..." },
	{ 0x322E, "Push FAC2 on stack" },
	{ 0x3234, "Push FAC1 on stack" },
	{ 0x3245, "Pop FAC2 from stack" },
	{ 0x324B, "Pop FAC1 from stack" },
	{ 0x325C, "Floating point numbers for math operations " },
	{ 0x327C, "Floating point num-shares 6 bytes from next number" },
	{ 0x327E, "Floating point numbers for math operations "},
	{ 0x32D6, "Count of Floating point numbers to follow for EXP" },
	{ 0x32F7, "Count of Floating point numbers to follow for EXP" },
	{ 0x3310, "Count of Floating point numbers to follow for LOG" },
	{ 0x3331, "Count of Floating point numbers to follow for LOG" },
	{ 0x335A, "Count of Floating point numbers to follow for SIN" },
	{ 0x339B, "Count of Floating point numbers to follow for ATN" },
	{ 0x33DC, "RST 30H routine" },
	{ 0x33F2, "ABS function" },
	{ 0x3407, "SGN function" },
	{ 0x3422, "Push single precision FAC1 on stack" },
	{ 0x342F, "Load single precision at M to FAC1" },
	{ 0x3432, "Load single precision in BCDE to FAC1" },
	{ 0x343D, "Load single precision FAC1 to BCDE" },
	{ 0x3447, "Load single precision at M to BCDE" },
	{ 0x3450, "Reverse load single precision at M to DEBC" },
	{ 0x3459, "Move single precision FAC1 to M" },
	{ 0x3461, "Move M to FAC2 using precision at (FB65H)" },
	{ 0x3469, "Move B bytes from (DE) to M with increment" },
	{ 0x3472, "Move B bytes from (DE) to M with decrement" },
	{ 0x3498, "Compare single precision in BCDE with FAC1" },
	{ 0x34B0, "Compare single precision in BCDE with M" },
	{ 0x34C2, "Compare signed integer in DE with that in HL" },
	{ 0x34FA, "Compare double precisoin FAC1 with FAC2" },
	{ 0x3501, "CINT function" },
	{ 0x3510, "Load signed integer in HL to FAC1" },
	{ 0x352A, "CSNG function" },
	{ 0x3540, "Convert signed integer in FAC1 to single precision" },
	{ 0x3543, "Convert signed integer HL to single precision FAC1" },
	{ 0x35BA, "CDBL function" },
	{ 0x3645, "FIX function" },
	{ 0x3654, "INT function" },
	{ 0x35F8, "Signed integer subtract (FAC1=HL-DE)" },
	{ 0x3704, "Signed integer addition (FAC1=HL+DE)" },
	{ 0x3725, "Signed integer muliply (FAC1=HL*DE)" },
	{ 0x377E, "Signed integer divide (FAC1=DE/HL)" },
	{ 0x37F4, "Single precision addition (FAC1=FAC1+BCDE)" },
	{ 0x37F7, "Single precision addition (FAC1=FAC1+FAC2)" },
	{ 0x37FD, "Single precision subtract (FAC1=FAC1-BCDE)" },
	{ 0x3803, "Single precision multiply (FAC1=FAC1*BCDE)" },
	{ 0x3806, "Single precision multiply (FAC1=FAC2*FAC2)" },
	{ 0x380E, "Single precision divide (FAC1=BCDE/FAC1)" },
	{ 0x3827, "Single precision load (FAC2=BCDE)" },
	{ 0x3840, "Convert ASCII number at M to double precision in FAC1" },
	{ 0x3867, "Found 'e' in ASCII number" },
	{ 0x388A, "Found 'E' in ASCII number" },
	{ 0x3904, "Found '.' in ASCII number" },
	{ 0x391A, "Found '%' in ASCII number" },
	{ 0x3929, "Found '#' in ASCII number" },
	{ 0x3931, "Deal with single & double precision ASCII conversions" },
	{ 0x3940, "Convert ASCII number that starts with a Digit" },
	{ 0x39CC, "Finish printing BASIC ERROR message \" in \" line #" },
	{ 0x39D4, "Print binary number in HL at current position" },
	{ 0x39E8, "Convert binary number in FAC1 to ASCII at M" },
	{ 0x39EC, "Convert binary number in FAC1 to ASCII at M with format" },
	{ 0x3D11, "Initialize FAC1 with 0.0 if it has no value" },
	{ 0x3D7F, "Single precision exponential function" },
	{ 0x3D8E, "Double precision exponential function" },
	{ 0x3DF7, "Integer exponential function" },
	{ 0x3FA0, "TIME$ ON statement" },
	{ 0x3FD2, "Trigger interrupt.  HL points to interrupt table" },
	{ 0x3FD2, "Clear interrupt.  HL points to interrupt table" },
	{ 0x3FB2, "TIME$ OFF statement" },
	{ 0x3FB9, "TIME$ STOP statement" },
	{ 0x4009, "Clear all COM, TIME, and KEY interrupt definitions" },
	{ 0x407F, "RESTORE statement" },
	{ 0x409A, "STOP statement" },
	{ 0x409F, "END statement" },
	{ 0x40DA, "CONT sttement" },
	{ 0x40F1, "Check if M is alpha character" },
	{ 0x40F2, "Check if A is alpha character" },
	{ 0x40F9, "CLEAR statement" },
	{ 0x4174, "NEXT statement" },
	{ 0x4222, "Send CRLF to screen or printer" },
	{ 0x4225, "Send LF to screen or printer" },
	{ 0x4229, "BEEP statement" },
	{ 0x422D, "Home cursor" },
	{ 0x4231, "CLS statement" },
	{ 0x4235, "Protect line 8.  An ESC T is printed" },
	{ 0x423A, "Unprotect line 8.  An ESC U is printed" },
	{ 0x423F, "Stop automatic scrolling" },
	{ 0x4244, "Resume automatic scrolling" },
	{ 0x4249, "Turn the cursor on" },
	{ 0x424E, "Turn the cursor off" },
	{ 0x4253, "Delete current line on screen" },
	{ 0x4258, "Insert line a current line" },
	{ 0x425D, "Erase from cursor to end of line" },
	{ 0x4262, "Send ESC X" },
	{ 0x4269, "Start inverse character mode" },
	{ 0x426E, "Cancel inverse character mode" },
	{ 0x4270, "End escape sequence" },
	{ 0x4277, "Send cursor to lower left of CRT" },
	{ 0x427C, "Set the current cursor position (H=Row,L=Col)" },
	{ 0x428A, "Erase function key display" },
	{ 0x42A5, "Set and display function keys (M has key table)" },
	{ 0x42A8, "Display function key line" },
	{ 0x4313, "Print A to the screen" },
	{ 0x4431, "Character plotting level 3. Check new device console flag & call level 4)" },
	{ 0x4335, "Character plotting level 4. Turn off background task & call level 5" },
	{ 0x434C, "Character plotting level 5. Handle ESC sequences & call level 6" },
	{ 0x4373, "LCD output driver" },
	{ 0x438A, "RST 20H lookup table" },
	{ 0x43AF, "ESC Y routine (Set cursor position)" },
	{ 0x43B2, "LCD output Escape routine" },
	{ 0x43B8, "LCD Escape sequence lookup table" },
	{ 0x43FA, "ESCape sequence driver" },
	{ 0x4431, "ESC p routine (start inverse video)" },
	{ 0x4432, "ESC q routine (cancel inverse video)" },
	{ 0x4437, "ESC U routine (unprotect line 8)" },
	{ 0x4439, "ESC T routine (protect line 8)" },
	{ 0x443F, "ESC V routine (stop automatic scrolling)" },
	{ 0x4440, "ESC W routine (resume automatic scrolling)" },
	{ 0x443A, "ESC X routine" },
	{ 0x4453, "ESC C routine (move cursor right)" },
	{ 0x445C, "ESC D routine (move cursor left)" },
	{ 0x4461, "Backspace routine" },
	{ 0x4469, "ESC A routine (move cursor up)" },
	{ 0x446E, "ESC B routine (move cursor down)" },
	{ 0x4480, "Tab routine" },
	{ 0x4494, "Linefeed routine" },
	{ 0x44A8, "Verticle tab and ESC H routine (home cursor)" },
	{ 0x44AA, "CR routine" },
	{ 0x44AF, "ESC P routine (turn cursor on)" },
	{ 0x44BA, "ESC Q routine (turn cursor off)" },
	{ 0x44C4, "ESC M routine" },
	{ 0x44D2, "Scroll LCD screen A times at line number in L" },
	{ 0x44EA, "ESC L routine (insert line)" },
	{ 0x4512, "Get character at (H,L) from LCD RAM)" },
	{ 0x4535, "ESC l routine (erase current line)" },
	{ 0x4537, "ESC K routine (erase to EOL)" },
	{ 0x4548, "Form Feed (0CH), CLS, ESC E, and ESC J routine" },
	{ 0x4560, "Character plotting level 6.  Save character in C to LCD RAM & call level 7" },
	{ 0x454E, "ESC J routine" },
	{ 0x463E, "Input and display line and store at (F685H)" },
	{ 0x4644, "Input and display (no \"?\") line and store at (F685H)" },
	{ 0x4684, "Input routine (463EH) Control-C handler" },
	{ 0x4696, "Input routine (463EH) ENTER handler" },
	{ 0x46A0, "Input routine (463EH) backspace, left arrow, CTRL-H handler" },
	{ 0x46C3, "Input routine (463EH) CTRL-U & X handler" },
	{ 0x46CA, "Input routine (463EH) Tab handler" },
	{ 0x478B, "DIM statement" },
	{ 0x4790, "Find address of variable at M" },
	{ 0x4991, "USING function" },
	{ 0x4B44, "Send A to screen or printer" },
	{ 0x4B55, "Print A to printer, expanding tabs if necessary" },
	{ 0x4B92, "Reinitialize output back to LCD" },
	{ 0x4BAB, "LCD character output routine" },
	{ 0x4BB8, "Move LCD to blank line (send CRLF if needed)" },
	{ 0x4BEA, "INKEY$ function" },
	{ 0x4C84, "Get file descriptor for file in A" },
	{ 0x4CCB, "OPEN statement" },
	{ 0x4D59, "LCD, CRT, and LPT file close routine" },
	{ 0x4D6E, "RUN statement (with parameters)" },
	{ 0x4D70, "LOAD statement" },
	{ 0x4D71, "MERGE statement" },
	{ 0x4DCF, "SAVE statement" },
	{ 0x4E28, "CLOSE statement" },
	{ 0x4E8E, "INPUT$ function" },
	{ 0x4F0A, "Zero B bytes at M" },
	{ 0x4F0B, "Load B bytes at M with A" },
	{ 0x4F2E, "PRINT # initialization routine" },
	{ 0x4F5B, "LINE INPUT # statement" },
	{ 0x504E, "Generate NM error" },
	{ 0x5051, "Generate AO error" },
	{ 0x5054, "Generate DS error" },
	{ 0x5057, "Generate FF error" },
	{ 0x505A, "Generate CF error" },
	{ 0x505D, "Generate BN error" },
	{ 0x5060, "Generate IE error" },
	{ 0x5063, "Generate EF error" },
	{ 0x5066, "Generate FL error" },
	{ 0x506B, "LOF function" },
	{ 0x506D, "LOC function" },
	{ 0x506F, "LFILES function" },
	{ 0x5071, "DSKO$ function" },
	{ 0x5073, "DSKI$ function" },
	{ 0x50F1, "Device name table" },
	{ 0x5113, "Device control block vector addresses table" },
	{ 0x5146, "TELCOM Entry point" },
	{ 0x515B, "Re-entry point for TELCOM commands" },
	{ 0x5185, "TELCOM instruction vector table" },
	{ 0x51A4, "TELCOM label line text table" },
	{ 0x51C0, "TELCOM STAT instruction routine" },
	{ 0x51C7, "Print current STAT settings" },
	{ 0x51ED, "Set STAT and return to TELCOM ready" },
	{ 0x522F, "TELCOM CALL instruction routine" },
	{ 0x524D, "TELCOM FIND instruction routine" },
	{ 0x52B4, "Go off-hook" },
	{ 0x52BB, "Disconnect phone line and disable modem carrier" },
	{ 0x52D0, "Connect phone line and enable modem carrier" },
	{ 0x52E4, "Go off-hook and wait for carrier" },
	{ 0x5310, "Pause for about 2 seconds" },
	{ 0x532D, "Execute logon sequence at M" },
	{ 0x5359, "Dialing routine" },
	{ 0x539E, "Auto logon sequence" },
	{ 0x540A, "Dial the digit in A & print on LCD" },
	{ 0x5455, "TELCOM TERM instruction routine" },
	{ 0x54FC, "TELCOM \"dispatcher\" routine" },
	{ 0x550D, "TERM Mode function key vector table" },
	{ 0x5523, "TELCOM PREV function routine" },
	{ 0x553E, "TELCOM FULL/HALF function routine" },
	{ 0x5550, "TELCOM ECHO function routine" },
	{ 0x559D, "TELCOM UP function routine" },
	{ 0x567E, "TELCOM DOWN function routine" },
	{ 0x571E, "TELCOM BYE function routine" },
	{ 0x5791, "Print buffer at M until NULL or \"" },
	{ 0x5797, "MENU Program" },
	{ 0x57F8, "Display directory entries" },
	{ 0x5837, "Handle CTRL-U key from MENU command loop" },
	{ 0x585A, "MENU Program command loop" },
	{ 0x588E, "Handle Backspace key from MENU command loop" },
	{ 0x58F7, "Handle ENTER key from MENU command loop" },
	{ 0x596F, "Launch ROM command file from MENU program" },
	{ 0x5970, "Display directory entries of type in register C" },
	{ 0x59AD, "Convert filename from space padded to '.ext' format" },
	{ 0x59C9, "Position cursor for next directory entry" },
	{ 0x5A12, "Print time, day and date on first line of screen" },
	{ 0x5A15, "Print time,day,date on first line w/o CLS" },
	{ 0x5A58, "Print NULL terminated string at M" },
	{ 0x5A62, "Copy A bytes from (DE) to M" },
	{ 0x5A6D, "Compare string at DE with that at M (max C bytes)" },
	{ 0x5A79, "Clear function key definition table" },
	{ 0x5A7C, "Set new function key table" },
	{ 0x5A9E, "Display function keys on 8th line" },
	{ 0x5AA9, "Search directory for filename" },
	{ 0x5AE3, "Get start address of file at M" },
	{ 0x5B1E, "Directory file-type display order table" },
	{ 0x5B68, "ADDRSS Entry point" },
	{ 0x5B6B, "ADDRSS entry with (DE) pointing to filename" },
	{ 0x5B6F, "SCHEDL Entry point" },
	{ 0x5B72, "SCHEDL entry with (DE) pointing to filename" },
	{ 0x5BF5, "FIND instruction for ADDRSS/SCHEDL" },
	{ 0x5BF7, "LFND instruction for ADDRSS/SCHEDL" },
	{ 0x5C3F, "Find text at M in the file at (DE)" },
	{ 0x5C6D, "Increment DE past next CRLF in text file at (DE)" },
	{ 0x5C74, "Check next byte(s) at (DE) for CRLF" },
	{ 0x5CEF, "ADDRSS/SCHEDL instruction vector table" },
	{ 0x5D64, "Wait for char from keyboard & convert to uppercase" },
	{ 0x5D6A, "Home cursor" },
	{ 0x5D70, "Print time on top line until key pressed" },
	{ 0x5DEE, "TEXT Entry point" },
	{ 0x5E22, "TEXT Function key table - empty" },
	{ 0x5E51, "EDIT statement" },
	{ 0x5F2F, "Wait for a space to be entered on keyboard" },
	{ 0x5F65, "Edit .DO files" },
	{ 0x5FDD, "Main TEXT edit loop" },
	{ 0x6018, "TEXT control character vector table" },
	{ 0x6056, "TEST ESCape routine" },
	{ 0x607C, "TEXT control P routine" },
	{ 0x608A, "TEXT control I routine" },
	{ 0x60BE, "TEXT control M routine" },
	{ 0x60DE, "TEXT right arrow and control D routine" },
	{ 0x60E2, "TEXT down arrow and control X routine" },
	{ 0x610B, "TEXT control H routine" },
	{ 0x6151, "TEXT left arrow and control S routine" },
	{ 0x6155, "TEXT up arrow and control E routine" },
	{ 0x617A, "TEXT control F routine" },
	{ 0x618C, "TEXT control A routine" },
	{ 0x61C2, "TEXT control T routine" },
	{ 0x61D7, "TEXT control B routine" },
	{ 0x61FD, "TEXT control R routine" },
	{ 0x620B, "TEXT control Q routine" },
	{ 0x6210, "TEXT control W routine" },
	{ 0x621C, "TEXT control Z routine" },
	{ 0x6242, "TEXT control L routine" },
	{ 0x628F, "TEXT control C routine" },
	{ 0x63E5, "Get next byte for TEXT Program entry" },
	{ 0x6431, "TEXT control O routine" },
	{ 0x6445, "TEXT control U routine" },
	{ 0x6551, "TEXT control N routine" },
	{ 0x65C3, "Copy NULL terminated string at M to (DE)" },
	{ 0x6691, "TEXT control Y routine" },
	{ 0x6713, "TEXT control G routine" },
	{ 0x6774, "TEXT control V routine" },
	{ 0x6B61, "Insert A into text file at M" },
	{ 0x6B6D, "Insert BC spaces at M" },
	{ 0x6B9F, "Delete BC characters at M" },
	{ 0x6BDB, "Move BC bytes from M to (DE) with increment" },
	{ 0x6BE6, "Move BC bytes from M to (DE) with decrement" },
	{ 0x6BF1, "ROM programs catalog entries" },
	{ 0x6C49, "BASIC Entry point" },
	{ 0x6C93, "Copy BASIC Function key table to key definition area" },
	{ 0x6C9C, "Copy BASIC Function key table to key definition area" },
	{ 0x6CD6, "Re-initialize system without destroying files" },
	{ 0x6CE0, "Warm start reset entry" },
	{ 0x6D3F, "Send character in A to the printer" },
	{ 0x6D6D, "Check RS232 queue for pending characters" },
	{ 0x6D7E, "Get a character from RS232 receive queue" },
	{ 0x6DAC, "RST 6.5 routine (RS232 receive interrupt)" },
	{ 0x6DFC, "Calculate address to save next RS232 character" },
	{ 0x6E0B, "Send XON (CTRL-Q) out RS232" },
	{ 0x6E1E, "Turn off XON/XOFF protocol" },
	{ 0x6E32, "Send character in A to serial port using XON/XOFF" },
	{ 0x6E3A, "Send character in C to serial port" },
	{ 0x6E4D, "Handle XON/XOFF protocol" },
	{ 0x6E75, "Set RS232 baud rate stored in H" },
	{ 0x6E94, "RS232 baud rate timer values" },
	{ 0x6EA6, "Initialize RS232 or modem" },
	{ 0x6ECB, "Deactivate RS232 or modem" },
	{ 0x6EE5, "Click sound port if sound enabled" },
	{ 0x6EEF, "Check for carrier detect" },
	{ 0x6F31, "Enable XON/OFF when CTRL-S / CTRL-Q sent" },
	{ 0x6F39, "Initialize serial buffer parameters" },
	{ 0x6F46, "Write cassette header and sync byte" },
	{ 0x6F5B, "Write char in A to cassette w/o checksum" },
	{ 0x6F5B, "Write char in A to cassette w/o checksum or sync bit" },
	{ 0x6F6A, "Write bit 0 of A to cassette" },
	{ 0x6F85, "Read cassette header and sync byte" },
	{ 0x6FDB, "Read Cassette port data bit" },
	{ 0x7023, "Count and pack cassette input bits" },
	{ 0x702A, "Read character from cassette w/o checksum" },
	{ 0x7043, "Cassette REMOTE routine - turn motor on or off" },
	{ 0x7055, "Keyboard scanning management routine" },
	{ 0x7060, "Key detection -- Determine which keys are pressed" },
	{ 0x70B0, "Key repeat detection" },
	{ 0x70B0, "Calculate key matrix position and save buffer pointer at FFA8H" },
	{ 0x7122, "Key detected - initialize repeat counter and decode" },
	{ 0x7122, "Key decoding" },
	{ 0x71D5, "Keyboard buffer management - place key in new buffer" },
	{ 0x71D5, "Keyboard buffer management - place subsequent key in buffer" },
	{ 0x71F7, "Interrupt exit routine (pop all regs & RET)" },
	{ 0x720A, "Handle unshifted & non-CTRL key during key decoding" },
	{ 0x7222, "Handle Arrow keys during key decoding" },
	{ 0x722C, "Handle CAPS LOCK key during key decoding" },
	{ 0x7233, "Handle NUM key during key decoding" },
	{ 0x7242, "Scan keyboard for character (CTRL-BREAK ==> CTRL-C)" },
	{ 0x726A, "Enable interrupts as normal" },
	{ 0x7270, "Check keyboard queue for pending characters" },
	{ 0x7283, "Check for break or wait (CTRL-S)" },
	{ 0x729F, "Check if SHIFT-BREAK is being pressed" },
	{ 0x72B1, "Scan BREAK,CAPS,NUM,CODE,GRAPH,CTRL,SHIFT & set bits in A" },
	{ 0x72C5, "Produce a tone of DE freq and B duration" },
	{ 0x7329, "Copy clock chip regs to M" },
	{ 0x732A, "Update clock chip regs from M" },
	{ 0x7352, "Read next bit from Clock Chip" },
	{ 0x7383, "Set clock chip mode" },
	{ 0x73A9, "Blink the cursor" },
	{ 0x744C, "Plot (set) point (D,E) on the LCD" },
	{ 0x73EE, "Character plotting level 7.  Plot character in C on LCD at (H,L)" },
	{ 0x744D, "Clear (reset) point (D,E) on the LCD" },
	{ 0x74A2, "Byte Plot - Send bit pattern to LCD for character" },
	{ 0x753B, "Enable LCD drivers after short delay" },
	{ 0x7548, "Wait for LCD driver to be available" },
	{ 0x7551, "8155 PIO chip bit patterns for LCD drivers" },
	{ 0x7643, "8155 PIO chip bit patterns for LCD drivers" },
	{ 0x7657, "Delay routine - decrement C until zero" },
	{ 0x765C, "Set interrupt to 1DH" },
	{ 0x7662, "Beep routine" },
	{ 0x7676, "Click sound port" },
	{ 0x7682, "Check for optional external controller" },
	{ 0x768F, "Optional external controller driver" },
	{ 0x7711, "LCD char generator shape table (20H-7FH" },
	{ 0x78F1, "LCD char generator shape table (80H-FFH)" },
	{ 0x7BF1, "Keyboard conversion matrix" },
	{ 0x7D33, "Boot routine" },
	{ 0x7DE7, "Cold boot routine" },
	{ 0x7EA6, "Display TRS-80 Model number & Free bytes on LCD" },
	{ 0x7EAC, "Display number of free bytes on LCD" },
	{ 0x7EAC, "Initialize RST 38H RAM vector table" },
	{ 0x7EE1, "Calculate physical RAM available" },
	{ 0x7F01, "Initial clock chip register values" },
	{ 0x7F98, "MENU Text Strings" },
	{ 0x7FD6, "RST 38H RAM vector driver routine" },
	{ 0xF5F9, "RST 5.5 RAM Vector" },
	{ 0xF5FC, "RST 6.5 RAM Vector" },
	{ 0xF5FF, "RST 7.5 RAM Vector" },
	{ 0xF602, "RAM vector for TRAP interrupt" },
	{ 0xF605, "Detect Option ROM" },
	{ -1, "" },
};

RomDescription_t gM100_Desc = {
	gM100_Tables,
	gM100_Vars,
	gM100_Funs
};