/* m100rom.c */

/* $Id: romstrings.c,v 1.3 2008/03/26 09:38:33 kpettit1 Exp $ */

/*
 * Copyright 2004 Stephen Hurd and Ken Pettit
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "roms.h"
#include "romstrings.h"

Std_ROM_Strings_t gDisStrings[] = {
	{ R_FUN_VCTR_TBL,			"Function vector table for SGN to MID$" },
	{ R_BASIC_TBL,				"BASIC statement keyword table END to NEW" },
	{ R_FUN_TBL_TAB,			"Function keyword table TAB to <" },
	{ R_FUN_TBL_SGN,			"Function keyword table SGN to MID$" },
	{ R_BASIC_VCTR_TBL,			"BASIC statement vector table for END to NEW" },
	{ R_MATH_VCTR_TBL,			"Vector table for math operations" },
	{ R_BASIC_ERR_TXT,			"BASIC error message text" },
	{ R_INIT_IMAGE,				"Initialization image loaded to F5F0H" },
	{ R_XROM_DET_IMAGE,			"External ROM detect image loaded at F605H" },
	{ R_BASIC_STRINGS,			"BASIC message strings" },
	{ R_CAS_FREQ_CNT,			"Cassette frequency cycle count" },
	{ R_TERM_FKEY_VCTR_TBL,		"TERM Mode function key vector table" },
	{ R_DIR_DISP_ORDER_TBL,		"Directory file-type display order table" },
	{ R_TEXT_FKEY_VCTR_TBL,		"TEXT Function key table - empty" },
	{ R_ROM_CAT_ENTRIES,		"ROM programs catalog entries" },
	{ R_INT_EXIT_FUN,			"Interrupt exit routine (pop all regs & RET)" },
	{ R_8155_PIO_PAT1,			"8155 PIO chip bit patterns for Upper LCD drivers" },
	{ R_8155_PIO_PAT2,			"8155 PIO chip bit patterns for Lower LCD drivers" },
	{ R_INIT_CLK_VALUES,		"Initial clock chip register values" },
	{ R_MENU_STRINGS,			"MENU Text Strings" },
	{ R_MODEL_NUM_STRING,		"TRS-80 model number string" },
	{ R_ACTIVE_SIGNATURE,		"Active system signature -- Warm vs Cold boot" },
	{ R_HIMEM,					"HIMEM" },
	{ R_RST_5_5_VCTR,			"RST 5.5 RAM Vector" },
	{ R_RST_6_5_VCTR,			"RST 6.5 RAM Vector" },
	{ R_RST_7_5_VCTR,			"RST 7.5 RAM Vector" },
	{ R_TRAP_VCTR,            	"RAM vector for TRAP interrupt" },
	{ R_OPTION_ROM_FLAG,      	"Option ROM flag" },
	{ R_DIAL_SPEED,           	"Dial speed (1=10pps, 2=20pps" },
	{ R_FKEY_STAT_TBL,        	"Function key status table (1 = on)" },
	{ R_NEW_CONSOLE_FLAG,     	"New Console device flag" },
	{ R_CURSOR_ROW,           	"Cursor row (1-8)" },
	{ R_CURSOR_COL,           	"Cursor column (1-40)" },
	{ R_ACTIVE_ROW_CNT,       	"Active rows count (1-8)" },
	{ R_ACTIVE_COL_CNT,       	"Active columns count (1-40)" },
	{ R_LABEL_LINE_PROT,      	"Label line protect status" },
	{ R_SCROLL_DISABLE,       	"Scroll disable flag" },
	{ R_CURSOR_STAT,          	"Cursor status (0 = off)" },
	{ R_CURSOR_ROW2,          	"Cursor row (1-8)" },
	{ R_CURSOR_COL2,          	"Cursor column (1-40)" },
	{ R_ESC_MODE_FLAG,        	"ESC mode flag for RST 20H" },
	{ R_REV_VID_SWITCH,       	"Reverse video switch" },
	{ R_LAST_PLOT_X,          	"X coord of last point plotted" },
	{ R_LAST_PLOT_Y,          	"Y coord of last point plotted" },
	{ R_PWR_OFF_STAT,         	"Power off exit condition switch" },
	{ R_DUPLEX_SWITCH,        	"Full/Half duplex switch" },
	{ R_RS232_LF_SWITCH,      	"RS232 auto linefeed switch" },
	{ R_RS232_PARAM_TBL,      	"RS232 parameter setting table" },
	{ R_ADDRESS_LAST_CALLED,  	"Address last called" },
	{ R_OUT_STMT_HOOK,        	"OUT statement hook" },
	{ R_INP_STMT_HOOK,        	"INP function hook" },
	{ R_LAST_ERROR_CODE,      	"Last Error code" },
	{ R_LPT_HEAD_POS,         	"Line printer head position" },
	{ R_OUTPUT_DEVICE,        	"Output device for RST 20H (0=screen)" },
	{ R_BASIC_STR_BUF_PTR,    	"BASIC string buffer pointer" },
	{ R_CUR_BASIC_LINE_NUM,   	"Current executing line number" },
	{ R_START_BASIC_PGM_PTR,  	"Start of BASIC program pointer" },
	{ R_END_OF_STMT_MARKER,   	"End of statement marker" },
	{ R_KEYBOARD_BUF,         	"Keyboard buffer" },
	{ R_CURSOR_H_POS,         	"Horiz. position of cursor (0-39)" },
	{ R_FKEY_DEF_BUF,         	"Function key definition area" },
	{ R_BASIC_FKEY_DEF_BUF,   	"Function key definition area (BASIC)" },
	{ R_FILE_RAM_END,         	"End of RAM for file storage" },
	{ R_SEC_ONES,             	"Seconds (ones)" },
	{ R_SEC_TENS,             	"Seconds (tens)" },
	{ R_MIN_ONES,             	"Minutes (ones)" },
	{ R_MIN_TENS,             	"Minutes (tens)" },
	{ R_HR_ONES,              	"Hours (ones)" },
	{ R_HR_TENS,              	"Hours (tens)" },
	{ R_DATE_ONES,            	"Date (ones)" },
	{ R_DATE_TENS,            	"Date (tens)" },
	{ R_DAY_CODE,             	"Day code (0=Sun, 1=Mon, etc.)" },
	{ R_MONTH,                	"Month (1-12)" },
	{ R_YEAR_ONES,            	"Year (ones)" },
	{ R_YEAR_TENS,            	"Year (tens)" },
	{ R_SEC_ONES2,            	"Seconds (ones)" },
	{ R_SEC_TENS2,            	"Seconds (tens)" },
	{ R_MIN_ONES2,            	"Minutes (ones)" },
	{ R_MIN_TENS2,            	"Minutes (tens)" },
	{ R_HR_ONES2,             	"Hours (ones)" },
	{ R_HR_TENS2,             	"Hours (tens)" },
	{ R_DATE_ONES2,           	"Date (ones)" },
	{ R_DATE_TENS2,           	"Date (tens)" },
	{ R_DAY_CODE2,            	"Day code (0=Sun, 1=Mon, etc.)" },
	{ R_ONTIME_TIME,          	"Time for ON TIME interrupt (SSHHMM)" },
	{ R_ONCOM_FLAG,           	"On Com flag" },
	{ R_ONCOM_ADDRESS,        	"On Com routine address" },
	{ R_ONTIME_FLAG,          	"On Time flag" },
	{ R_ONTIME_ADDRESS,       	"On Time routine address" },
	{ R_FKEY_VCTR_TBL,        	"Function key vector table" },
	{ R_DIR_RAM_START,        	"Start of RAM directory" },
	{ R_UNSAVED_BASIC_PTR,    	"BASIC program not saved pointer" },
	{ R_PASTE_RAM_START,      	"Start of Paste Buffer" },
	{ R_LAST_CHAR_PRINTED,    	"Last char sent to printer" },
	{ R_LABEL_ENABLE_FLAG,    	"Label line enable flag" },
	{ R_PORT_A8H,             	"Contents of port A8H" },
	{ R_IPL_FILENAME_START,   	"Start of IPL filename" },
	{ R_BASIC_LIST_START,     	"Address where last BASIC list started" },
	{ R_SP_SAVE_BUF,          	"SP save area for power up/down" },
	{ R_LOWEST_RAM,           	"Lowest RAM address used by system" },
	{ R_RST_38H_OFFSET,       	"Offset of last RST 38H call" },
	{ R_LAST_PGRM_LEN,        	"Length of last program loaded/saved to tape" },
	{ R_RST_38H_VCTR_TBL,     	"Start of RST 38H vector table" },
	{ R_LCD_OUTPUT_HOOK,      	"LCD character output hook" },
	{ R_LPT_OUTPUT_HOOK,      	"Printer character output hook" },
	{ R_EOF_FUN_HOOK,         	"EOF function hook" },
	{ R_TERM_F6_HOOK,         	"Term F6 hook" },
	{ R_TERM_F7_HOOK,         	"Term F7 hook" },
	{ R_WIDTH_STMT_HOOK,      	"WIDTH statement hook" },
	{ R_CRT_OPEN_HOOK,        	"CRT open routine hook" },
	{ R_CRT_OUTPUT_HOOK,      	"CRT output file routine hook" },
	{ R_WAND_OPEN_HOOK,       	"WAND Open routine hook" },
	{ R_WAND_CLOSE_HOOK,      	"WAND Close routine hook" },
	{ R_WAND_GET_HOOK,        	"WAND Get routine hook" },
	{ R_WAND_IO_HOOK,         	"WAND Special I/O routine hook" },
	{ R_LOF_HOOK,             	"LOF function hook" },
	{ R_LOC_HOOK,             	"LOC function hook" },
	{ R_LFILES_HOOK,          	"LFILES statement hook" },
	{ R_DSKI_HOOK,            	"DSKI$ routine hook" },
	{ R_DSKO_HOOK,            	"DSKO$ routine hook" },
	{ R_VAR_CREATE_LOC_FLAG,  	"Variable Create/Locate switch" },
	{ R_LAST_VAR_TYPE,        	"Type of last variable used" },
	{ R_FILE_BUF_PTR,         	"File buffer area pointer" },
	{ R_DATA_STMT_LINE_NUM,   	"Line number of current data statement" },
	{ R_FOR_NEXT_ACTIVE_FLAG, 	"FOR/NEXT loop active flag" },
	{ R_LAST_VAR_ASSIGNED_ADDR,	"Address of last variable assigned" },
	{ R_RUNNING_LINE_NUM_ADDR,	"Most recent or currenly running line pointer" },
	{ R_BASIC_SP_BUF,         	"SP used by BASIC to reinitialize the stack" },
	{ R_LAST_ERR_LINE_NUM,    	"Line number of last error" },
	{ R_LAST_ENTERED_LINE_NUM,	"Most recent used or entered line number" },
	{ R_ERR_PTR,              	"Pointer to occurance of error" },
	{ R_ONERROR_ADDRESS,      	"Address of ON ERROR routine" },
	{ R_BREAK_LINE_NUM,       	"Line where break, END, or STOP occurred" },
	{ R_BREAK_ADDRESS,        	"Address where program stopped on last break, END, or STOP" },
	{ R_DO_FILES_PTR,         	"Start of DO files pointer" },
	{ R_CO_FILES_PTR,         	"Start of CO files pointer" },
	{ R_VAR_PTR,              	"Start of variable data pointer" },
	{ R_ARRAY_TBL_PTR,        	"Start of array table pointer" },
	{ R_UNUSED_MEM_PTR,       	"Unused memory pointer" },
	{ R_DATA_SEARCH_ADDR,     	"Address where DATA search will begin next" },
	{ R_DEF_TBL,              	"DEF definition table" },
	{ R_FP_TEMP1,           	"Floating Point Temp 1" },
	{ R_FP_TEMP2,           	"Floating Point Temp 2" },
	{ R_FP_TEMP3,           	"Floating Point Temp 3" },
	{ R_FP_FAC1,              	"Start of FAC1 for single and double precision" },
	{ R_INT_FAC1,             	"Start of FAC1 for integers" },
	{ R_FP_FAC2,              	"Start of FAC2 for single and double precision" },
	{ R_INT_FAC2,             	"Start of FAC2 for integers" },
	{ R_MAXFILES,             	"Maxfiles" },
	{ R_FILE_NUM_TBL_PTR,     	"File number description table pointer" },
	{ R_BASIC_FILENAME,       	"Filename of current BASIC program" },
	{ R_LAST_LOAD_FILENAME,   	"Filename of last program loaded from tape" },
	{ R_ALT_LCD_CHAR_BUF,     	"Start of Alt LCD character buffer" },
	{ R_MENU_TO_RAM_MAP,      	"Map of MENU entry positions to RAM directory positions" },
	{ R_MENU_OR_CMD_FLAG,     	"Flag to indicate MENU entry location or command entry" },
	{ R_CUR_MENU_DIR_LOC,     	"Current MENU directory location" },
	{ R_MAX_MENU_DIR_LOC,     	"Maximum MENU directory location" },
	{ R_LCD_CHAR_BUF,         	"Start of LCD character buffer" },
	{ R_XON_XOFF_CTRL,        	"XON/XOFF protocol control" },
	{ R_XON_XOFF_ENABLE,      	"XON/XOFF enable flag" },
	{ R_RS232_INIT_STAT,      	"RS232 initialization status" },
	{ R_SOUND_FLAG,           	"Sound flag" },
	{ R_PORT_E8H,             	"Contents of port E8H" },
	{ R_RS232_CHAR_BUF,       	"RS232 Character buffer" },
	{ R_RS232_BUF_CNT,        	"RS232 buffer count" },
	{ R_RS232_BUF_OUT,        	"RS232 buffer output position" },
	{ R_RS232_BUF_IN,         	"RS232 buffer input pointer" },
	{ R_CTRL_S_STAT,          	"Control-S status" },
	{ R_UART_BAUD_TIMER_VAL,  	"UART baud rate timer value" },
	{ R_RS232_PARITY_CTRL,    	"RS232 Parity Control byte" },
	{ R_CAS_PULSE_CTRL,       	"Cassette port pulse control" },
	{ R_SPEC_KEY_STAT,        	"Special key status storage" },
	{ R_FKEY_STAT,            	"Function key status storage" },
	{ R_KEY_SCAN_STORAGE1,    	"Keyboard scan column storage #1" },
	{ R_KEY_SCAN_STORAGE2,    	"Keyboard scan column storage @2" },
	{ R_SHIFT_KEY_STAT,       	"Shift key status storage" },
	{ R_KEY_REPT_START,       	"Key repeat start delay counter" },
	{ R_KEY_POSITION,         	"Key position storage" },
	{ R_2ND_KEY_BUF_PTR,      	"Pointer to entry in 2nd Storage Buffer for key" },
	{ R_KEY_BUF_CNT,          	"Keyboard buffer count" },
	{ R_KEY_TYPEAHEAD_BUF,   	"Keyboard typeahead buffer" },
	{ R_CURSOR_BIT_PAT_BUF,   	"Cursor bit pattern storage" },

	/* ROM Functions */

	{ R_RESET_VECTOR,            "Reset Vector" },
	{ R_COMP_BYTE_M,             "Compare next byte with M" },
	{ R_GET_NONWHITE,            "Get next non-white char from M" },
	{ R_COMP_DE_HL,              "Compare DE and HL" },
	{ R_PRINT_SPACE,             "Send a space to screen/printer" },
	{ R_PRINT_CHAR,              "Send character in A to screen/printer" },
	{ R_PWR_DOWN_TRAP,           "Power down TRAP" },
	{ R_DET_LAST_VAR_TYPE,       "Determine type of last var used" },
	{ R_RST_5_5,                 "RST 5.5 -- Bar Code Reader" },
	{ R_GET_FAC1_SIGN,           "Get sign of FAC1" },
	{ R_RST_6_5,                 "RST 6.5 -- RS232 character pending" },
	{ R_RAM_VCTR_TBL_DRIVER,     "RAM vector table driver" },
	{ R_RST_7_5,                 "RST 7.5 -- Timer background task" },
	{ R_BASIC_KEYWORD_TBL,       "BASIC statement keyword table END to NEW" },
	{ R_FUN_KEYWORD_TBL1,        "Function keyword table TAB to <" },
	{ R_FUN_KEYWORD_TBL2,        "Function keyword table SGN to MID$" },
	{ R_BASIC_VECTOR_TBL,        "BASIC statement vector table for END to NEW" },
	{ R_MATH_PRIORITY_TBL,       "Math operator priority table" },
	{ R_BASIC_ERR_MSG_TXT,       "BASIC error message text" },
	{ R_FUN_INIT_IMAGE,          "Initialization image loaded to F5F0H" },
	{ R_FUN_XROM_IMAGE,          "External ROM detect image loaded at F605H" },
	{ R_FUN_BASIC_STRINGS,       "BASIC message strings" },
	{ R_POP_FOR_NEXT,            "Pop return address for NEXT or RETURN" },
	{ R_INIT_AND_READY,          "Initialize system and go to BASIC ready" },
	{ R_GEN_SN_ERROR,            "Generate Syntax error" },
	{ R_GEN_d0_ERROR,            "Generate /0 error" },
	{ R_GEN_NF_ERROR,            "Generate NF error" },
	{ R_GEN_DD_ERROR,            "Generate DD error" },
	{ R_GEN_RW_ERROR,            "Generate RW error" },
	{ R_GEN_OV_ERROR,            "Generate OV error" },
	{ R_GEN_MO_ERROR,            "Generate MO error" },
	{ R_GEN_TM_ERROR,            "Generate TM error" },
	{ R_GEN_ERR_IN_E,            "Generate error in E" },
	{ R_RESTORE_JMP_BC,          "Restore stack & runtime and jump to BC" },
	{ R_PRINT_BASIC_ERR,         "Print BASIC error message - XX error in XXX" },
	{ R_POP_GO_BASIC_RDY,        "Pop stack and vector to BASIC ready" },
	{ R_GO_BASIC_RDY_OK,         "Vector to BASIC ready - print Ok" },
	{ R_GO_BASIC_RDY,            "Silent vector to BASIC ready" },
	{ R_PERFORM_M_GO_RDY,        "Perform operation at M and return to ready" },
	{ R_UPDATE_LINE_ADDR,        "Update line addresses for current BASIC program" },
	{ R_EVAL_LIST_ARGS,          "Evaluate LIST statement arguments" },
	{ R_FIND_LINE_IN_DE,         "Find line number in DE" },
	{ R_FIND_LINE_DE_AT_HL,      "Find line number in DE starting at HL" },
	{ R_TOKEN_COMPRESS,          "Perform Token compression" },
	{ R_FOR_STMT,                "FOR statement" },
	{ R_TO_STMT,                 "TO statement" },
	{ R_STEP_STMT,               "STEP statement" },
	{ R_RUN_BASIC_PGRM,          "Execute BASIC program" },
	{ R_RUN_BASIC_AT_HL,         "Start executing BASIC program at HL" },
	{ R_EXEC_INST_IN_A,          "Execute instruction in A, HL points to args" },
	{ R_RST_10H_INC_HL,          "RST 10H routine with pre-increment of HL" },
	{ R_RST_10H,                 "RST 10H routine" },
	{ R_DEF_STMT,                "DEF statement" },
	{ R_DEFDBL_STMT,             "DEFDBL statement" },
	{ R_DEFINT_STMT,             "DEFINT statement" },
	{ R_DEFSNG_STMT,             "DEFSNG statement" },
	{ R_DEFSTR_STMT,             "DEFSTR statement" },
	{ R_DECL_VAR_TYPE_E,         "Declare variable at M to be type E" },
	{ R_GEN_FC_ERROR,            "Generate FC error" },
	{ R_EVAL_LINE_NUM,           "Evaluate line number text at M" },
	{ R_ASCII_TO_BIN,            "Convert ASCII number at M to binary" },
	{ R_ASCII_TO_BIN_PREINC,     "Convert ASCII number at M+1 to binary" },
	{ R_RUN_STMT,                "RUN statement" },
	{ R_GOSUB_STMT,              "GOSUB statement" },
	{ R_GOTO_STMT,               "GOTO statement" },
	{ R_GEN_UL_ERROR,            "Generate UL error" },
	{ R_RETURN_STMT,             "RETURN statement" },
	{ R_DATA_STMT,               "DATA statement" },
	{ R_REM_STMT,                "REM statement" },
	{ R_LET_STMT,                "LET statement" },
	{ R_ON_STMT,                 "ON statement" },
	{ R_ON_ERROR_STMT,           "ON ERROR statement" },
	{ R_ON_KEY_STMT,             "ON KEY/TIME/COM/MDM GOSUB routine" },
	{ R_ON_TIME_STMT,            "ON TIME$ handler" },
	{ R_RESUME_STMT,             "RESUME statement" },
	{ R_ERROR_STMT,              "ERROR statement" },
	{ R_IF_STMT,                 "IF statement" },
	{ R_LPRINT_STMT,             "LPRINT statement" },
	{ R_PRINT_STMT,              "PRINT statement" },
	{ R_TAB_STMT,                "TAB statement" },
	{ R_LINE_STMT,               "LINE statement" },
	{ R_INPUT_NO_STMT,           "INPUT # statement" },
	{ R_INPUT_STMT,              "INPUT statement" },
	{ R_READ_STMT,               "READ statement" },
	{ R_EVAL_BASIC_INST,         "Main BASIC evaluation routine" },
	{ R_INT16_DIV,               "Integer Divide FAC1=DE/HL" },
	{ R_EVAL_FUN,                "Evaluate function at M" },
	{ R_ERR_FUN,                 "ERR function" },
	{ R_ERL_FUN,                 "ERL function" },
	{ R_VARPTR_FUN,              "VARPTR function" },
	{ R_VARPTR_BUF_FUN,          "VARPTR(#buffer) function" },
	{ R_VARPTR_VAR_FUN,          "VARPTR(variable) function" },
	{ R_EVAL_VAR,                "Evaluate variable" },
	{ R_CONV_M_TOUPPER,          "Get char at M and convert to uppercase" },
	{ R_CONV_A_TOUPPER,          "Convert A to uppercase" },
	{ R_ASCII_NUM_CONV,          "ASCII num conversion - find ASCII or tokenized '+' or '-' in A" },
	{ R_NOT_FUN,                 "NOT function" },
	{ R_RST_28H,                 "RST 28H routine" },
	{ R_OR_FUN,                  "OR function" },
	{ R_AND_FUN,                 "AND function" },
	{ R_XOR_FUN,                 "XOR function" },
	{ R_EQV_FUN,                 "EQV function" },
	{ R_IMP_FUN,                 "IMP function" },
	{ R_LPOS_FUN,                "LPOS function" },
	{ R_POS_FUN,                 "POS function" },
	{ R_LD_FAC1_INT,             "Load integer in A into FAC1" },
	{ R_CHK_RUNNING_PGRM,        "Check for running program" },
	{ R_GEN_ID_ERROR,            "Generate ID error" },
	{ R_INP_FUN,                 "INP function" },
	{ R_OUT_STMT,                "OUT statement" },
	{ R_EVAL_EXPR,               "Evaluate expression at M" },
	{ R_EVAL_EXPR_PREDEC,        "Evaluate expression at M-1" },
	{ R_LLIST_STMT,              "LLIST statement" },
	{ R_LIST_STMT,               "LIST statement" },
	{ R_BUF_TO_LCD,              "Send buffer at M to screen" },
	{ R_PEEK_FUN,                "PEEK function" },
	{ R_POKE_FUN,                "POKE function" },
	{ R_WAIT_KEY,                "Wait for key from keyboard" },
	{ R_TOGGLE_LABEL,            "Toggle function key label line" },
	{ R_CHK_KEY_QUEUE,           "Check keyboard queue for pending characters" },
	{ R_POWER_STMT,              "POWER statement" },
	{ R_LOW_PWR_TRAP,            "Normal TRAP (low power) interrupt routine" },
	{ R_POWER_DOWN,              "Turn off computer" },
	{ R_POWER_CONT_STMT,         "POWER CONT statement" },
	{ R_POWER_ON_STMT,           "POWER ON statement" },
	{ R_OUT_CH_TO_LPT,           "Output character to printer" },
	{ R_LOAD_CAS_HDR,            "Start tape and load tape header" },
	{ R_GEN_IO_ERROR,            "Generate I/O error" },
	{ R_DET_CAS_SYNC_HDR,        "Turn cassette motor on and detect sync header" },
	{ R_CAS_MOTOR_ON,            "Turn cassette motor on" },
	{ R_CAS_MOTOR_OFF,           "Turn cassette motor off" },
	{ R_CAS_READ_BYTE,           "Read byte from tape & update checksum" },
	{ R_CAS_WRITE_BYTE,          "Write byte to tape & update checksum" },
	{ R_LCD_DCB,                 "LCD Device control block" },
	{ R_LCD_OPEN,                "LCD and PRT file open routine" },
	{ R_LCD_OUT,                 "Output to LCD file" },
	{ R_POP_ALL_REGS,            "Pop AF, BC, DE, HL from stack" },
	{ R_CRT_DCB,                 "CRT device control block" },
	{ R_RAM_DCB,                 "RAM device control block" },
	{ R_RAM_OPEN,                "Open RAM file" },
	{ R_RAM_CLOSE,               "Close RAM file" },
	{ R_RAM_OUT,                 "Output to RAM file" },
	{ R_RAM_IN,                  "Input from RAM file" },
	{ R_RAM_IO,                  "Special RAM file I/O" },
	{ R_CAS_DCB,                 "CAS device control block" },
	{ R_CAS_OPEN,                "Open CAS file" },
	{ R_CAS_CLOSE,               "Close CAS file" },
	{ R_CAS_OUT,                 "Output to CAS file" },
	{ R_CAS_IN,                  "Input from CAS file" },
	{ R_LPT_DCB,                 "LPT device control block" },
	{ R_LPT_OUT,                 "Output to LPT file" },
	{ R_COM_DCB,                 "COM device control block" },
	{ R_MDM_OPEN,                "Open MDM file" },
	{ R_COM_OPEN,                "Open COM file" },
	{ R_COM_CLOSE,               "Close COM file" },
	{ R_COM_OUT,                 "Output to COM/MDM file" },
	{ R_COM_IN,                  "Input from COM/MDM file" },
	{ R_COM_IO,                  "Special COM/MDM file I/O" },
	{ R_MDM_DCB,                 "MDM Device control block" },
	{ R_MDM_CLOSE,               "Close MDM file" },
	{ R_SET_RS232_PARAMS,        "Set RS232 parameters from string at M" },
	{ R_BCR_DCB,                 "Wand device control block" },
	{ R_EOF_FUN,                 "EOF function" },
	{ R_TIME_FUN,                "TIME$ function" },
	{ R_READ_TIME,               "Read time and store it at M" },
	{ R_DATE_FUN,                "DATE$ function" },
	{ R_DAY_FUN,                 "DAY function" },
	{ R_READ_DAY,                "Read day and store at M" },
	{ R_UPDATE_CLK_VALUES,       "Update in-memory (F923H) clock values" },
	{ R_TIME_STMT,               "TIME$ statement" },
	{ R_UPDATE_CLK_CHIP,         "Update clock chip from memory F923H" },
	{ R_DATE_STMT,               "DATE$ statement" },
	{ R_DAY_STMT,                "DAY$ statement" },
	{ R_GET_TIME_STRING,         "Get time string from command line" },
	{ R_IPL_STMT,                "IPL statement" },
	{ R_ERASE_IPL_PRGM,          "Erase current IPL program" },
	{ R_COM_MDM_STMT,            "COM and MDM statements" },
	{ R_KEY_FUN,                 "KEY() statement" },
	{ R_KEY_ON_OFF_STMT,         "KEY STOP/ON/OFF statements" },
	{ R_DET_TIME_ARG,            "Determine argument (ON/OFF/STOP) for TIME$ statement" },
	{ R_DET_DEVICE_ARG,          "Determine device (KEY/TIME/COM/MDM) for ON GOSUB" },
	{ R_ONTIME_STMT,             "ON TIME$ statement" },
	{ R_ONCOM_STMT,              "ON COM handler" },
	{ R_RST7_5_ISR,              "RST 7.5 interrupt routine" },
	{ R_KICK_PWR_OFF_WDT,        "Renew automatic power-off counter" },
	{ R_KEY_STMT,                "KEY statement" },
	{ R_KEY_LIST_STMT,           "KEY LIST statement" },
	{ R_SEND_CHARS_TO_LCD,       "Send B characters from M to the screen" },
	{ R_PSET_STMT,               "PSET statement" },
	{ R_PRESET_STMT,             "PRESET statement" },
	{ R_DRAW_FBOX,               "Draw a filled box on LCD. Coords are on stack" },
	{ R_DRAW_BOX,                "Draw an unfilled box on LCD. Coords are on stack" },
	{ R_TOKENIZE_XY,             "Get (X,Y) coordinate from tokenized string at M" },
	{ R_CSRLIN_FUN,              "CSRLIN function" },
	{ R_MAX_FUN,                 "MAX function" },
	{ R_MAXRAM_FUN,              "MAXRAM function" },
	{ R_MAXFILES_FUN,            "MAXFILES function" },
	{ R_HIMEM_FUN,               "HIMEM function" },
	{ R_WIDTH_STMT,              "WIDTH statement" },
	{ R_SOUND_STMT,              "SOUND statement" },
	{ R_SOUND_OFF_STMT,          "SOUND OFF statement" },
	{ R_SOUND_ON_STMT,           "SOUND ON statement" },
	{ R_MOTOR_STMT,              "MOTOR statement" },
	{ R_MOTOR_ON_STMT,           "MOTOR ON statement" },
	{ R_MOTOR_OFF_STMT,          "MOTOR OFF statement" },
	{ R_CALL_STMT,               "CALL statement" },
	{ R_SCREEN_STMT,             "SCREEN statement" },
	{ R_LCOPY_STMT,              "LCOPY statement" },
	{ R_FILES_STMT,              "FILES statement" },
	{ R_DISPLAY_CAT,             "Display Catalog" },
	{ R_KILL_STMT,               "KILL statement" },
	{ R_KILL_TEXT_FILE,          "Kill a text file" },
	{ R_NAME_STMT,               "NAME statement" },
	{ R_NEW_STMT,                "NEW statement" },
	{ R_STRLEN,                  "Count length of string at M" },
	{ R_GET_FIND_DO_FILE,        "Get .DO filename and locate in RAM directory" },
	{ R_OPEN_TEXT_FILE,          "Open a text file at (FC93H)" },
	{ R_CSAVE_STMT,              "CSAVE statement" },
	{ R_CAS_WRITE_BUF,           "Save buffer at M to tape" },
	{ R_SAVEM_STMT,              "SAVEM statement" },
	{ R_CSAVEM_STMT,             "CSAVEM statement" },
	{ R_CLOAD_STMT,              "CLOAD statement" },
	{ R_CAS_READ_REC,            "Load record from tape and store at M" },
	{ R_GEN_VERIFY_FAIL_ERR,     "Generate Verify Failed error" },
	{ R_LOADM_STMT,              "LOADM and RUNM statement" },
	{ R_CLOADM_STMT,             "CLOADM statement" },
	{ R_MOVE_B_BYTES,            "Move B bytes from M to (DE)" },
	{ R_EXEC_CO_FILE,            "Launch .CO files from MENU" },
	{ R_CAS_OPEN_OUT_BA,         "Open CAS for output of BASIC files" },
	{ R_CAS_OPEN_OUT_DO,         "Open CAS for output of TEXT files" },
	{ R_CAS_OPEN_OUT_CO,         "Open CAS for output of CO files" },
	{ R_CAS_OPEN_IN_BA,          "Open CAS for input of BASIC files" },
	{ R_CAS_OPEN_IN_DO,          "Open CAS for input of TEXT files" },
	{ R_CAS_OPEN_IN_CO,          "Open CAS for input of CO files" },
	{ R_STR_FUN,                 "STR$ function" },
	{ R_PRINT_STRING,            "Print buffer at M until NULL or '\"'" },
	{ R_MOVE_L_BYTES,            "Move L bytes from (BC) to (DE)" },
	{ R_LEN_FUN,                 "LEN function" },
	{ R_ASC_FUN,                 "ASC function" },
	{ R_CHR_FUN,                 "CHR$ function" },
	{ R_STRING_FUN,              "STRING$ function" },
	{ R_SPACE_FUN,               "SPACE$ function" },
	{ R_LEFT_FUN,                "LEFT$ function" },
	{ R_RIGHT_FUN,               "RIGHT$ function" },
	{ R_MID_FUN,                 "MID$ function" },
	{ R_VAL_FUN,                 "VAL function" },
	{ R_INSTR_FUN,               "INSTR function" },
	{ R_FRE_FUN,                 "FRE function" },
	{ R_DBL_SUB,                 "Double precision subtract (FAC1=FAC1-FAC2)" },
	{ R_DBL_ADD,                 "Double precision addition (FAC1=FAC1+FAC2)" },
	{ R_BCD_ADD,                 "Add the BCD num in M to the one in (DE)" },
	{ R_DBL_MULT,                "Double precision multiply (FAC1=FAC1*FAC2)" },
	{ R_DBL_DIV,                 "Double precision divide (FAC1=FAC1/FAC2)" },
	{ R_MOVE_C_BYTES,            "Move C bytes from M to (DE)" },
	{ R_COS_FUN,                 "COS function" },
	{ R_SIN_FUN,                 "SIN function" },
	{ R_TAN_FUN,                 "TAN function" },
	{ R_ATN_FUN,                 "ATN function" },
	{ R_LOG_FUN,                 "LOG function" },
	{ R_SQR_FUN,                 "SQR function" },
	{ R_EXP_FUN,                 "EXP function" },
	{ R_RND_FUN,                 "RND function" },
	{ R_DBL_SQR,                 "Double precision Square (FAC1=SQR(FAC1))" },
	{ R_MULT_M_FAC2,             "Double precision math (FAC1=M * FAC2))" },
	{ R_FAC2_EQ_FAC1,            "Move FAC1 to FAC2" },
	{ R_FAC2_EQ_FP,              "Move floating point number M to FAC2" },
	{ R_FAC1_EQ_FAC2,            "Move FAC2 to FAC1" },
	{ R_FAC1_EQ_FP,              "Move floating point number M to FAC1" },
	{ R_M_EQ_FAC1,               "Move FAC1 to M" },
	{ R_MULT_FAC1_SQR_FAC1,      "Double precision math (FAC1=FAC1*SQR(FAC1))" },
	{ R_SWAP_FAC1_FAC2,          "Swap FAC1 and FAC2" },
	{ R_SQR_FAC1_MULT_TBL,       "Square FAC1 & do table based math" },
	{ R_TBL_BASED_MATH,          "Table based math (FAC1=(((FAC1*M)+(M+1))*(M+2)+(M+3)..." },
	{ R_PUSH_FAC2,               "Push FAC2 on stack" },
	{ R_PUSH_FAC1,               "Push FAC1 on stack" },
	{ R_POP_FAC2,                "Pop FAC2 from stack" },
	{ R_POP_FAC1,                "Pop FAC1 from stack" },
	{ R_FP_NUMBERS,              "Floating point numbers for math operations " },
	{ R_FP_SHARED_NUMBERS,       "Floating point num-shares 6 bytes from next number" },
	{ R_EXP_MATH_TBL,            "Count of Floating point numbers to follow for EXP" },
	{ R_LOG_MATH_TBL,            "Count of Floating point numbers to follow for LOG" },
	{ R_SIN_MATH_TBL,            "Count of Floating point numbers to follow for SIN" },
	{ R_ATN_MATH_TBL,            "Count of Floating point numbers to follow for ATN" },
	{ R_RST_30H_FUN,             "RST 30H routine" },
	{ R_ABS_FUN,                 "ABS function" },
	{ R_SGN_FUN,                 "SGN function" },
	{ R_PUSH_SNGL_FAC1,          "Push single precision FAC1 on stack" },
	{ R_SNGL_FAC1_EQ_M,          "Load single precision at M to FAC1" },
	{ R_SNGL_FAC1_EQ_BCDE,       "Load single precision in BCDE to FAC1" },
	{ R_SNGL_BCDE_EQ_FAC1,       "Load single precision FAC1 to BCDE" },
	{ R_SNGL_BCDE_EQ_M,          "Load single precision at M to BCDE" },
	{ R_SNGL_DECB_EQ_M,          "Reverse load single precision at M to DEBC" },
	{ R_SNGL_M_EQ_FAC1,          "Move single precision FAC1 to M" },
	{ R_LOAD_FAC2_FROM_M,        "Move M to FAC2 using precision at (FB65H)" },
	{ R_MOVE_B_BYTES_INC,        "Move B bytes from (DE) to M with increment" },
	{ R_MOVE_B_BYTES_DEC,        "Move B bytes from (DE) to M with decrement" },
	{ R_SNGL_CMP_BCDE_FAC1,      "Compare single precision in BCDE with FAC1" },
	{ R_SNGL_CMP_BCDE_M,         "Compare single precision in BCDE with M" },
	{ R_SINT_CMP,                "Compare signed integer in DE with that in HL" },
	{ R_CMP_FAC1_FAC2,           "Compare double precision FAC1 with FAC2" },
	{ R_CINT_FUN,                "CINT function" },
	{ R_FAC1_EQ_SINT_HL,         "Load signed integer in HL to FAC1" },
	{ R_CSNG_FUN,                "CSNG function" },
	{ R_CONV_SINT_SNGL,          "Convert signed integer in FAC1 to single precision" },
	{ R_CONV_SINT_HL_SNGL,       "Convert signed integer HL to single precision FAC1" },
	{ R_CDBL_FUN,                "CDBL function" },
	{ R_FIX_FUN,                 "FIX function" },
	{ R_INT_FUN,                 "INT function" },
	{ R_SINT_SUB,                "Signed integer subtract (FAC1=HL-DE)" },
	{ R_SINT_ADD,                "Signed integer addition (FAC1=HL+DE)" },
	{ R_SINT_MULT,               "Signed integer muliply (FAC1=HL*DE)" },
	{ R_SINT_DIV,                "Signed integer divide (FAC1=DE/HL)" },
	{ R_SNGL_ADD_BCDE,           "Single precision addition (FAC1=FAC1+BCDE)" },
	{ R_SNGL_ADD_FAC2,           "Single precision addition (FAC1=FAC1+FAC2)" },
	{ R_SNGL_SUB,                "Single precision subtract (FAC1=FAC1-BCDE)" },
	{ R_SNGL_MULT_BCDE,          "Single precision multiply (FAC1=FAC1*BCDE)" },
	{ R_SNGL_MULT_FAC2,          "Single precision multiply (FAC1=FAC2*FAC2)" },
	{ R_SNGL_DIV,                "Single precision divide (FAC1=BCDE/FAC1)" },
	{ R_SNGL_LOAD,               "Single precision load (FAC2=BCDE)" },
	{ R_ASCII_TO_DBL,            "Convert ASCII number at M to double precision in FAC1" },
	{ R_ASCII_FND_e,             "Found 'e' in ASCII number" },
	{ R_ASCII_FND_E,             "Found 'E' in ASCII number" },
	{ R_ASCII_FND_DOT,           "Found '.' in ASCII number" },
	{ R_ASCII_FND_PERC,          "Found '%' in ASCII number" },
	{ R_ASCII_FND_LB,            "Found '#' in ASCII number" },
	{ R_ASCII_CONV_HELPER,       "Deal with single & double precision ASCII conversions" },
	{ R_ASCII_CONV_HELPER2,      "Convert ASCII number that starts with a Digit" },
	{ R_PRNT_BASIC_ERR_TERM,     "Finish printing BASIC ERROR message \" in \" line #" },
	{ R_PRINT_HL_ON_LCD,         "Print binary number in HL at current position" },
	{ R_PRINT_FAC1,              "Convert binary number in FAC1 to ASCII at M" },
	{ R_PRINT_FAC1_FORMAT,       "Convert binary number in FAC1 to ASCII at M with format" },
	{ R_FAC1_EQ_ZERO,            "Initialize FAC1 with 0.0 if it has no value" },
	{ R_SNGL_EXP,                "Single precision exponential function" },
	{ R_DBL_EXP,                 "Double precision exponential function" },
	{ R_INT_EXP,                 "Integer exponential function" },
	{ R_TIME_ON_STMT,            "TIME$ ON statement" },
	{ R_TRIG_INTR,               "Trigger interrupt.  HL points to interrupt table" },
	{ R_CLEAR_INTR,              "Clear interrupt.  HL points to interrupt table" },
	{ R_TIME_OFF_STMT,           "TIME$ OFF statement" },
	{ R_TIME_STOP_STMT,          "TIME$ STOP statement" },
	{ R_CLEAR_COM_INT_DEF,       "Clear all COM, TIME, and KEY interrupt definitions" },
	{ R_RESTORE_STMT,            "RESTORE statement" },
	{ R_STOP_STMT,               "STOP statement" },
	{ R_END_STMT,                "END statement" },
	{ R_CONT_STMT,               "CONT sttement" },
	{ R_ISALPHA_M,               "Check if M is alpha character" },
	{ R_ISALPHA_A,               "Check if A is alpha character" },
	{ R_CLEAR_STMT,              "CLEAR statement" },
	{ R_NEXT_STMT,               "NEXT statement" },
	{ R_SEND_CRLF,               "Send CRLF to screen or printer" },
	{ R_SEND_LF,                 "Send LF to screen or printer" },
	{ R_BEEP_STMT,               "BEEP statement" },
	{ R_HOME_CURSOR,             "Home cursor" },
	{ R_CLS_STMT,                "CLS statement" },
	{ R_PROTECT_LABEL,           "Protect line 8.  An ESC T is printed" },
	{ R_UNPROT_LABEL,            "Unprotect line 8.  An ESC U is printed" },
	{ R_STOP_AUTO_SCROLL,        "Stop automatic scrolling" },
	{ R_RESUME_AUTO_SCROLL,      "Resume automatic scrolling" },
	{ R_TURN_CURSOR_ON,          "Turn the cursor on" },
	{ R_TURN_CURSOR_OFF,         "Turn the cursor off" },
	{ R_DEL_CUR_LINE,            "Delete current line on screen" },
	{ R_INSERT_LINE,             "Insert line a current line" },
	{ R_ERASE_TO_EOL,            "Erase from cursor to end of line" },
	{ R_SEND_ESC_X,              "Send ESC X" },
	{ R_INV_CHAR_ENABLE,         "Start inverse character mode" },
	{ R_INV_CHAR_DISABLE,        "Cancel inverse character mode" },
	{ R_END_ESC_SEQ,             "End escape sequence" },
	{ R_CURSOR_TO_LOW_LEFT,      "Send cursor to lower left of CRT" },
	{ R_SET_CURSOR_POS,          "Set the current cursor position (H=Row,L=Col)" },
	{ R_ERASE_FKEY_DISP,         "Erase function key display" },
	{ R_SET_DISP_FKEY,           "Set and display function keys (M has key table)" },
	{ R_DISP_FKEY_LINE,          "Display function key line" },
	{ R_PRINT_A_TO_LCD,          "Print A to the screen" },
	{ R_CHAR_PLOT_3,             "Character plotting level 3. Check new device console flag & call level 4)" },
	{ R_CHAR_PLOT_4,             "Character plotting level 4. Turn off background task & call level 5" },
	{ R_CHAR_PLOT_5,             "Character plotting level 5. Handle ESC sequences & call level 6" },
	{ R_LCD_OUT_DRIVER,          "LCD output driver" },
	{ R_RST_20H_LKUP_TBL,        "RST 20H lookup table" },
	{ R_ESC_Y,                   "ESC Y routine (Set cursor position)" },
	{ R_LCD_OUT_ESC_FUN,         "LCD output Escape routine" },
	{ R_LCD_ESC_LKUP_TBL,        "LCD Escape sequence lookup table" },
	{ R_ESC_SEQ_DRIVER,          "ESCape sequence driver" },
	{ R_ESC_p_FUN,               "ESC p routine (start inverse video)" },
	{ R_ESC_q_FUN,               "ESC q routine (cancel inverse video)" },
	{ R_ESC_U_FUN,               "ESC U routine (unprotect line 8)" },
	{ R_ESC_T_FUN,               "ESC T routine (protect line 8)" },
	{ R_ESC_V_FUN,               "ESC V routine (stop automatic scrolling)" },
	{ R_ESC_W_FUN,               "ESC W routine (resume automatic scrolling)" },
	{ R_ESC_X_FUN,               "ESC X routine" },
	{ R_ESC_C_FUN,               "ESC C routine (move cursor right)" },
	{ R_ESC_D_FUN,               "ESC D routine (move cursor left)" },
	{ R_BKSPACE_FUN,             "Backspace routine" },
	{ R_ESC_A_FUN,               "ESC A routine (move cursor up)" },
	{ R_ESC_B_FUN,               "ESC B routine (move cursor down)" },
	{ R_TAB_FUN,                 "Tab routine" },
	{ R_LF_FUN,                  "Linefeed routine" },
	{ R_ESC_H_FUN,               "Verticle tab and ESC H routine (home cursor)" },
	{ R_CR_FUN,                  "CR routine" },
	{ R_ESC_P_FUN,               "ESC P routine (turn cursor on)" },
	{ R_ESC_Q_FUN,               "ESC Q routine (turn cursor off)" },
	{ R_ESC_M_FUN,               "ESC M routine" },
	{ R_LCD_SCROLL,              "Scroll LCD screen A times at line number in L" },
	{ R_ESC_L_FUN,               "ESC L routine (insert line)" },
	{ R_GET_LCD_CHAR,            "Get character at (H,L) from LCD RAM)" },
	{ R_ESC_l_FUN,               "ESC l routine (erase current line)" },
	{ R_ESC_K_FUN,               "ESC K routine (erase to EOL)" },
	{ R_CLS_FUN,                 "Form Feed (0CH), CLS, ESC E, and ESC J routine" },
	{ R_CHAR_PLOT_6,             "Character plotting level 6.  Save character in C to LCD RAM & call level 7" },
	{ R_ESC_J_FUN,               "ESC J routine" },
	{ R_INP_DISP_LINE,           "Input and display line and store" },
	{ R_INP_DISP_LINE_NO_Q,      "Input and display (no \"?\") line and store" },
	{ R_INP_CTRL_C_HANDLER,      "Input routine Control-C handler" },
	{ R_INP_ENTER_HANDLER,       "Input routine ENTER handler" },
	{ R_INP_BKSP_HANDLER,        "Input routine backspace, left arrow, CTRL-H handler" },
	{ R_INP_CTRL_U_HANDLER,      "Input routine CTRL-U & X handler" },
	{ R_INP_TAB_HANDLER,         "Input routine Tab handler" },
	{ R_DIM_STMT,                "DIM statement" },
	{ R_FIND_VAR_ADDR,           "Find address of variable at M" },
	{ R_USING_FUN,               "USING function" },
	{ R_SEND_A_LCD_LPT,          "Send A to screen or printer" },
	{ R_PRINT_A_EXPAND,          "Print A to printer, expanding tabs if necessary" },
	{ R_SET_OUT_DEV_LCD,         "Reinitialize output back to LCD" },
	{ R_LCD_CHAR_OUT_FUN,        "LCD character output routine" },
	{ R_LCD_NEW_LINE,            "Move LCD to blank line (send CRLF if needed)" },
	{ R_INKEY_FUN,               "INKEY$ function" },
	{ R_GET_FILE_DESC,           "Get file descriptor for file in A" },
	{ R_OPEN_STMT,               "OPEN statement" },
	{ R_LCD_CLOSE_FUN,           "LCD, CRT, and LPT file close routine" },
	{ R_RUN_STMT_PARAM,          "RUN statement (with parameters)" },
	{ R_LOAD_STMT,               "LOAD statement" },
	{ R_MERGE_STMT,              "MERGE statement" },
	{ R_SAVE_STMT,               "SAVE statement" },
	{ R_CLOSE_STMT,              "CLOSE statement" },
	{ R_INPUT_FUN,               "INPUT$ function" },
	{ R_CLEAR_MEM,               "Zero B bytes at M" },
	{ R_LOAD_MEM,                "Load B bytes at M with A" },
	{ R_PRINT_LB_INIT_FUN,       "PRINT # initialization routine" },
	{ R_LINE_INPUT_STMT,         "LINE INPUT # statement" },
	{ R_GEN_NM_ERR_FUN,          "Generate NM error" },
	{ R_GEN_AO_ERR_FUN,          "Generate AO error" },
	{ R_GEN_DS_ERR_FUN,          "Generate DS error" },
	{ R_GEN_FF_ERR_FUN,          "Generate FF error" },
	{ R_GEN_CF_ERR_FUN,          "Generate CF error" },
	{ R_GEN_BN_ERR_FUN,          "Generate BN error" },
	{ R_GEN_IE_ERR_FUN,          "Generate IE error" },
	{ R_GEN_EF_ERR_FUN,          "Generate EF error" },
	{ R_GEN_FL_ERR_FUN,          "Generate FL error" },
	{ R_LOF_FUN,                 "LOF function" },
	{ R_LOC_FUN,                 "LOC function" },
	{ R_LFILES_FUN,              "LFILES function" },
	{ R_DSKO_FUN,                "DSKO$ function" },
	{ R_DSKI_FUN,                "DSKI$ function" },
	{ R_DEV_NAME_TBL,            "Device name table" },
	{ R_DCB_VCTR_TBL,            "Device control block vector addresses table" },
	{ R_TELCOM_ENTRY,            "TELCOM Entry point" },
	{ R_TELCOM_RE_ENTRY,         "Re-entry point for TELCOM commands" },
	{ R_TELCOM_INST_VCTR_TBL,    "TELCOM instruction vector table" },
	{ R_TELCOM_LABEL_TXT,        "TELCOM label line text table" },
	{ R_TELCOM_STAT_FUN,         "TELCOM STAT instruction routine" },
	{ R_PRINT_TELCOM_STAT,       "Print current STAT settings" },
	{ R_SET_TELCOM_STAT,         "Set STAT and return to TELCOM ready" },
	{ R_TELCOM_CALL_FUN,         "TELCOM CALL instruction routine" },
	{ R_TELCOM_FIND_FUN,         "TELCOM FIND instruction routine" },
	{ R_GO_OFFHOOK,              "Go off-hook" },
	{ R_DISCONNECT_PHONE,        "Disconnect phone line and disable modem carrier" },
	{ R_CONNECT_PHONE,           "Connect phone line and enable modem carrier" },
	{ R_GO_OFFHOOK_WAIT,         "Go off-hook and wait for carrier" },
	{ R_TELCOM_PAUSE,            "Pause for about 2 seconds" },
	{ R_EXEC_LOGON_SEQ,          "Execute logon sequence at M" },
	{ R_DIALING_FUN,             "Dialing routine" },
	{ R_AUTO_LOGIN_SEQ,          "Auto logon sequence" },
	{ R_DIAL_DIGIT,              "Dial the digit in A & print on LCD" },
	{ R_TELCOM_TERM_FUN,         "TELCOM TERM instruction routine" },
	{ R_TELCOM_DISPATCH,         "TELCOM \"dispatcher\" routine" },
	{ R_TELCOM_PREV_FUN,         "TELCOM PREV function routine" },
	{ R_TELCOM_FULL_FUN,         "TELCOM FULL/HALF function routine" },
	{ R_TELCOM_ECHO_FUN,         "TELCOM ECHO function routine" },
	{ R_TELCOM_UP_FUN,           "TELCOM UP function routine" },
	{ R_TELCOM_DOWN_FUN,         "TELCOM DOWN function routine" },
	{ R_TELCOM_BYE_FUN,          "TELCOM BYE function routine" },
	{ R_MENU_ENTRY,              "MENU Program" },
	{ R_DISP_DIR,                "Display directory entries" },
	{ R_MENU_CTRL_U_HANDLER,     "Handle CTRL-U key from MENU command loop" },
	{ R_MENU_CMD_LOOP,           "MENU Program command loop" },
	{ R_MENU_BKSP_HANDLER,       "Handle Backspace key from MENU command loop" },
	{ R_MENU_ENTER_HANDLER,      "Handle ENTER key from MENU command loop" },
	{ R_EXEC_ROM_FILE,           "Launch ROM command file from MENU program" },
	{ R_DISP_DIR_TYPE_C,         "Display directory entries of type in register C" },
	{ R_CONV_FILENAME,           "Convert filename from space padded to '.ext' format" },
	{ R_NEXT_DIR_ENTRY,          "Position cursor for next directory entry" },
	{ R_CLS_PRINT_TIME_DAY,      "Print time, day and date on first line of screen" },
	{ R_PRINT_TIME_DAY,          "Print time,day,date on first line w/o CLS" },
	{ R_PRINT_STRING2,           "Print NULL terminated string at M" },
	{ R_COPY_MEM_DE_M,           "Copy A bytes from (DE) to M" },
	{ R_CMP_MEM_DE_M,            "Compare string at DE with that at M (max C bytes)" },
	{ R_CLEAR_FKEY_TBL,          "Clear function key definition table" },
	{ R_SET_FKEYS,               "Set new function key table" },
	{ R_DISP_FKEYS,              "Display function keys on 8th line" },
	{ R_SEARCH_DIR,              "Search directory for filename" },
	{ R_GET_FILE_ADDR,           "Get start address of file at M" },
	{ R_ADDRSS_ENTRY,            "ADDRSS Entry point" },
	{ R_ADDRSS_ENTRY_W_FILE,     "ADDRSS entry with (DE) pointing to filename" },
	{ R_SCHEDL_ENTRY,            "SCHEDL Entry point" },
	{ R_SCHEDL_ENTRY_W_FILE,     "SCHEDL entry with (DE) pointing to filename" },
	{ R_ADDRSS_FIND_FUN,         "FIND instruction for ADDRSS/SCHEDL" },
	{ R_ADDRSS_LFND_FUN,         "LFND instruction for ADDRSS/SCHEDL" },
	{ R_FIND_TEXT_IN_FILE,       "Find text at M in the file at (DE)" },
	{ R_FIND_NEXT_LINE_IN_FILE,  "Increment DE past next CRLF in text file at (DE)" },
	{ R_CHECK_FOR_CRLF,          "Check next byte(s) at (DE) for CRLF" },
	{ R_ADDRSS_INST_VCTR_TBL,    "ADDRSS/SCHEDL instruction vector table" },
	{ R_GET_KEY_CONV_TOUPPER,    "Wait for char from keyboard & convert to uppercase" },
	{ R_SEND_CURSOR_HOME,        "Home cursor" },
	{ R_PRINT_TIME_LOOP,         "Print time on top line until key pressed" },
	{ R_TEXT_ENTRY,              "TEXT Entry point" },
	{ R_TEXT_FKEY_TBL,           "TEXT Function key table - empty" },
	{ R_EDIT_STMT,               "EDIT statement" },
	{ R_WAIT_FOR_SPACE_KEY,      "Wait for a space to be entered on keyboard" },
	{ R_EDIT_DO_FILE_FUN,        "Edit .DO files" },
	{ R_TEXT_EDIT_LOOP,          "Main TEXT edit loop" },
	{ R_TEXT_CTRL_VCTR_TBL,      "TEXT control character vector table" },
	{ R_TEXT_ESC_FUN,            "TEXT ESCape routine" },
	{ R_TEXT_CTRL_P_FUN,         "TEXT control P routine" },
	{ R_TEXT_CTRL_I_FUN,         "TEXT control I routine" },
	{ R_TEXT_CTRL_M_FUN,         "TEXT control M routine" },
	{ R_TEXT_CTRL_D_FUN,         "TEXT right arrow and control D routine" },
	{ R_TEXT_CTRL_X_FUN,         "TEXT down arrow and control X routine" },
	{ R_TEXT_CTRL_H_FUN,         "TEXT control H routine" },
	{ R_TEXT_CTRL_S_FUN,         "TEXT left arrow and control S routine" },
	{ R_TEXT_CTRL_E_FUN,         "TEXT up arrow and control E routine" },
	{ R_TEXT_CTRL_F_FUN,         "TEXT control F routine" },
	{ R_TEXT_CTRL_A_FUN,         "TEXT control A routine" },
	{ R_TEXT_CTRL_T_FUN,         "TEXT control T routine" },
	{ R_TEXT_CTRL_B_FUN,         "TEXT control B routine" },
	{ R_TEXT_CTRL_R_FUN,         "TEXT control R routine" },
	{ R_TEXT_CTRL_Q_FUN,         "TEXT control Q routine" },
	{ R_TEXT_CTRL_W_FUN,         "TEXT control W routine" },
	{ R_TEXT_CTRL_Z_FUN,         "TEXT control Z routine" },
	{ R_TEXT_CTRL_L_FUN,         "TEXT control L routine" },
	{ R_TEXT_CTRL_C_FUN,         "TEXT control C routine" },
	{ R_TEXT_GET_NEXT_BYTE,      "Get next byte for TEXT Program entry" },
	{ R_TEXT_CTRL_O_FUN,         "TEXT control O routine" },
	{ R_TEXT_CTRL_U_FUN,         "TEXT control U routine" },
	{ R_TEXT_CTRL_N_FUN,         "TEXT control N routine" },
	{ R_COPY_NULL_STRING,        "Copy NULL terminated string at M to (DE)" },
	{ R_TEXT_CTRL_Y_FUN,         "TEXT control Y routine" },
	{ R_TEXT_CTRL_G_FUN,         "TEXT control G routine" },
	{ R_TEXT_CTRL_V_FUN,         "TEXT control V routine" },
	{ R_INSERT_A_INTO_FILE,      "Insert A into text file at M" },
	{ R_INSERT_SPACES,           "Insert BC spaces at M" },
	{ R_DELETE_CHARS,            "Delete BC characters at M" },
	{ R_MOVE_BC_BYTES_INC,       "Move BC bytes from M to (DE) with increment" },
	{ R_MOVE_BC_BYTES_DEC,       "Move BC bytes from M to (DE) with decrement" },
	{ R_BASIC_ENTRY,             "BASIC Entry point" },
	{ R_LOAD_BASIC_FKEYS,        "Copy BASIC Function key table to key definition area" },
	{ R_RE_INIT_SYSTEM,          "Re-initialize system without destroying files" },
	{ R_WARM_RESET,              "Warm start reset entry" },
	{ R_SEND_A_TO_LPT,           "Send character in A to the printer" },
	{ R_CHECK_RS232_QUEUE,       "Check RS232 queue for pending characters" },
	{ R_READ_RS232_QUEUE,        "Get a character from RS232 receive queue" },
	{ R_RST_6_5_FUN,             "RST 6.5 routine (RS232 receive interrupt)" },
	{ R_INC_RS232_QUEUE_IN,      "Calculate address to save next RS232 character" },
	{ R_SEND_XON,                "Send XON (CTRL-Q) out RS232" },
	{ R_DISABLE_XON_XOFF,        "Turn off XON/XOFF protocol" },
	{ R_SEND_A_USING_XON,        "Send character in A to serial port using XON/XOFF" },
	{ R_SEND_C_TO_RS232,         "Send character in C to serial port" },
	{ R_XON_XOFF_HANDLER,        "Handle XON/XOFF protocol" },
	{ R_SET_RS232_BAUD_RATE,     "Set RS232 baud rate stored in H" },
	{ R_RS232_BAUD_TIMER_VALS,   "RS232 baud rate timer values" },
	{ R_INIT_RS232_MDM,          "Initialize RS232 or modem" },
	{ R_UNINIT_RS232_MDM,        "Deactivate RS232 or modem" },
	{ R_CLICK_SND_PORT,          "Click sound port if sound enabled" },
	{ R_CHECK_CD,                "Check for carrier detect" },
	{ R_ENABLE_XON_XOFF,         "Enable XON/OFF when CTRL-S / CTRL-Q sent" },
	{ R_INIT_SER_BUF_PARAMS,     "Initialize serial buffer parameters" },
	{ R_CAS_WRITE_HEADER,        "Write cassette header and sync byte" },
	{ R_CAS_WRITE_NO_CHKSUM,     "Write char in A to cassette w/o checksum" },
	{ R_CAS_WRITE_NO_SYNC,       "Write char in A to cassette w/o checksum or sync bit" },
	{ R_CAS_WRITE_BIT,           "Write bit 0 of A to cassette" },
	{ R_CAS_READ_HEADER,         "Read cassette header and sync byte" },
	{ R_CAS_READ_BIT,            "Read Cassette port data bit" },
	{ R_CAS_COUNT_BITS,          "Count and pack cassette input bits" },
	{ R_CAS_READ_NO_CHKSUM,      "Read character from cassette w/o checksum" },
	{ R_CAS_REMOTE_FUN,          "Cassette REMOTE routine - turn motor on or off" },
	{ R_KEYSCAN_MGT_FUN,         "Keyboard scanning management routine" },
	{ R_KEY_DETECTION,           "Key detection -- Determine which keys are pressed" },
	{ R_KEY_REPEAT_DET,          "Key repeat detection" },
	{ R_GET_KEY_MATRIX,          "Calculate key matrix position and save buffer pointer at FFA8H" },
	{ R_INIT_KEY_RPT_CNT,        "Key detected - initialize repeat counter and decode" },
	{ R_KEY_DECODE,              "Key decoding" },
	{ R_KEY_FIRST_IN_BUF,        "Keyboard buffer management - place key in new buffer" },
	{ R_KEY_ADD_TO_BUF,          "Keyboard buffer management - place subsequent key in buffer" },
	{ R_ISR_EXIT_FUN,            "Interrupt exit routine (pop all regs & RET)" },
	{ R_UNSHIFTED_KEY,           "Handle unshifted & non-CTRL key during key decoding" },
	{ R_ARROW_KEY,               "Handle Arrow keys during key decoding" },
	{ R_CAPS_LOCK_KEY,           "Handle CAPS LOCK key during key decoding" },
	{ R_NUM_KEY,                 "Handle NUM key during key decoding" },
	{ R_SCAN_KEYBOARD,           "Scan keyboard for character (CTRL-BREAK ==> CTRL-C)" },
	{ R_ENABLE_INTERRUPTS,       "Enable interrupts as normal" },
	{ R_CHK_PENDING_KEYS,        "Check keyboard queue for pending characters" },
	{ R_CHK_BREAK,               "Check for break or wait (CTRL-S)" },
	{ R_CHK_SHIFT_BREAK,         "Check if SHIFT-BREAK is being pressed" },
	{ R_SCAN_SPECIAL_KEYS,       "Scan BREAK,CAPS,NUM,CODE,GRAPH,CTRL,SHIFT & set bits in A" },
	{ R_GEN_TONE,                "Produce a tone of DE freq and B duration" },
	{ R_GET_CLK_CHIP_REGS,       "Copy clock chip regs to M" },
	{ R_PUT_CLK_CHIP_REGS,       "Update clock chip regs from M" },
	{ R_READ_CLK_CHIP_BIT,       "Read next bit from Clock Chip" },
	{ R_SET_CLK_CHIP_MODE,       "Set clock chip mode" },
	{ R_BLINK_CURSOR,            "Blink the cursor" },
	{ R_PLOT_POINT,              "Plot (set) point (D,E) on the LCD" },
	{ R_CHAR_PLOT_7,             "Character plotting level 7.  Plot character in C on LCD at (H,L)" },
	{ R_CLEAR_POINT,             "Clear (reset) point (D,E) on the LCD" },
	{ R_LCD_BYTE_PLOT,           "Byte Plot - Send bit pattern to LCD for character" },
	{ R_ENABLE_LCD_DRIVER,       "Enable LCD drivers after short delay" },
	{ R_WAIT_LCD_DRIVER,         "Wait for LCD driver to be available" },
	{ R_LCD_BIT_PATTERNS,        "8155 PIO chip bit patterns for LCD drivers" },
	{ R_DELAY_FUN,               "Delay routine - decrement C until zero" },
	{ R_SET_INTR_1DH,            "Set interrupt to 1DH" },
	{ R_BEEP_FUN,                "Beep routine" },
	{ R_CLICK_SOUND_PORT,        "Click sound port" },
	{ R_CHK_XTRNL_CNTRLER,       "Check for optional external controller" },
	{ R_XTRNL_CNTRLER_DRIVER,    "Optional external controller driver" },
	{ R_LCD_CHAR_SHAPE_TBL1,     "LCD char generator shape table (20H-7FH" },
	{ R_LCD_CHAR_SHAPE_TBL2,     "LCD char generator shape table (80H-FFH)" },
	{ R_KEYBOARD_CONV_MATRIX,    "Keyboard conversion matrix" },
	{ R_BOOT_ROUTINE,            "Boot routine" },
	{ R_COLD_BOOT,               "Cold boot routine" },
	{ R_DISP_MODEL,              "Display TRS-80 Model number & Free bytes on LCD" },
	{ R_DISP_FREE_BYTES,         "Display number of free bytes on LCD" },
	{ R_INIT_RST_38H_TBL,        "Initialize RST 38H RAM vector table" },
	{ R_CALC_FREE_RAM,           "Calculate physical RAM available" },
	{ R_INIT_CLK_CHIP_REGS,      "Initial clock chip register values" },
	{ R_MENU_TEXT_STRINGS,       "MENU Text Strings" },
	{ R_RST_38H_DRIVER,          "RST 38H RAM vector driver routine" },
	{ R_RST_5_5_VECTOR,          "RST 5.5 RAM Vector" },
	{ R_RST_6_5_VECTOR,          "RST 6.5 RAM Vector" },
	{ R_RST_7_5_VECTOR,          "RST 7.5 RAM Vector" },
	{ R_TRAP_VECTOR,             "RAM vector for TRAP interrupt" },
	{ R_DETECT_OPTION_ROM,       "Detect Option ROM" },
	{ R_BASIC_RUNNING,		     "BASIC Program Running Flag" },
	{ R_INIT_BASIC_VARS,	     "Initialize BASIC Variables for new execution" },
	{ R_INIT_TEMP3,			     "Initialize FP_TEMP3 for new program" },
	{ R_RENUM_STMT,			     "RENUM Statement" },
	{ R_TEST_COM_TOKEN,		     "Test for COM token (ON COM Statement)" },
	{ R_CMD_STMT,			     "CMD Statement" },
	{ R_LOCATE_STMT,		     "LOCATE Statement" },
	{ R_COLOR_STMT,			     "COLOR Statement" },
	{ R_EXEC_STMT,			     "EXEC Statement" },
	{ R_BSAVE_STMT,			     "BSAVE Statement" },
	{ R_BLOAD_STMT,			     "BLOAD Statement" },
	{ R_DSKF_FUN,			     "DSKF Function" },
	{ R_FORMAT_FUN,			     "FORMAT Function" },
	{ R_PORT_90H,			     "Current value of OUT port 90H" },
	{ R_RST0_HOOK,			     "RST 0 Hook" },
	{ R_EXEC_2ND_ROM,		     "Hook to execute Option ROM" },
	{ R_TELCOM_FKEY_VCTR,	     "Main TELCOM Funciton Key Vector Table" },
	{ R_UNUSED,				     "Unused Space" },
	{ -1, "" },
};
