        TITLE Virtual Disk to MS-DOS Read
        ;Copyright (C) 1993 Jeff Vavasour

        ASSUME CS:PROG,DS:PROG
PROG    SEGMENT 'CODE'
START:  MOV DI,129
        MOV DX,DI
        MOV BL,0
PARSE:  MOV AL,[DI]
        INC DI
        CMP AL,13
        JZ PARSE2
        CMP AL,32
        JNZ PARSE1
        MOV BL,0
        MOV DX,DI
        JMP PARSE
PARSE1: CMP AL,'.'
        JNZ PARSE
        MOV BL,1
        JMP PARSE
PARSE2: DEC BL
        JZ PARSE3
        MOV WORD PTR [DI-1],442EH
        MOV WORD PTR [DI+1],4B53H
        ADD DI,4
PARSE3: MOV BYTE PTR [DI-1],0
        MOV SI,128
PARSE4: INC SI
        CMP BYTE PTR [SI],32
        JZ PARSE4
        MOV DI,OFFSET SEARCH
PARSE5: MOV AL,[SI]
        INC SI
        CMP AL,'a'
        JB PARSE5A
        CMP AL,'z'
        JA PARSE5A
        SUB AL,20H
PARSE5A:
        CMP AL,13
        JZ NO_DISK
        CMP AL,32
        JZ PARSE9
        CMP AL,'*'
        JNZ PARSE7
PARSE6: MOV BYTE PTR CS:[DI],'?'
        INC DI
        CMP DI,OFFSET SEARCH+8
        JB PARSE6
        JZ PARSE5
        CMP DI,OFFSET SEARCH+11
        JB PARSE6
        JMP PARSE9
PARSE7: CMP AL,'.'
        JZ PARSE8
        CMP AL,'/'
        JZ PARSE8
        MOV CS:[DI],AL
        INC DI
        CMP DI,OFFSET SEARCH+11
        JB PARSE5
        JMP PARSE9
PARSE8: MOV DI,OFFSET SEARCH+8
        JMP PARSE5
NO_DISK:
        MOV AH,9
        MOV DX,OFFSET ERRMSG2
        PUSH CS
        POP DS
        INT 21H
        MOV AX,4C00H
        INT 21H
PARSE9: MOV AX,3D00H
        INT 21H
        MOV BX,AX
        PUSH CS
        POP DS
        JNB OK
ERROR:  MOV AH,3EH
        INT 21H
        MOV AH,9
        MOV DX,OFFSET ERRMSG
        INT 21H
        MOV AX,4C00H
        INT 21H
OK:     MOV AH,3FH
        MOV DX,OFFSET DTA
        mov si,dx
        MOV CX,3
        INT 21H
        JB ERROR
        MOV AL,[si+2]
        MOV AH,0
        MOV CX,2560
        MUL CX
        MOV CX,DX
        MOV DX,AX
        MOV AX,4200H
        INT 21H
        MOV AH,3FH
        MOV DX,OFFSET DIR
        MOV CX,512
        INT 21H
        JB ERROR
        MOV AH,3FH
        MOV DX,OFFSET DIR
        MOV CX,2048
        INT 21H
        JB ERROR
        MOV HANDLE,BX
        MOV SI,OFFSET DIR
FIND:   CMP BYTE PTR [SI],16
        MOV BX,0
        JZ FIND1
NEXT:   ADD SI,32
        CMP SI,OFFSET DIR+2048
        JB FIND
        CMP BYTE PTR FOUND,0
        JNZ DONE
        MOV AH,9
        MOV DX,OFFSET MSG3
        INT 21H
        MOV BX,0
MASK0:  MOV DL,SEARCH[BX]
        CMP DL,' '
        JZ MASK1
        MOV AH,2
        INT 21H
MASK1:  INC BX
        CMP BX,8
        JNZ MASK2
        CMP BYTE PTR SEARCH[BX],' '
        JZ MASK2
        MOV AH,2
        MOV DL,'/'
        INT 21H
MASK2:  CMP BX,11
        JB MASK0
DONE:   MOV AX,4C00H
        INT 21H
FIND1:  MOV AL,SEARCH[BX]
        CMP AL,'?'       
        JZ FIND2
        CMP AL,[SI+BX+5]
        JNZ NEXT
FIND2:  INC BX
        CMP BX,11
        JB FIND1
        MOV AH,9
        MOV DX,OFFSET MSG1
        INT 21H
        MOV BX,0
        MOV DI,OFFSET OUTPUT
FIND3:  MOV DL,[SI+BX+5]
        MOV AH,2
        CMP DL,' '
        JZ FIND4
        MOV [DI],DL
        INC DI
        INT 21H
FIND4:  INC BX
        CMP BX,8
        JNZ FIND5
        MOV AH,2
        CMP BYTE PTR [SI+BX+5],' '
        JZ FIND5
        MOV DL,'.'
        MOV [DI],DL
        INC DI
        INT 21H
FIND5:  CMP BX,11
        JB FIND3
        MOV BYTE PTR [DI],0
        CALL EXTRACT
        MOV AH,9
        MOV DX,OFFSET MSG2
        INT 21H
        MOV FOUND,1
        JMP NEXT

EXTRACT PROC NEAR
        MOV AX,3D00H
        MOV DX,OFFSET OUTPUT
        INT 21H
        JB LOAD
        mov bx,ax
        mov ah,3eh
        int 21h
        MOV AH,9
        MOV DX,OFFSET MSG5
        INT 21H
KEY:    MOV AH,1
        INT 21H
        AND AL,223
        CMP AL,'Y'
        JZ LOAD
        CMP AL,'N'
        JNZ RETRY
        RET
RETRY:  MOV DL,8
        MOV AH,2
        INT 21H
        JMP KEY
LOAD:   MOV AH,3CH
        MOV DX,OFFSET OUTPUT
        MOV CX,0
        INT 21H
        MOV OUTHAN,AX
        JNB EXT0
EXTERR: MOV BX,OUTHAN
        MOV AH,3EH
        INT 21H
        MOV AH,9
        MOV DX,OFFSET MSG4
        INT 21H
        RET
EXT0:   MOV DI,SI
        MOV BX,22
        MOV CX,[SI+20]
EXT1:   MOV AL,[DI+BX]
        MOV AH,0
        MOV DX,2560
        MUL DX
        TEST BYTE PTR [DI+BX+1],32
        JZ EXT2
        ADD AX,1280
        ADC DX,0
EXT2:   PUSH BX
        PUSH CX
        MOV CX,DX
        MOV DX,AX
        MOV AL,[DI+BX+1]
        AND AL,31
        INC AL
        MOV AH,5
        MUL AH
        PUSH AX
        MOV AX,4200H
        MOV BX,HANDLE
        INT 21H
        POP CX
        PUSH CX
        MOV CH,CL
        MOV CL,0
        MOV AH,3FH
        MOV BX,HANDLE
        MOV DX,OFFSET DTA
        INT 21H
        POP AX
        POP CX
        POP BX
        SUB CX,AX        
        JNA EXT3
        PUSH BX
        PUSH CX
        MOV CH,AL
        MOV CL,0
        MOV BX,OUTHAN
        MOV DX,OFFSET DTA
        MOV AH,40H
        INT 21H
        POP CX
        POP BX
        JB EXTERR
        ADD BX,2
        CMP BX,30
        JB EXT1
        MOV AL,[DI+31]
        MOV AH,AL
        AND AX,0FF0H
        ADD AX,OFFSET DIR
        MOV DI,AX
        MOV BX,22
        JMP EXT1
EXT3:   ADD CX,AX
        MOV CH,CL
        MOV CL,[SI+3]
        CMP CL,0
        JZ EXT4
        DEC CH
EXT4:   MOV AH,40H
        MOV BX,OUTHAN
        MOV DX,OFFSET DTA
        INT 21H
        MOV AH,3EH
        INT 21H
        RET
EXTRACT ENDP
HANDLE  DW ?
OUTHAN  DW ?
ERRMSG  DB 7,'Cannot open virtual disk by that name.',13,10
ERRMSG2 DB 'Command format is "VREAD <filename> <diskname>".$'
MSG1    DB 'Extracting $'
MSG2    DB 13,10,'$'
MSG3    DB 7,'No files matching $'
MSG4    DB ' --- could not write file.$'
MSG5    DB ' -- file exists.  Overwrite? (Y/N) $'
OUTPUT  DB '             ',0
SEARCH  DB '           '
FOUND   DB 0
DIR     equ $
DTA     equ $+2048

PROG    ENDS
        END START
