        TITLE MS-DOS to Virtual Disk File Write
        ;Copyright (C) 1993 Jeff Vavasour

        ASSUME CS:PROG,DS:PROG
PROG    SEGMENT 'CODE'
START:  MOV DI,129
        MOV DX,DI
        MOV BL,0
PARSE:  MOV AL,[DI]
        INC DI
        CMP AL,13
        JZ PARSE2
        CMP AL,32
        JNZ PARSE1
        MOV BL,0
        MOV DX,DI
        JMP PARSE
PARSE1: CMP AL,'.'
        JNZ PARSE
        MOV BL,1
        JMP PARSE
PARSE2: DEC BL
        JZ PARSE3
        MOV WORD PTR [DI-1],442EH
        MOV WORD PTR [DI+1],4B53H
        ADD DI,4
PARSE3: MOV BYTE PTR [DI-1],0
        MOV SI,128
PARSE4: INC SI
        CMP BYTE PTR [SI],32
        JZ PARSE4
        MOV DI,OFFSET SEARCH
PARSE5: MOV AL,[SI]
        INC SI
        CMP AL,'a'
        JB PARSE5A
        CMP AL,'z'
        JA PARSE5A
        SUB AL,20H
PARSE5A:
        CMP AL,13
        JZ NO_DISK
        CMP AL,32
        JZ PARSE9
        CMP AL,'*'
        JNZ PARSE7
PARSE6: MOV BYTE PTR CS:[DI],'?'
        INC DI
        CMP DI,OFFSET SEARCH+8
        JB PARSE6
        JZ PARSE5
        CMP DI,OFFSET SEARCH+11
        JB PARSE6
        JMP PARSE9
PARSE7: CMP AL,'.'
        JZ PARSE8
        CMP AL,'/'
        JZ PARSE8
        MOV CS:[DI],AL
        INC DI
        CMP DI,OFFSET SEARCH+11
        JB PARSE5
        JMP PARSE9
PARSE8: MOV DI,OFFSET SEARCH+8
        JMP PARSE5
NO_DISK:
        MOV AH,9
        MOV DX,OFFSET ERRMSG2
        PUSH CS
        POP DS
        INT 21H
        MOV AX,4C00H
        INT 21H
PARSE9: MOV AX,3D02H
        INT 21H
        MOV BX,AX
        PUSH CS
        POP DS
        JNB OK
ERROR:  MOV AH,3EH
        INT 21H
        MOV AH,9
        MOV DX,OFFSET ERRMSG
        INT 21H
        MOV AX,4C00H
        INT 21H
OK:     MOV AH,3FH
        MOV DX,OFFSET DIR
        mov si,dx
        MOV CX,3
        INT 21H
        JB ERROR
        MOV AL,[si+2]
        MOV AH,0
        MOV CX,2560
        MUL CX
        MOV CX,DX
        MOV DX,AX
        MOV DIRLSB,DX
        MOV DIRMSB,CX
        MOV AX,4200H
        INT 21H
        MOV AH,3FH
        MOV DX,OFFSET DIR
        MOV CX,2560
        INT 21H
        JB ERROR
        MOV HANDLE,BX
        MOV AH,1AH
        MOV DX,OFFSET FCB
        INT 21H
        MOV AH,11H
        MOV DX,OFFSET LOOKFCB
        INT 21H
        INC AL
        JNZ LOAD
        MOV AH,9
        MOV DX,OFFSET MSG3
        INT 21H
        MOV BX,0
MASK0:  MOV DL,SEARCH[BX]
        CMP DL,' '
        JZ MASK1
        MOV AH,2
        INT 21H
MASK1:  INC BX
        CMP BX,8
        JNZ MASK2
        CMP BYTE PTR SEARCH[BX],' '
        JZ MASK2
        MOV AH,2
        MOV DL,'/'
        INT 21H
MASK2:  CMP BX,11
        JB MASK0
        JMP EXIT
LOAD:   MOV DI,OFFSET FILES
        MOV CURRENT,DI
LOAD1:  MOV SI,OFFSET FCB+1
        MOV CX,11
        PUSH DS
        POP ES
        REP MOVSB
        CMP DI,OFFSET FILES+704
        JNB FIND
        MOV AH,12H
        MOV DX,OFFSET LOOKFCB
        INT 21H
        INC AL
        JNZ LOAD1
FIND:   MOV AH,9
        MOV DX,OFFSET MSG1
        INT 21H
        MOV DI,OFFSET INPUT
        MOV BX,0
        MOV SI,CURRENT
FIND3:  MOV DL,[BX+SI]
        CMP DL,' '
        JZ FIND4
        MOV [DI],DL
        INC DI
        MOV AH,2
        INT 21H
FIND4:  INC BX
        CMP BX,8
        JNZ FIND5
        CMP BYTE PTR [BX+SI],' '
        JZ FIND5
        MOV DL,'.'
        MOV [DI],DL
        INC DI
        MOV AH,2
        INT 21H
FIND5:  CMP BX,11
        JB FIND3
        MOV BYTE PTR [DI],0
        MOV SI,OFFSET DIR+512
OLD:    MOV BX,5
        MOV DI,CURRENT
OLD1:   MOV AL,[SI+BX]
        CMP AL,[DI]
        JNZ OLD2
        INC DI
        INC BX
        CMP BX,16
        JB OLD1
        CMP BYTE PTR [SI],16
        JNZ OLD2
        MOV AH,9
        MOV DX,OFFSET MSG4
        INT 21H
        MOV AH,1
        INT 21H
        AND AL,223
        CMP AL,'N'
        JZ NEXT
        CMP AL,'Y'
        JNZ REDO
        CALL DELETE
        CALL UPDATE
        JMP WRITE
REDO:   MOV AH,9
        MOV DX,OFFSET MSG2
        INT 21H
        JMP FIND
OLD2:   ADD SI,32
        CMP SI,OFFSET DIR+2560
        JB OLD
WRITE:  CALL SAVE
        CALL UPDATE
NEXT:   MOV AH,9
        MOV DX,OFFSET MSG2
        INT 21H
        ADD CURRENT,11
        MOV SI,CURRENT
        CMP BYTE PTR [SI],0
        JZ EXIT
        JMP FIND
EXIT:   MOV AX,4C00H
        INT 21H

DELETE  PROC NEAR
        MOV DI,SI
DEL1:   AND BYTE PTR [DI],239
        MOV BX,DI
        SUB BX,OFFSET DIR+512
        OR BL,BH
        MOV BH,0
        MOV BYTE PTR DIR[BX+256],0
        MOV BX,22
DEL2:   MOV AL,[DI+BX]
        CMP AL,255
        JZ DEL6
        MOV AH,0
        ADD AX,OFFSET DIR
        MOV CL,[DI+BX+1]
        MOV CH,0
        PUSH BX
        MOV BX,AX
        MOV AL,0FEH
        TEST CL,32
        JZ DEL3
        AND CL,31
        ROL AL,1
DEL3:   INC CX
DEL4:   AND [BX],AL
        ROL AL,1
        CMP AL,0FBH
        JNZ DEL5
        INC BX
        MOV AL,0FEH
DEL5:   LOOP DEL4
        POP BX
        ADD BX,2
        CMP BX,30
        JB DEL2
        CMP BYTE PTR [DI+BX],255
        JZ DEL6
        MOV AL,[DI+BX+1]
        MOV AH,AL
        AND AX,0FF0H
        ADD AX,OFFSET DIR+512
        MOV DI,AX
        JMP DEL1
DEL6:   RET
DELETE  ENDP

UPDATE  PROC NEAR
        MOV AX,4200H
        MOV BX,HANDLE
        MOV DX,DIRLSB
        MOV CX,DIRMSB
        INT 21H
        MOV BX,HANDLE
        MOV AH,40H
        MOV CX,2560
        MOV DX,OFFSET DIR
        INT 21H
        RET
UPDATE  ENDP

FREEFDE PROC NEAR
        MOV SI,OFFSET DIR+512
FREEF1: TEST BYTE PTR [SI],16
        JZ FREEF2
        ADD SI,32
        CMP SI,OFFSET DIR+2560
        JB FREEF1
        MOV AH,9
        MOV DX,OFFSET DIRFULL
        INT 21H
        MOV AH,3EH
        MOV BX,INHANDL
        INT 21H
        MOV AH,3EH
        MOV BX,HANDLE
        INT 21H
        MOV AX,4C00H
        INT 21H
FREEF2: MOV DI,SI
        MOV SI,OFFSET BLANK
        MOV CX,32
        PUSH DI
        REP MOVSB
        POP SI
        RET
FREEFDE ENDP

HIT     PROC NEAR
        PUSH AX
        PUSH BX
        PUSH DI
        MOV DI,CURRENT
        MOV BX,0
        MOV AL,0
HIT1:   XOR AL,[DI+BX]
        ROL AL,1
        INC BX
        CMP BX,11
        JB HIT1
        CMP AL,0
        JNZ HIT2
        INC AL
HIT2:   MOV BX,SI
        SUB BX,OFFSET DIR+512
        OR BL,BH
        MOV BH,0
        MOV DIR[BX+256],AL
        POP DI
        POP BX
        POP AX
        RET
HIT     ENDP

SAVE    PROC NEAR
        MOV LASTLSB,-1
        MOV LASTMSB,-1
        CALL FREEFDE
        MOV BYTE PTR [SI],16
        MOV WORD PTR [SI+16],4296H
        MOV WORD PTR [SI+18],4296H
        PUSH SI
        MOV DI,SI
        ADD DI,5
        MOV SI,CURRENT
        MOV CX,11
        REP MOVSB
        POP SI
        MOV FIRST,SI
        CALL HIT
        MOV AX,3D00H
        MOV DX,OFFSET INPUT
        INT 21H
        MOV INHANDL,AX
        JNB SAVE2
SAVE1:  MOV BX,INHANDL
        MOV AH,3EH
        INT 21H
        MOV AH,9
        MOV DX,OFFSET MSG5
        INT 21H
        RET
SAVE2:  MOV AH,3FH
        MOV CX,1280
        MOV DX,OFFSET DTA
        MOV BX,INHANDL
        INT 21H
        MOV FRAC,AX
        JB SAVE1
        CMP AX,0
        MOV DI,0
        JNZ SAVE3
        JMP SAVEX
SAVE3:  CMP BYTE PTR DIR[DI],0FFH
        JNZ SAVE4
        INC DI
        CMP DI,96
        JB SAVE3
        MOV AH,9
        MOV DX,OFFSET DSKFULL
        INT 21H
        MOV AH,3EH
        MOV BX,INHANDL
        INT 21H
        MOV AH,3EH
        MOV BX,HANDLE
        INT 21H
        MOV AX,4C00H
        INT 21H
SAVE4:  MOV AX,DI
        MOV TRACK,AL
        MOV GRAN,0
        TEST BYTE PTR DIR[DI],1
        PUSHF
        OR BYTE PTR DIR[DI],1
        MOV CX,2560
        MUL CX
        POPF
        JZ SAVE5
        OR BYTE PTR DIR[DI],2
        MOV GRAN,32
        ADD AX,1280
        ADC DX,0
SAVE5:  MOV CX,DX
        MOV DX,AX
        PUSH CX
        PUSH DX
        MOV BX,HANDLE
        MOV AX,4200H
        INT 21H
        MOV BX,20
SAVE6:  ADD BX,2
        CMP BYTE PTR [SI+BX],255
        JNZ SAVE6
        CMP DX,LASTMSB
        JNZ SAVE7
        CMP AX,LASTLSB
        JNZ SAVE7
        MOV AL,[SI+BX-1]
        INC BYTE PTR [SI+BX-1]
        AND AL,31
        CMP AL,31
        JNZ SAVE9
        DEC BYTE PTR [SI+BX-1]
SAVE7:  CMP BX,30
        JNB SAVE8
        MOV AL,TRACK        
        MOV [SI+BX],AL
        MOV AL,GRAN
        MOV [SI+BX+1],AL
        JMP SAVE9
SAVE8:  PUSH SI
        CALL FREEFDE
        CALL HIT
        MOV BYTE PTR [SI],90H
        POP DI
        MOV AX,SI
        SUB AX,OFFSET DIR+512
        OR AH,AL
        MOV AL,0FEH
        MOV [DI+30],AX
        MOV AX,DI
        SUB AX,OFFSET DIR+512
        OR AL,AH
        MOV [SI+1],AL
        MOV AL,TRACK
        MOV [SI+22],AL
        MOV AL,GRAN
        MOV [SI+23],AL
SAVE9:  POP DX
        POP CX
        ADD DX,1280
        ADC CX,0
        MOV LASTLSB,DX
        MOV LASTMSB,CX
        MOV AH,40H
        MOV DX,OFFSET DTA
        MOV CX,1280
        MOV BX,HANDLE
        INT 21H
        MOV AX,FRAC
        CMP AX,1280
        MOV DI,FIRST
        JB SAVE10
        ADD WORD PTR [DI+20],5
        JMP SAVE2
SAVE10: MOV [DI+3],AL
        CMP AL,0
        MOV AL,AH
        MOV AH,0
        JZ SAVE11        
        INC AX
SAVE11: ADD WORD PTR [DI+20],AX
SAVEX:  MOV AH,3EH
        MOV BX,INHANDL
        INT 21H
        RET
SAVE    ENDP

HANDLE  DW ?
INHANDL DW ?
OUTHAN  DW ?
CURRENT DW ?
LASTLSB DW ?
LASTMSB DW ?
TRACK   DB ?
GRAN    DB ?
FIRST   DW ?
FRAC    DW ?
ERRMSG  DB 7,'Cannot open virtual disk by that name.',13,10
ERRMSG2 DB 'Command format is "VDEL <filename> <diskname>".$'
MSG1    DB 'Writing $'
MSG2    DB 13,10,'$'
MSG3    DB 7,'No files matching $'
MSG4    DB ' -- file exists.  Overwrite? (Y/N) $'
MSG5    DB ' -- can',27H,'t open/read file$'
DIRFULL DB 7,13,10,'Virtual directory full.',13,10,'$'
DSKFULL DB 7,13,10,'Virtual disk full.',13,10,'$'
LOOKFCB DB 0
SEARCH  DB '           '
INPUT   DB '           ',0
DIRLSB  DW 0
DIRMSB  DW 0
BLANK   DB 22 DUP(0),10 DUP(255)
FCB     DB 128 DUP(0)
FILES   DB 705 DUP(0)
DIR     DB 0
DTA     EQU $+2560
PROG    ENDS
        END START
