        TITLE TRS-80 Model I Emulator (Version 3.02u)
        ;Copyright (C) 1990-1997 Jeff Vavasour

        NAME MODEL1
    
;General structure: CS and DS are program and system data, ES is TRS-80's RAM
    
        ASSUME CS:PROG,DS:PROG
STACK   SEGMENT STACK
        db 512 dup(?)
STACK   ENDS

PROG    SEGMENT

;00-1F  Main instruction set
SET1 DW ZNOP,   ZLSSNN, ZLSSA,  ZINCSS, ZINCR,  ZDECR,  ZLRN,   ZRLCA
     DW ZEXAF,  ZADHLSS,ZLASS,  ZDECSS, ZINCR,  ZDECR,  ZLRN,   ZRRCA
     DW ZDJNZ,  ZLSSNN, ZLSSA,  ZINCSS, ZINCR,  ZDECR,  ZLRN,   ZRLA
     DW ZJR,    ZADHLSS,ZLASS,  ZDECSS, ZINCR,  ZDECR,  ZLRN,   ZRRA
;20-2F
     DW ZJRC,   ZLSSNN, ZLMHL,  ZINCSS, ZINCR,  ZDECR,  ZLRN,   ZDAA
     DW ZJRC,   ZADHLSS,ZLHLM,  ZDECSS, ZINCR,  ZDECR,  ZLRN,   ZCPL
     DW ZJRC,   ZLSSNN, ZLMA,   ZINCSS, ZINCHL, ZDECHL, ZLHLN,  ZSCF
     DW ZJRC,   ZADHLSS,ZLAM,   ZDECSS, ZINCR,  ZDECR,  ZLRN,   ZCCF
;40-5F
     DW ZLRR,   ZLRR,   ZLRR,   ZLRR,   ZLRR,   ZLRR,   ZLRHL,  ZLRR
     DW ZLRR,   ZLRR,   ZLRR,   ZLRR,   ZLRR,   ZLRR,   ZLRHL,  ZLRR
     DW ZLRR,   ZLRR,   ZLRR,   ZLRR,   ZLRR,   ZLRR,   ZLRHL,  ZLRR
     DW ZLRR,   ZLRR,   ZLRR,   ZLRR,   ZLRR,   ZLRR,   ZLRHL,  ZLRR
;60-7F
     DW ZLRR,   ZLRR,   ZLRR,   ZLRR,   ZLRR,   ZLRR,   ZLRHL,  ZLRR
     DW ZLRR,   ZLRR,   ZLRR,   ZLRR,   ZLRR,   ZLRR,   ZLRHL,  ZLRR
     DW ZLHLR,  ZLHLR,  ZLHLR,  ZLHLR,  ZLHLR,  ZLHLR,  ZHALT,  ZLHLR
     DW ZLRR,   ZLRR,   ZLRR,   ZLRR,   ZLRR,   ZLRR,   ZLRHL,  ZLRR
;80-9F
     DW ZADDAR, ZADDAR, ZADDAR, ZADDAR, ZADDAR, ZADDAR, ZADDAHL,ZADDAR
     DW ZADCAR, ZADCAR, ZADCAR, ZADCAR, ZADCAR, ZADCAR, ZADCAHL,ZADCAR
     DW ZSUBAR, ZSUBAR, ZSUBAR, ZSUBAR, ZSUBAR, ZSUBAR, ZSUBAHL,ZSUBAR
     DW ZSBCAR, ZSBCAR, ZSBCAR, ZSBCAR, ZSBCAR, ZSBCAR, ZSBCAHL,ZSBCAR
;A0-BF
     DW ZANDR,  ZANDR,  ZANDR,  ZANDR,  ZANDR,  ZANDR,  ZANDHL, ZANDR
     DW ZXORR,  ZXORR,  ZXORR,  ZXORR,  ZXORR,  ZXORR,  ZXORHL, ZXORR
     DW ZORR,   ZORR,   ZORR,   ZORR,   ZORR,   ZORR,   ZORHL,  ZORR
     DW ZCPR,   ZCPR,   ZCPR,   ZCPR,   ZCPR,   ZCPR,   ZCPHL,  ZCPR
;C0-DF
     DW ZRETC,  ZPOPSS, ZJPC,   ZJP,    ZCALLC, ZPUSHSS,ZADDAN, ZRST
     DW ZRETC,  ZRET,   ZJPC,   CBPREF, ZCALLC, ZCALL,  ZADCAN, ZRST
     DW ZRETC,  ZPOPSS, ZJPC,   ZOUTNA, ZCALLC, ZPUSHSS,ZSUBN,  ZRST
     DW ZRETC,  ZEXX,   ZJPC,   ZINNA,  ZCALLC, IXPREF, ZSBCAN, ZRST
;E0-FF
     DW ZRETC,  ZPOPSS, ZJPC,   ZEXSPHL,ZCALLC, ZPUSHSS,ZANDN,  ZRST
     DW ZRETC,  ZJPHL,  ZJPC,   ZEXDEHL,ZCALLC, EDPREF, ZXORN,  ZRST
     DW ZRETC,  ZPOPAF, ZJPC,   ZDI,    ZCALLC, ZPUSHAF,ZORN,   ZRST
     DW ZRETC,  ZLDSPHL,ZJPC,   ZEI,    ZCALLC, IYPREF, ZCPN,   ZRST

;00-1F  ED prefix instruction set
SET3 DW ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD     
     DW ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD     
     DW ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD     
     DW ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD     
;20-3F
     DW ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD     
     DW ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD     
     DW ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD     
     DW ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD     
;40-5F
     DW ZINRC,  ZOUTRC, ZSBCHL, ZLMSS,  ZNEG,   ZRETN,  ZIMN,   ZLDIA
     DW ZINRC,  ZOUTRC, ZADCHL, ZLSSM,  ZBAD,   ZRETI,  ZBAD,   ZLDRA
     DW ZINRC,  ZOUTRC, ZSBCHL, ZLMSS,  ZBAD,   ZBAD,   ZIMN,   ZLDAI
     DW ZINRC,  ZOUTRC, ZADCHL, ZLSSM,  ZBAD,   ZBAD,   ZIMN,   ZLDAR
;60-7F
     DW ZINRC,  ZOUTRC, ZSBCHL, ZLMSS,  ZBAD,   ZBAD,   ZBAD,   ZRRD
     DW ZINRC,  ZOUTRC, ZADCHL, ZLSSM,  ZBAD,   ZBAD,   ZBAD,   ZRLD
     DW ZBAD,   ZBAD,   ZSBCHL, ZLMSS,  ZBAD,   ZBAD,   ZBAD,   ZBAD
     DW ZINRC,  ZOUTRC, ZADCHL, ZLSSM,  ZBAD,   ZBAD,   ZBAD,   ZBAD
;80-9F
     DW ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD
     DW ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD
     DW ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD
     DW ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD
;A0-BF
     DW ZLDI,   ZCPI,   ZINI,   ZOUTI,  ZBAD,   ZBAD,   ZBAD,   ZBAD
     DW ZLDD,   ZCPD,   ZIND,   ZOUTD,  ZBAD,   ZBAD,   ZBAD,   ZBAD
     DW ZLDIR,  ZCPIR,  ZINIR,  ZOTIR,  ZBAD,   ZBAD,   ZBAD,   ZBAD
     DW ZLDDR,  ZCPDR,  ZINDR,  ZOTDR,  ZBAD,   ZBAD,   ZBAD,   ZBAD
;C0-DF
     DW ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD     
     DW ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD     
     DW ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD     
     DW ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD     
;E0-EF
     DW ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD     
     DW ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD     
     DW ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD     
     DW ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD,   ZBAD     

;00-FF  CB prefix instruction set (1 vector represents 8 instructions)
SET2 DW ZRLCR,  ZRRCR,  ZRLR,   ZRRR,   ZSLAR,  ZSRAR,  ZBAD,   ZSRLR
     DW ZBIT,   ZBIT,   ZBIT,   ZBIT,   ZBIT,   ZBIT,   ZBIT,   ZBIT
     DW ZRES,   ZRES,   ZRES,   ZRES,   ZRES,   ZRES,   ZRES,   ZRES
     DW ZSET,   ZSET,   ZSET,   ZSET,   ZSET,   ZSET,   ZSET,   ZSET

;Common macros

MEM_R8  MACRO           ;Read a byte from memory [DI] -> AL
    MOV AL,ES:[DI]      ;Does direct memory I/O unless it's in a protected
    CMP DI,3800H        ;part of the Model I's memory.
    JNB $+11
    CMP DI,37E0H
    JB $+5
    CALL GETBYTE
    ENDM

MEM_R16 MACRO           ;Read a word from memory [DI] -> AX
    MOV AX,ES:[DI]
    CMP DI,3800H
    JNB $+11
    CMP DI,37DFH
    JB $+5
    CALL GETWORD
    ENDM

MEM_W8  MACRO           ;Write a byte to memory AL -> [DI]
    CMP DI,4000H
    JNB $+7
    CALL PUTBYTE
    JMP $+5
    MOV ES:[DI],AL
    ENDM

MEM_W16 MACRO           ;Write a word to memory AX -> [DI]
    INC DI
    CMP DI,4001H
    JNB $+8
    DEC DI
    CALL PUTWORD
    JMP $+6
    DEC DI
    MOV ES:[DI],AX
    ENDM

GETFLAG MACRO       ;Transfer Z-80 flags to 8086 flags
    MOV AH,REGF
    SAHF
    ENDM

PUTFLAGP MACRO      ;Transfer 8086 flags (with parity) to Z-80 flags
    LAHF
    AND AH,0D5H
    MOV REGF,AH
    ENDM

SUBOPER MACRO      ;Set "last operation was subtraction" flag
    OR CS:REGF,2   ;used in Z-80 DAA instruction
    ENDM

GETB macro         ;Return bits 5-3 of DL in CL
    MOV CL,DL      ;This is where the 0-7 is stored in the BIT, RES, and
    SHR CL,1       ;SET instructions
    SHR CL,1
    SHR CL,1
    AND CL,7
    endm

GETR1   MACRO      ;Get 8-bit register ID from opcode in DL
    MOV SI,DX      ;Stored in bits 5-3
    SHR SI,1
    SHR SI,1
    AND SI,14
    MOV SI,REGIDX[SI]
    ENDM

;Pointer tables.  0=B, 1=C, 2=D, 3=E, 4=H, 5=L, 6=F, 7=A.
REGIDX  DW REGB,REGC,REGD,REGE,REGH,REGL,REGF,REGA

GETR2   MACRO      ;Get 8-bit register pointer from bit field 2-0
    MOV SI,DX
    AND SI,7
    SHL SI,1
    MOV SI,REGIDX[SI]
    ENDM

;16-bit register pointer table.  0=BC, 1=DE, 2=HL, 3=SP
reg16   dw regc,rege
indexreg dw regl
        dw regsp

GETSS   macro      ;Get 16-bit register pointer from bit field 5-4
    mov si,dx
    mov cl,3
    ror si,cl
    and si,6
    mov si,reg16[si]
    endm

bcd_to_bin macro reg    ;Convert BCD in reg to binary number
    mov ah,0
    mov al,reg
    mov bl,16
    div bl
    mov bh,ah
    mov bl,10
    mul bl
    add al,bh
    mov reg,al
    endm

;PC interrupt handlers

comint:                 ;Serial port buffer interrupt
    push ax             ;This will read a byte that is waiting in the serial
    push cx             ;port receive register and store it in the 1K CACHE.
    push dx             ;MDMBUFPTR indicates the end of the stored data.
comint1:
    mov dx,cs:comstat
    in al,dx
    shr al,1
    jb comint2
    mov al,32
    out 32,al
    pop dx
    pop cx
    pop ax
    iret
comint2:
    sub dl,5
    in al,dx
    push si
    mov si,cs:mdmbufptr
    mov byte ptr cs:cache[si],al
    inc si
    and si,1023
    mov cs:mdmbufptr,si
    pop si
    jmp comint1

FATAL:  MOV AL,0            ;Disable fatal error interrupt
CTRLC:  IRET                ;Disable CTRL-BREAK interrupt

MARGIN  DB 0                ;Non-zero if there's a message in the corner
CTRL_KEY DB 128             ;Indicates whether CTRL last pressed or released
SHIFT_STATE DB 0            ;Bit 0=left SHIFT, 1=right SHIFT
                            ;    3=Extended keyboard prefix received
KEY_BIOS:
    pop ax
    db 0eah
oldlow  dw ?
oldhi   dw ?

KEYDMA: PUSH AX             ;Keyboard emulation.  Scancodes are compared
    IN AL,96                ;to those listed in LOOKUP and the appropriate
    MOV CS:LASTSCAN,AL      ;bits are set or reset in the TRS-80's keyboard
    MOV AH,AL
    AND AH,127
    CMP AH,45H
    JZ KEY_BIOS
    CMP AH,1DH
    JNZ NO_CTRL
    MOV CS:CTRL_KEY,AL
NO_CTRL:
    MOV AH,CS:CTRL_KEY
    CMP AX,1D3BH                ;Check for CTRL-F1=Reset
    MOV AH,OFFSET BRANCH8-OFFSET BRANCH1
    JZ KEY_BRANCH
    mov ah,0
    cmp al,40H                  ;F6=debug
    jz key_branch
    mov ah,offset branch2-offset branch1
    cmp al,3ch                  ;F2=Virtual Disk Menu
    jz key_branch
    mov ah,offset branch3-offset branch1
        CMP AL,3DH              ;F3=Snapshot Menu
        JZ KEY_BRANCH
        MOV AH,OFFSET BRANCH6-OFFSET BRANCH1
        CMP AL,3EH              ;F4=virtual cassette menu
        JZ KEY_BRANCH
        MOV AH,OFFSET BRANCH7-OFFSET BRANCH1
        CMP AL,3BH              ;F1=help
        JNZ NO_FUNC_KEY
key_branch:
    OR BYTE PTR CS:SYSSTAT,64
    mov cs:old_branch,ah
    mov cs:branch,ah
    mov cs:timer,0
    mov al,-1
NO_FUNC_KEY:
    CMP CS:MARGIN,0     ;Clear old margin message if any
    JZ NO_MARGIN_CLEAR
    TEST AL,128         ;Unless it's a key being released
    JNZ NO_MARGIN_CLEAR
    PUSH DI
    MOV DI,OFFSET MSG26
    CALL NOTE
    POP DI
    MOV CS:MARGIN,0
NO_MARGIN_CLEAR:
    CMP AL,41H          ;F7=keyboard layout toggle
    JNZ NO_KEY_TOGGLE
    CMP CS:CTRL_KEY,1DH
    JZ NO_KEY_TOGGLE
    PUSH AX
    PUSH DI
    MOV AL,CS:KEY_MODE  ;Cycle through mode 0, 1
    INC AL
    AND AL,1
    MOV CS:KEY_MODE,AL
    MOV AH,16           ;Display the appropriate message
    MUL AH
    ADD AX,OFFSET MSG25
    MOV DI,AX
    CALL NOTE
    POP DI
    POP AX
NO_KEY_TOGGLE:
    MOV AH,AL
    AND AL,127
    CMP AH,0E0H         ;E0h indicates next byte will be an extended key
    JA KEY_BIOS1        ;Leave codes we can't handle to the BIOS
    PUSH BX
    PUSH CX
    PUSH DI
    PUSH DS
    PUSH ES
    PUSH CS
    POP DS
    JNZ NO_PREFIX
    OR SHIFT_STATE,8
KEY1B:
    JMP KEY1
KEY_BIOS1:
    JMP KEY_BIOS
NO_PREFIX:
        MOV DI,OFFSET KEY_MAP_RS
        MOV BL,CS:KEY_MODE
        DEC BL
        JZ MODE_FOUND
        MOV DI,OFFSET KEY_MAP_PC
MODE_FOUND:
    CMP AL,59H
    JNB KEY1B
    MOV BX,OFFSET SCAN_TABLE
    XLAT
    TEST SHIFT_STATE,8  ;Ignore artificial SHIFT or NUM LOCK pressed/
                        ;released caused by extended key macros
    JNZ NO_SHIFT_KEY
    MOV BL,1
    CMP AL,2AH          ;Left Shift key
    JZ SHIFT_KEY
    MOV BL,2
    CMP AL,36H          ;Right Shift key
    JNZ NO_SHIFT_KEY
SHIFT_KEY:
    OR SHIFT_STATE,BL
    TEST AH,128
    JZ NO_SHIFT_KEY
    NOT BL
    AND SHIFT_STATE,BL
NO_SHIFT_KEY:
    CMP AL,47H
    JB NO_NUM_KEYS
    PUSH ES
    MOV ES,SIXTYFOUR
    TEST BYTE PTR ES:[17H],32
    POP ES
    JZ NO_NUM_KEYS
    TEST SHIFT_STATE,8
    JNZ NO_NUM_KEYS
    ADD AL,13
NO_NUM_KEYS:
    MOV BL,AL
    MOV BH,0
    ADD BX,BX
    MOV AL,0                    ;This makes AL=1 if SHIFTs were pressed
    TEST SHIFT_STATE,3
    JZ SHIFT_NOT_PRESSED
    INC AL
SHIFT_NOT_PRESSED:
    MOV KEY_MATRIX[7],AL        ;Store proper state of SHIFT key
    TEST AH,128
    JNZ KEY2
    ADD BL,AL                   ;Align to binding appropriate for current
    MOV BL,[BX+DI]              ;SHIFT state
    TEST BL,8                   ;If bit 3=1, this binding is a dead key
    JNZ KEY1C
    MOV BH,AL
    MOV AL,1
    MOV CL,BL
    AND CL,7
    SHL AL,CL
    MOV CL,4
    ROR BL,CL
    MOV CL,BL
    AND CL,7
    TEST BL,8
    JZ NO_SHIFT_REVERSE
    XOR BH,1                    ;Reverse SHIFT key for this binding if needed
    MOV KEY_MATRIX[7],BH
NO_SHIFT_REVERSE:
    MOV BH,0
    MOV BL,CL
    OR KEY_MATRIX[BX],AL
    JMP KEY3
KEY1C:  JMP KEY1A
KEY2:   PUSH BX                 ;When releasing a key, make sure *both*
    MOV BL,[BX+DI]              ;unSHIFTed and SHIFTed bindings are canceled
    TEST BL,8                   ;If bit 3=1, this binding is a dead key
    JNZ KEY2A
    MOV BH,AL
    MOV AL,1
    MOV CL,BL
    AND CL,7
    SHL AL,CL
    MOV CL,4
    ROR BL,CL
    MOV CL,BL
    AND CL,7
    MOV BH,0
    MOV BL,CL
    NOT AL
    AND KEY_MATRIX[BX],AL
KEY2A:  POP BX
        XOR BL,1
        TEST BL,1
        JNZ KEY2
KEY3:
    MOV BX,3800H
    MOV ES,PSEUDORAM
KEY4:    
    MOV AX,100H
    MOV DI,OFFSET KEY_MATRIX
KEY5:
    TEST BL,AH
    JZ KEY6
    OR AL,[DI]
KEY6:
    INC DI
    ROL AH,1
    JNB KEY5
    MOV ES:[BX],AL
    MOV ES:[BX+100H],AL
    MOV ES:[BX+200H],AL
    MOV ES:[BX+300H],AL
    INC BL
    JNZ KEY4
KEY1A:  AND SHIFT_STATE,0F7H
KEY1:   
    IN AL,97
    OR AL,128
    OUT 97,AL
    AND AL,127
    OUT 97,AL
    MOV AL,32
    OUT 32,AL
    POP ES
    POP DS
    POP DI
    POP CX
    POP BX
    POP AX
    IRET

SIXTYFOUR DW 64

;This table contains bytes to translate the numeric keypad's "+", "-", and
;the F9-F12 keys to their positions within our table

SCAN_TABLE DB 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
        DB 10H,11H,12H,13H,14H,15H,16H,17H,18H,19H,1AH,1BH,1CH,1DH,1EH,1FH
        DB 20H,21H,22H,23H,24H,25H,26H,27H,28H,29H,2AH,2BH,2CH,2DH,2EH,2FH
        DB 30H,31H,32H,33H,34H,35H,36H,37H,38H,39H,3AH,3BH,3CH,3DH,3EH,3FH
        DB 40H,41H,41H,41H,42H,45H,46H,47H,48H,49H,3EH,4BH,4CH,4DH,40H,4FH
        DB 50H,51H,52H,53H,00H,00H,00H,43H,44H

KEY_MATRIX DB 8 DUP(?)

;Key map: bit 7 set=SHIFT reversed, bit 6-4=key row, bit 3 set=disabled
;         bit 2-0=key column
KEY_MAP_RS DB  8 , 8       ;Scancode 0 is undefined
        DB 62H,62H      ;ESC (BREAK)
        DB 41H,41H      ;1 !
        DB 42H,42H      ;2 @
        DB 43H,43H      ;3 #
        DB 44H,44H      ;4 $
        DB 45H,45H      ;5 %
        DB 46H,46H      ;6 ^
        DB 47H,47H      ;7 &
        DB 50H,50H      ;8 *
        DB 51H,51H      ;9 (
        DB 40H,40H      ;0 )
        DB 52H,52H      ;- _ (: *)
        DB 55H,55H      ;= + (- =)
        DB 65H,65H      ;BACKSPACE
        DB 63H,63H      ;TAB (UP ARROW)
        DB 21H,21H      ;Q
        DB 27H,27H      ;W
        DB 05H,05H      ;E
        DB 22H,22H      ;R
        DB 24H,24H      ;T
        DB 31H,31H      ;Y
        DB 25H,25H      ;U
        DB 11H,11H      ;I
        DB 17H,17H      ;O
        DB 20H,20H      ;P
        DB 65H,65H      ;[ (LEFT ARROW)
        DB 66H,66H      ;] (RIGHT ARROW)
        DB 60H,60H      ;ENTER
        DB 64H,64H      ;CTRL (DOWN ARROW)
        DB 01H,01H      ;A
        DB 23H,23H      ;S
        DB 04H,04H      ;D
        DB 06H,06H      ;F
        DB 07H,07H      ;G
        DB 10H,10H      ;H
        DB 12H,12H      ;J
        DB 13H,13H      ;K
        DB 14H,14H      ;L
        DB 53H,53H      ;; : (; +)
        DB 00H,00H      ;' " (@)
        DB  8 , 8       ;` ~
        DB  8 , 8       ;not used
        DB  8 , 8       ;\ |
        DB 32H,32H      ;Z
        DB 30H,30H      ;X
        DB 03H,03H      ;C
        DB 26H,26H      ;V
        DB 02H,02H      ;B
        DB 16H,16H      ;N
        DB 15H,15H      ;M
        DB 54H,54H      ;, <
        DB 56H,56H      ;. >
        DB 57H,57H      ;/ ?
        DB  8 , 8       ;not used
        DB  8 , 8       ;* PRINT SCREEN
        DB 61H,61H      ;ALT
        DB 67H,67H      ;SPACE
        DB 0C0H,40H     ;CAPS LOCK
        DB  8 , 8       ;not used
        DB  8 , 8       ;not used
        DB  8 , 8       ;not used
        DB 55H,0D5H     ;Keypad -
        DB  8 , 8       ;not used
        DB 0D3H,53H     ;Keypad +
        DB  8 , 8       ;F9
        DB  8 , 8       ;F10
        DB  8 , 8       ;F11
        DB 62H,62H      ;F12
        DB  8 , 8       ;not used
        DB 80H,00H      ;SCROLL LOCK
        DB 61H,61H      ;HOME (NUM LOCK off)
        DB 63H,63H      ;UP
        DB  8 , 8       ;PG UP
        DB  8 , 8       ;not used
        DB 65H,65H      ;LEFT
        DB  8 , 8       ;Keypad 5
        DB 66H,66H      ;RIGHT
        DB  8 , 8       ;not used
        DB  8 , 8       ;END
        DB 64H,64H      ;DOWN
        DB  8 , 8       ;PG DN
        DB  8 , 8       ;INS
        DB  8 , 8       ;DEL
        DB 47H,47H      ;Keypad 7 (NUM LOCK on)
        DB 50H,50H      ;Keypad 8
        DB 51H,51H      ;Keypad 9
        DB  8 , 8       ;not used
        DB 44H,44H      ;Keypad 4
        DB 45H,45H      ;Keypad 5
        DB 46H,46H      ;Keypad 6
        DB  8 , 8       ;not used
        DB 41H,41H      ;Keypad 1
        DB 42H,42H      ;Keypad 2
        DB 43H,43H      ;Keypad 3
        DB 40H,40H      ;Keypad 0
        DB 56H,0D6H     ;Keypad .

KEY_MAP_PC DB  8 , 8       ;Scancode 0 is undefined
        DB 62H,62H      ;ESC (BREAK)
        DB 41H,41H      ;1 !
        DB 42H,80H      ;2 @
        DB 43H,43H      ;3 #
        DB 44H,44H      ;4 $
        DB 45H,45H      ;5 %
        DB 46H,0B6H     ;6 ^
        DB 47H,46H      ;7 &
        DB 50H,52H      ;8 *
        DB 51H,50H      ;9 (
        DB 40H,51H      ;0 )
        DB 55H,0B7H     ;- _
        DB 0D5H,53H     ;= +
        DB 65H,65H      ;BACKSPACE
        DB 66H,66H      ;TAB
        DB 21H,21H      ;Q
        DB 27H,27H      ;W
        DB 05H,05H      ;E
        DB 22H,22H      ;R
        DB 24H,24H      ;T
        DB 31H,31H      ;Y
        DB 25H,25H      ;U
        DB 11H,11H      ;I
        DB 17H,17H      ;O
        DB 20H,20H      ;P
        DB 33H,33H      ;[
        DB 35H,35H      ;]
        DB 60H,60H      ;ENTER
        DB  8 , 8       ;CTRL
        DB 01H,01H      ;A
        DB 23H,23H      ;S
        DB 04H,04H      ;D
        DB 06H,06H      ;F
        DB 07H,07H      ;G
        DB 10H,10H      ;H
        DB 12H,12H      ;J
        DB 13H,13H      ;K
        DB 14H,14H      ;L
        DB 53H,0D2H     ;; :
        DB 0C7H,42H     ;' "
        DB 80H,36H      ;` ~
        DB  8 , 8       ;not used
        DB 34H,34H      ;\ |
        DB 32H,32H      ;Z
        DB 30H,30H      ;X
        DB 03H,03H      ;C
        DB 26H,26H      ;V
        DB 02H,02H      ;B
        DB 16H,16H      ;N
        DB 15H,15H      ;M
        DB 54H,54H      ;, <
        DB 56H,56H      ;. >
        DB 57H,57H      ;/ ?
        DB  8 , 8       ;not used
        DB 0D2H,8       ;* PRINT SCREEN
        DB 61H,61H      ;ALT
        DB 67H,67H      ;SPACE
        DB 0C0H,40H     ;CAPS LOCK
        DB  8 , 8       ;not used
        DB  8 , 8       ;not used
        DB  8 , 8       ;not used
        DB 55H,0D5H     ;Keypad -
        DB  8 , 8       ;not used
        DB 0D3H,53H     ;Keypad +
        DB  8 , 8       ;F9
        DB 62H,62H      ;F10
        DB  8 , 8       ;F11
        DB  8 , 8       ;F12
        DB  8 , 8       ;not used
        DB 80H,00H      ;SCROLL LOCK
        DB 61H,61H      ;HOME (NUM LOCK off)
        DB 63H,63H      ;UP
        DB  8 , 8       ;PG UP
        DB  8 , 8       ;not used
        DB 65H,65H      ;LEFT
        DB  8 , 8       ;Keypad 5
        DB 66H,66H      ;RIGHT
        DB  8 , 8       ;not used
        DB  8 , 8       ;END
        DB 64H,64H      ;DOWN
        DB  8 , 8       ;PG DN
        DB  8 , 8       ;INS
        DB  8 , 8       ;DEL
        DB 47H,47H      ;Keypad 7 (NUM LOCK on)
        DB 50H,50H      ;Keypad 8
        DB 51H,51H      ;Keypad 9
        DB  8 , 8       ;not used
        DB 44H,44H      ;Keypad 4
        DB 45H,45H      ;Keypad 5
        DB 46H,46H      ;Keypad 6
        DB  8 , 8       ;not used
        DB 41H,41H      ;Keypad 1
        DB 42H,42H      ;Keypad 2
        DB 43H,43H      ;Keypad 3
        DB 40H,40H      ;Keypad 0
        DB 56H,0D6H     ;Keypad .

clock:         ;Clock interrupt.  Will change the MAIN interpreter's JMP
    push ax    ;loop to BRANCH5 each time TIMER reaches the value CYCLES.
    MOV AL,CS:CYCLES
    AND AL,127
    JZ NO_CLOCK
    cmp AL,2
    jnz no_accel
    mov al,36h          ;Execute only if accelerated clock requested by SETUP
    out 43h,al
    mov al,7ah
    out 40h,al
    mov al,74h
    out 40h,al
no_accel:
    mov al,cs:timer
    cmp al,128
    jnb NO_CLOCK
    mov ah,cs:branch
    mov cs:old_branch,ah
    mov ah,offset branch5-offset branch1
    mov cs:branch,ah
    mov cs:timer,128            ;Set flags indicating clock request
    or byte ptr cs:sysstat,2
    or byte ptr cs:intdma,128   ;Also sets the clock interrupt bit at 37E0h
NO_CLOCK:
    pop ax
    db 0eah                     ;Far JMP to original INT 8 handler
oldcl dw 0
oldch dw 0

MOUSE_SCAN:                     ;Set branch if right mouse button pressed
        PUSH AX
        PUSH ES
        MOV AX,0
        MOV ES,AX
        MOV AX,CS
        CMP AX,ES:[26H]
        JNZ NO_MOUSE_SCAN       ;If keyboard scan disabled, don't scan mouse
        MOV AL,OFFSET BRANCH7-OFFSET BRANCH1
        MOV BYTE PTR CS:BRANCH,AL
        MOV BYTE PTR CS:OLD_BRANCH,AL
        OR BYTE PTR CS:SYSSTAT,64
        MOV BYTE PTR CS:TIMER,0
NO_MOUSE_SCAN:
        POP ES
        POP AX
        RETF

;Miscellaneous support subroutines

;Display a message in DI in upper lefthand corner of screen

NOTE    PROC NEAR
        PUSH AX
        PUSH BX
        PUSH CX
        PUSH DX
        PUSH DS
        MOV AX,CS
        MOV DS,AX
        MOV MARGIN,-1
        MOV AH,2
        MOV BH,0
        MOV DX,0
        INT 10H
        MOV CX,8
NOTE1:  MOV AL,[DI]
        INC DI
        MOV AH,14
        MOV BL,1
        INT 10H
        LOOP NOTE1
        MOV AH,2
        MOV DX,100H
        INT 10H
        MOV CX,8
NOTE2:  MOV AL,[DI]
        INC DI
        MOV AH,14
        MOV BL,1
        INT 10H
        LOOP NOTE2
        POP DS
        POP DX
        POP CX
        POP BX
        POP AX
        RET
NOTE    ENDP

fixclock proc near      ;Correct clock for acceleration if 25ms heartbeat
    cmp cycles,2        ;selected by re-copying from real time clock
    jz fixclock0
    ret
fixclock0:    
    mov ah,2
    int 1ah             ;Read real time clock
    bcd_to_bin ch
    bcd_to_bin cl
    bcd_to_bin dh
    mov dl,0
    mov ah,2dh
    int 21h
    mov ah,4
    int 1ah             ;Read date
    bcd_to_bin cl
    bcd_to_bin dh
    bcd_to_bin dl
    cmp ch,20h
    jnz fixclock1
    add cl,100
fixclock1:
    mov ch,0
    add cx,1900
    mov ah,2bh
    int 21h
    ret
fixclock endp

slider proc near        ;Display speed slider in Vir. Cas. menu
    mov dx,312h
    mov ah,2
    MOV BH,0
    int 10h
    mov cx,delay
    shr cx,1
    shr cx,1
    neg cx
    add cx,32
    mov ah,9
    mov al,219
    mov bx,7
    cmp cx,0
    jz minimum
    int 10h
minimum:    
    add dl,cl
    mov ah,2
    INT 10H
    mov cx,delay
    shr cx,1
    shr cx,1
    mov al,177
    mov ah,9
    cmp cx,0
    jz maximum
    int 10h
maximum:    
    ret
slider endp

EXPAND  PROC NEAR          ;Expand character set read from MODEL1.FNT for use
    MOV SI,0               ;in 32-column mode
EXPAND1:
    MOV AX,WORD PTR [SI+offset charset]
    MOV CX,16
EXPAND2: 
    CMP AH,128
    CMC
    RCL DX,1
    RCL BX,1
    SHL AX,1
    RCL DX,1
    RCL BX,1
    LOOP EXPAND2
    PUSH SI
    ADD SI,SI
    MOV WORD PTR [SI+offset wideset],DX
    MOV WORD PTR [SI+2+offset wideset],BX
    POP SI
    INC SI
    INC SI
    CMP SI,3072
    JB EXPAND1
    MOV SI,OFFSET VIDPOS
    MOV AX,168
    MOV CX,64
EXPAND3:
    MOV [SI],AX    
    ADD SI,2
    INC AX
    LOOP EXPAND3
    MOV CX,64
    ADD AX,480-64
    CMP SI,OFFSET VIDPOS+2048
    JB EXPAND3
    RET
EXPAND ENDP

OPEN    PROC NEAR       ;Re-open file if more than 5 seconds since
    PUSH ES             ;last access.  Used for virtual disk access.
    MOV AX,64
    MOV ES,AX
    MOV AX,ES:[6CH]
    POP ES
    MOV BX,LASTDSK
    MOV LASTDSK,AX
    SUB AX,BX
    CMP AX,91
    JB OPEN1
    MOV BX,HANDLE
    MOV AH,3EH
    INT 21H
    MOV AX,3D02H
    MOV DX,OFFSET DRVSEL
    INT 21H
    MOV HANDLE,AX
    JNB OPEN1
    MOV HANDLE,-1
OPEN1:  RET
OPEN    ENDP

GFDC    PROC NEAR       ;Read from virtual Floppy Disk Controller DMA
    SUB DI,13
    JNZ GFDC1
    MOV AL,TRACK
    RET
GFDC1:  DEC DI
    JNZ GFDC2
    MOV AL,SECTOR
    RET
GFDC2:  DEC DI
    JNZ GFDC5
    TEST BYTE PTR SYSSTAT,8
    JNZ GFDC3
    MOV AL,FDCDATA
    RET
GFDC3:  MOV BL,SECOFF
    MOV BH,SECMSB
    MOV AL,byte ptr DTA[BX]
    INC BL
    MOV SECOFF,BL
    JNZ GFDC4
GFDC3A: 
;    AND BYTE PTR SYSSTAT,247
    AND BYTE PTR STATUS,253
    mov idxhole,5
    CMP HANDLE,-1
    JNZ GFDC4
    MOV STATUS,30h
GFDC4:  RET
GFDC5:  
    MOV AL,STATUS
    TEST BYTE PTR SYSSTAT,12
    JNZ GFDC6A
    or al,wrprot
    cmp byte ptr drvsel,'.'
    jz gfdc6
    INC IDXHOLE
    CMP BYTE PTR IDXHOLE,8
    jnz GFDC6
    or al,2
    mov idxhole,0
GFDC6:  
    RET
gfdc6a:
    test byte ptr status,2
    jnz gfdc6
    dec idxhole
    jnz gfdc6b
    and byte ptr sysstat,247
gfdc6b:
    cmp byte ptr idxhole,3
    jnb gfdc6
    and byte ptr status,254
    ret
GFDC    ENDP

PFDC    PROC NEAR       ;Write to virtual Floppy Disk Controller DMA
    SUB DI,13
    JNZ PFDC1
    MOV TRACK,AL
    RET
PFDC1:  DEC DI
    JNZ PFDC2
    MOV SECTOR,AL
    RET
PFDC2:  DEC DI
    JZ PFDC3A
    JMP PFDC3
PFDC3A: MOV FDCDATA,AL
    mov bx,handle
    inc bx
    jnz diskready
    mov status,80h
    ret
diskready:
    TEST BYTE PTR SYSSTAT,4
    JZ PFDC2B
    MOV BL,SECOFF
    MOV BH,SECMSB
    DEC BH
    AND BH,1
    MOV byte ptr DTA[BX],AL
    INC BL
    MOV SECOFF,BL
    JNZ PFDC2B
    DEC SECMSB
    JNZ PFDC2B
    AND BYTE PTR SYSSTAT,251
    MOV IDXHOLE,0
    MOV DX,OFFSET DTA
    MOV AH,40H
    MOV CX,256
    MOV BX,HANDLE
    test byte ptr wrprot,40h
    mov status,40h
    jnz no_write
    MOV STATUS,0
    INT 21H
no_write:    
    JNB PFDC2A
    MOV STATUS,10H
PFDC2B: RET
PFDC2A: MOV AH,3FH
    MOV CX,512
    MOV DX,OFFSET DTA
    MOV AH,3FH
    MOV BX,HANDLE
    INT 21H
    RET
PFDC3:  AND BYTE PTR SYSSTAT,243
    TEST AL,128
    JNZ PFDC8
    CMP AL,16
    JNB PFDC4
    MOV TRACK,0
    MOV BYTE PTR STATUS,24H
    RET
PFDC4:  CMP AL,32
    JNB PFDC6
    MOV AL,FDCDATA
    MOV TRACK,AL
PFDC4A: CMP AL,80
    JB PFDC5
    MOV BYTE PTR STATUS,30H
    RET
PFDC5:  MOV BYTE PTR STATUS,20H
    CMP AL,1
    MOV AL,0
    RCL AL,1
    ROL AL,1
    ROL AL,1
    OR BYTE PTR STATUS,AL
    RET
PFDC6:  CMP AL,96
    JNB PFDC7
    INC TRACK
    MOV AL,TRACK
    JMP PFDC4A
PFDC7:  DEC TRACK
    MOV AL,TRACK
    JMP PFDC4A
PFDC8:  CMP AL,160
    JB PFDC8A
    JMP PFDC9
PFDC8A: 
    CALL OPEN
    MOV BX,HANDLE
    MOV AL,TRACK
    MOV DL,10
    MUL DL
    PUSH AX
    MOV AH,0
    MOV AL,SECTOR
    DIV DL
    MOV DL,AH
    POP AX
    MOV DH,0
    ADD AX,DX
    MOV DL,DH
    MOV CH,DH
    MOV DH,AL
    MOV CL,AH
    MOV AX,4200H
    INT 21H
    MOV AH,3FH
    MOV DX,OFFSET DTA
    MOV CX,256
    INT 21H
PFDC8B: OR BYTE PTR SYSSTAT,8
    MOV SECOFF,0
    MOV SECMSB,0
    MOV BYTE PTR STATUS,3
    CMP BYTE PTR DS:TRACK,17
    JNZ RDERR
    MOV BYTE PTR STATUS,35
RDERR:  RET
PFDC9:  CMP AL,192
    JNB PFDC10
    OR BYTE PTR SYSSTAT,4
    MOV SECMSB,1
    MOV SECOFF,0
    MOV BYTE PTR STATUS,3
    MOV BX,HANDLE
    MOV AL,TRACK
    MOV DL,10
    MUL DL
    PUSH AX
    MOV AH,0
    MOV AL,SECTOR
    DIV DL
    MOV DL,AH
    POP AX
    MOV DH,0
    ADD AX,DX
    MOV DL,DH
    MOV CH,DH
    MOV DH,AL
    MOV CL,AH
    MOV AX,4200H
    INT 21H
    RET
PFDC10: CMP AL,254
    JNB PFDC10A
    CMP AL,240
    JNB PFDC11
    MOV BYTE PTR STATUS,10H
    RET
PFDC10A: 
    MOV BYTE PTR STATUS,0
    RET
PFDC11: MOV AL,TRACK
    CMP AL,0
    JNZ PFDC12
    MOV BX,HANDLE
    MOV AH,3EH
    INT 21H
    MOV HANDLE,-1
    MOV DX,OFFSET DRVSEL
    MOV AH,3CH
    MOV CX,0
    test byte ptr wrprot,40h
    jnz PFDC12
    INT 21H
    JB PFDC12
    MOV HANDLE,AX
PFDC12: MOV BYTE PTR STATUS,3
    OR BYTE PTR SYSSTAT,4
    MOV SECMSB,12
    MOV SECOFF,0
    MOV SECTOR,9
    RET
PFDC    ENDP

PDRIVE  PROC NEAR               ;Virtual drive selection (37E0h WRITE)
    OR AL,AL
    JNZ PDRIVE1A
    MOV STATUS,128
    RET
PDRIVE1A:
    and al,15
    push ax             ;Check write protect flag
    push cx
    mov cl,4
    rol al,cl
    test al,switches    
    mov wrprot,0
    jz pdrive1b
    mov wrprot,40h
pdrive1b:
    pop cx
    pop ax
    CMP AL,CS:SIDE
    PUSHF
    MOV CS:SIDE,AL
    PUSH BX
    PUSH SI
    MOV SI,OFFSET DRVSEL
    MOV BX,-8
PDRIVE1: ADD BX,8
    ROR AL,1
    JNC PDRIVE1
    MOV AL,8
PDRIVE2: MOV AH,CS:DRIVES[BX]
    CMP AH,' '
    JZ PDRIVE3
    MOV CS:[SI],AH
    INC BX
    INC SI
    DEC AL
    JNZ PDRIVE2
PDRIVE3: MOV WORD PTR CS:[SI],442EH ;Add ".DSK" extension
    MOV WORD PTR CS:[SI+2],4B53H
    MOV BYTE PTR CS:[SI+4],0
    POP SI
    POP BX
    POPF
    JZ PDRIVE4
    MOV BX,HANDLE
    MOV AH,3EH
    INT 21H
    MOV AX,3D02H
    MOV DX,OFFSET DRVSEL
    INT 21H
    MOV HANDLE,AX
    JNB PDRIVE4
    MOV HANDLE,-1
PDRIVE4:    
    MOV BYTE PTR STATUS,20H
    TEST BYTE PTR DS:TRACK,-1
    JNZ PDRIVE5
    OR BYTE PTR STATUS,4
PDRIVE5:    RET
PDRIVE  ENDP

GDRIVE  PROC NEAR              ;Get interrupt status byte (37E0h READ)
    MOV AL,intdma
    test byte ptr sysstat,16
    jnz gdrive1
    and byte ptr timer,127
    and byte ptr intdma,3fh
gdrive1:
    RET
GDRIVE  ENDP

GPRINT  PROC NEAR   ;Read printer status (37E8h READ)
    PUSH DX
    PUSH AX
    MOV AH,2
    MOV DX,0
    INT 17H
    ROL AH,1
    PUSHF
    ROL AH,1
    POPF
    RCR AH,1
    XOR AH,90H
    OR AH,15
    MOV DH,AH
    POP AX
    MOV AL,DH
    POP DX
    RET
GPRINT  ENDP

PPRINT  PROC NEAR   ;Output to printer (37E8h WRITE)
    PUSH DX
    PUSH AX
    MOV AH,2
    MOV DX,0
    INT 17H
    XOR AH,90H
    JNZ PPRINT1
    POP AX
    PUSH AX
    MOV AH,0
    MOV DX,0
    INT 17H
    test byte ptr switches,4    ;Add LF to CR if requested
    jz pprint1                  
    pop ax
    cmp al,13
    push ax
    jnz pprint1
    mov ax,10
    int 17h
PPRINT1:    POP AX
    POP DX
    RET
PPRINT  ENDP

FIXZERO PROC NEAR       ;Copy only Z flag of 8086 to Z-80 flags
    JZ FIXZERO1
    AND BYTE PTR REGF,191
    RET
FIXZERO1: OR BYTE PTR REGF,64
    RET
FIXZERO ENDP

HILITE  PROC NEAR   ;Highlight option in debugger menu
    MOV DH,LASTOPT
    OR DH,DH
    JZ HILITE1
    MOV DL,73
    MOV BH,0
    MOV AH,2
    INT 10H
    MOV CX,6
    MOV BL,129
    MOV AX,09DBH
    INT 10H
HILITE1:    RET
HILITE  ENDP

NULL_MOUSE DB -1

ADDRESS PROC NEAR   ;Get hex address from keyboard
    MOV SI,AX
    MOV DX,0D49H
    MOV BH,0
    MOV AH,2
    INT 10H
    MOV BL,1
    MOV AX,0E3FH
    INT 10H
ADDR1:  MOV AX,SI
    MOV DX,0D4BH
    CALL HEX
    PUSH BP
    MOV BP,OFFSET NULL_MOUSE
    PUSH SI
    CALL KEYMOUSE
    POP SI
    POP BP
    CMP AL,0
    JNZ ADDR6
    TEST BYTE PTR  SYSSTAT,32
    JZ ADDR6
    AND BYTE PTR SYSSTAT,223
    CMP AL,27
    RET
ADDR6:  CMP AL,'a'
    JB ADDR5
    SUB AL,32
ADDR5:  CMP AL,27
    JZ ADDR2
    CMP AL,13
    JZ ADDR3
    SUB AL,'0'
    CMP AL,10
    JB ADDR4
    SUB AL,7
    CMP AL,10
    JB ADDR1
    CMP AL,16
    JNB ADDR1
ADDR4:  MOV CL,4
    ROL SI,CL
    AND AX,15
    AND SI,0FFF0H
    OR SI,AX
    JMP ADDR1
ADDR3:  CMP AL,27
ADDR2:  PUSHF
    MOV DX,0D49H
    MOV BH,0
    MOV AH,2
    INT 10H
    MOV CX,6
    MOV AX,0A20H
    MOV BL,1
    INT 10H
    POPF
    MOV AX,SI
    CLC
    RET
ADDRESS ENDP

COL PROC NEAR       ;Display column for debugger
    MOV CX,25
COL1:   MOV DH,8
COL2:   PUSH DX
    ADD DL,8
    SUB DL,DH
    MOV DH,25
    SUB DH,CL
    MOV AH,2
    MOV BH,0
    INT 10H
    POP DX
    MOV AH,9
    PUSH CX
    MOV CX,1
    MOV AL,[DI]
    MOV BX,CX
    INT 10H
    POP CX
    INC DI
    DEC DH
    JNZ COL2
    LOOP COL1
    RET
COL ENDP

HEX PROC NEAR           ;Display 4-digit HEX number in AX at video location DX
    PUSH BX
    PUSH AX
    MOV BH,0
    MOV AH,2
    INT 10H
    POP AX
    PUSH CX
    MOV CX,4
HEX1:   PUSH CX
    MOV CL,4
    ROL AX,CL
    POP CX
    PUSH AX
    AND AX,15
    ADD AL,48
    CMP AL,58
    JB HEX2
    ADD AL,7
HEX2:   MOV AH,14
    MOV BX,1
    INT 10H
    POP AX
    LOOP HEX1
    POP CX
    POP BX
    RET
HEX ENDP

MAINREG PROC NEAR   ;Display main register contents in debugger
    MOV DX,402H
    MOV DI,OFFSET REGC
    MOV CX,8
MAINREG1:   MOV AX,[DI]
    ADD DI,2
    CALL HEX
    ADD DH,2
    LOOP MAINREG1
    MOV AX,BP
    CALL HEX
    MOV DI,BP
    CALL GETWORD
    XCHG AH,AL
    MOV DX,1602H
    CALL HEX
    MOV DI,BP
    ADD DI,2
    CALL GETWORD
    XCHG AH,AL
    MOV DX,1702H
    CALL HEX
    RET
MAINREG ENDP

PRIMEREG    PROC NEAR   ;Display auxilary register contents
    MOV DX,114AH
    MOV CX,4
    MOV DI,OFFSET BCPRIME
PRIMEREG1:  MOV AX,[DI]
    ADD DI,2
    CALL HEX
    ADD DH,2
    LOOP PRIMEREG1
    RET
PRIMEREG    ENDP

MEMMAP  PROC NEAR   ;Display memory page
    MOV DI,MEMPAGE
    MOV SI,DI
    SUB SI,1111H
    MOV DH,1
MEMMAP1:    MOV BX,1
    MOV AH,2
    MOV DL,1
    INT 10H
    PUSH DI
    AND DI,0FFF0H
    CMP DI,SI
    POP DI
    JZ MEMMAP2
    MOV SI,DI
    AND SI,0FFF0H
    MOV AX,0E5BH
    INT 10H
    MOV AX,SI
    MOV DL,3
MEMMAP6:    MOV CL,4
    ROL AX,CL
    PUSH AX
    AND AL,15
    ADD AL,48
    CMP AL,58
    JB MEMMAP7
    ADD AL,7
MEMMAP7:    MOV AH,14
    INT 10H
    POP AX
    DEC DL
    JNZ MEMMAP6
    MOV AX,0E78H
    INT 10H
    MOV AL,']'
    INT 10H
    JMP MEMMAP4
MEMMAP2:    MOV AX,DI
    AND AL,15
    ADD AL,'0'
    CMP AL,'9'
    JNA MEMMAP3
    ADD AL,7
MEMMAP3:    MOV AH,14
    INT 10H
    MOV AL,':'
    INT 10H
    PUSH SI
    PUSH DI
    PUSH DX
    CALL GETWORD
    POP DX
    PUSH DX
    MOV DL,3
    XCHG AH,AL
    CALL HEX
    POP DX
    POP DI
    POP SI
    ADD DI,2
MEMMAP4:    INC DH
    CMP DH,24
    JNB MEMMAP5
    JMP MEMMAP1
MEMMAP5:    RET
MEMMAP  ENDP

FIXSIGN PROC NEAR   ;Z-80 sign flag is not in same bit position as 8086
    PUSH AX         ;flag.  Make adjustment.
    PUSHF
    LAHF
    rol ah,1
    rol al,1
    ror ax,1
    POPF
    SAHF
    POP AX
    RET
FIXSIGN ENDP

PORTOUT PROC NEAR               ;Port output
    CMP DL,255
    JNZ PORTOUT1
    CALL CASS
PORTOUT1:
        PUSH ES                 ;Ensure that the mouse hasn't overriden
        PUSH BX                 ;the selected comm port
        PUSH AX
        MOV AX,0
        MOV ES,AX
        MOV BX,32H
        MOV AL,SWITCHES
        AND AL,1
        SHL AL,1
        SHL AL,1
        SUB BL,AL               ;COM1: check 0:32, COM1: check 0:2E
        MOV AX,ES:[BX]
        MOV BX,CS
        CMP AX,BX
        POP AX
        POP BX
        POP ES
        JZ PORTOUT2
        RET                     ;If IRQ is no longer attached, RS-232 disabled
PORTOUT2:
        CMP DL,0E9H             ;Modem emulation
    JNZ PORTOUT3
    PUSH AX
    PUSH DX
    AND BYTE PTR MDMSET,31
    AND ax,15
    push bx
    add ax,ax
    mov bx,ax
    mov ax,baud[bx]
    mov baudset,ax
    pop bx
    MOV AL,MDMSET
    mov dx,comstat
    sub dx,2
    or al,128
    out dx,al
    sub dx,3
    mov ax,baudset
    out dx,al
    inc dx
    mov al,ah
    out dx,al
    add dx,2
    mov al,mdmset
    and al,31
    out dx,al
    POP DX
    POP AX
    RET
PORTOUT3:   CMP DL,0EAH
    JNZ PORTOUT4
    PUSH AX
    MOV AH,0
    TEST AL,16
    JZ PORTOUT3A
    OR AH,4
PORTOUT3A:  TEST AL,8
    JNZ PORTOUT3B
    OR AH,16
PORTOUT3B:  TEST AL,128
    JZ PORTOUT3C
    OR AH,8
PORTOUT3C:  ROL AL,1
    ROL AL,1
    ROL AL,1
    AND AL,3
    PUSH BX
    MOV BL,AL
    ROR BL,1
    AND BL,1
    OR AH,BL
    MOV BL,AL
    ROL BL,1
    AND BL,2
    OR AH,BL
    POP BX
    PUSH DX
    mov mdmset,ah
    mov dx,comstat
    sub dx,2
    mov al,ah
    out dx,al
    pop dx
    pop ax
    ret
PORTOUT4:   CMP DL,0EBH
    JNZ PORTOUT5
    PUSH AX
    PUSH DX
    mov dx,comstat
    sub dx,5
    out dx,al
    POP DX
    POP AX
PORTOUT5:   RET
PORTOUT ENDP

CAS_CLOCK_CYCLE DB 0    ;-1 if in cassette clock cycle, 0 if in bit cycle
PORTIN  PROC NEAR       ;Port input
    CMP DL,255
    MOV AL,255
    JNZ PORTIN1
    MOV AL,127
    MOV AH,CASSTAT      ;Bit 6 of cassette port input indicates 32/64 col mode
    AND AH,8
    MOV CL,3
    SHL AH,CL
    XOR AL,AH
    CMP CHANDLE,-1      ;If a virtual cassette open
    JZ PORTIN1
    CMP BYTE PTR CAS_PLAYREC,'P'
    JNZ PORTIN1         ;and in playback mode
    NOT CAS_CLOCK_CYCLE
    CMP CAS_CLOCK_CYCLE,-1
    JZ CAS_IN_PULSE     ;If in clock cycle, generate pulse
    DEC CAS_BIT_COUNT
    JNZ BYTE_NOT_DONE
    PUSH AX             ;If all bits done in current byte, get a new one
    PUSH BX
    PUSH CX
    PUSH DX
    MOV AH,3FH
    MOV BX,CHANDLE
    MOV CX,1
    MOV DX,OFFSET CAS_BYTE
    INT 21H
    POP DX
    POP CX
    POP BX
    POP AX
    MOV CAS_BIT_COUNT,8
BYTE_NOT_DONE:          ;Test bit
    SHL CAS_BYTE,1
    JNB PORTIN1         ;if 0, then no pulse detected
CAS_IN_PULSE:
    OR AL,128           ;If 1 bit, or clock pulse, indicate pulse detected
PORTIN1:    CMP DL,0E8H
    JB PORTIN2
    CMP DL,0ECH
    JB PORTIN3
PORTIN2:    RET
PORTIN3:    CMP DL,0E8H
    JNZ PORTIN4
    PUSH DX
    MOV DX,comstat
    inc dx
    in al,dx
    MOV AH,AL
    AND AH,192
    ROL AL,1
    ROL AL,1
    ROL AL,1
    RCR AH,1
    ROL AL,1
    RCR AH,1
    OR AH,2
    MOV AL,AH
    POP DX
    NOT AL
    RET
PORTIN4:    CMP DL,0E9H
    JNZ PORTIN5
    MOV AL,109
    RET
PORTIN5:    CMP DL,0EAH
    JNZ PORTIN6
    PUSH DX
    mov dx,comstat
    in al,dx
    mov ah,al
    mov dx,mdmbufptr
    cmp dx,mdmlast
    jz mdmbuf
    or ah,1
mdmbuf:
    POP DX
    MOV AL,0
    TEST AH,1
    JZ PORTIN5A
    OR AL,128
PORTIN5A:   TEST AH,32
    JZ PORTIN5B
    OR AL,64
PORTIN5B:   TEST AH,2
    JZ PORTIN5C
    OR AL,32
PORTIN5C:   ROL AH,1
    AND AH,24
    OR AL,AH
    RET
PORTIN6:    PUSH DX
    push bx
    mov bx,mdmlast
    cmp bx,mdmbufptr
    jz mdmbuf1
    mov al,byte ptr cache[bx]
    inc bx
    and bx,1023
    mov mdmlast,bx
    pop bx
    pop dx
    ret
mdmbuf1:
    pop bx
    MOV AL,0
PORTIN7:    POP DX
    RET
PORTIN  ENDP

PUTFLAGV PROC NEAR   ;Transfer 8086 flags to Z-80 flags with overflow
    LAHF
    JO PUTFLAGV1
    AND AH,0D1H
    MOV REGF,AH
    RET
PUTFLAGV1:  OR AH,4
    AND AH,0D5H
    MOV REGF,AH
    RET
PUTFLAGV ENDP

GETPTR:             ;Return contents of HL, IX+n, IY+n as appropriate
    MOV DI,WORD PTR REGL
GETPTR1: RET            ;Change to NOP if index register selected
    MOV al,es:[bp]
    INC BP
    CBW
    MOV DI,INDEXREG
    MOV DI,[DI]
    ADD DI,AX
    RET

GETC    PROC NEAR   ;Return Z if flag true, NZ if flag false
    mov si,dx
    shr si,1
    shr si,1
    and si,14
    mov ah,regf
    mov al,ah
    not al
    and ax,flagtest[si]
    ret
getc    endp

flag_NZ equ 4000h
flag_Z  equ 0040h
flag_NC equ 0100h
flag_C  equ 0001h
flag_PO equ 0400h
flag_PE equ 0004h
flag_P  equ 8000h
flag_M  equ 0080h

flagtest dw flag_NZ,flag_Z,flag_NC,flag_C,flag_PO,flag_PE,flag_P,flag_M

GETBYTE PROC NEAR    ;Read a byte from memory with checks for protected areas
    CMP DI,37E0H
    JB GETBYTE1
    CMP DI,3800H
    JB GETBYTE8
GETBYTE1:   MOV AL,ES:[DI]   ;DMA area read (37E0h-37FFh)
    RET
GETBYTE8:   PUSH DI
    AND DI,15
    CMP DI,4
    JNB GETBYTE7
    CALL GDRIVE
    POP DI
    RET
GETBYTE7:   CMP DI,8
    JNB GETBYTE5
    POP DI
    MOV AL,255
    RET
GETBYTE5:   CMP DI,12
    JNB GETBYTE6
    CALL GPRINT
    POP DI
    RET
GETBYTE6:   CALL GFDC
    POP DI
    RET
GETBYTE ENDP
GETWORD PROC NEAR    ;Get word from TRS-80 memory address DI
    INC DI
    CALL GETBYTE
    DEC DI
    MOV AH,AL
    CALL GETBYTE
    RET
GETWORD ENDP
PUTBYTE PROC NEAR    ;TRS-80 memory write with checks for protected areas
    CMP DI,3C00H     ;Below 3C00h is DMA or read-only
    JB PUTBYTE2
    MOV ES:[DI],AL
    CMP DI,4000H     ;3C00h-3FFFh is video
    JNB PUTBYTE1
    PUSH AX
    PUSH DI
    CALL VIDEO
    POP DI
    POP AX
PUTBYTE1:   RET
PUTBYTE2:   CMP DI,3800H   ;Keyboard read-only 3800h-3BFFh
    JNB PUTBYTE1
    CMP DI,37E0H           ;Below 37E0h is ROM or empty
    JB PUTBYTE1
    PUSH DI
    PUSH AX
    AND DI,15
    CMP DI,4
    JNB PUTBYTE3
    CALL PDRIVE         ;37E0h-37E3h is drive select
    POP AX
    POP DI
    RET
PUTBYTE3:   CMP DI,8    ;37E4h-37E7h is cassette port select: useless option
    JNB PUTBYTE4
    POP AX
    POP DI
    RET
PUTBYTE4:   CMP DI,12
    JNB PUTBYTE5
    CALL PPRINT         ;37E8h-37EBh is printer
    POP AX
    POP DI
    RET
PUTBYTE5:   CALL PFDC   ;37ECh-37EFh is Floppy Disk Controller
    POP AX
    POP DI
    RET
PUTBYTE ENDP

PUTWORD PROC NEAR       ;Write word instead of byte
    CALL PUTBYTE
    INC DI
    MOV AL,AH
    CALL PUTBYTE
    DEC DI
    RET
PUTWORD ENDP

CAS_BYTE DB 0           ;Byte to write to virtual cassette
CAS_BIT_COUNT DB 1      ;Number of bits remaining in current byte

CASSETTE_OPEN PROC NEAR
        CMP CHANDLE,-1
        JNZ CAS_OPEN1
        MOV AX,3D02H
        MOV DX,OFFSET CAS_NAME
        INT 21H
        MOV CHANDLE,AX
        JNB CAS_OPEN1
        MOV CHANDLE,-1
CAS_OPEN1:
        RET
CASSETTE_OPEN ENDP

CASSETTE_CLOSE PROC NEAR
        CALL CASSETTE_CLIP
        MOV BX,CHANDLE
        MOV AH,3EH
        INT 21H
        MOV CHANDLE,-1
        RET
CASSETTE_CLOSE ENDP

CAS_WRITE DB 0

;Since the *next* clock bit says a byte is done, the last byte would be lost
;This routine checks for this at the appropriate times
CASSETTE_CLIP PROC NEAR
        CMP BYTE PTR CAS_PLAYREC,'R'
        JNZ CAS_CLIP1   ;If recording...
        CMP CAS_WRITE,-1;and a byte last written...
        JNZ CAS_CLIP1
        MOV CL,CAS_BIT_COUNT
        DEC CL          ;Make sure no partial bytes remaining
        ROL CAS_BYTE,CL ;Align the bit field
        MOV AH,40H      ;and output it
        MOV BX,CHANDLE
        MOV CX,1
        MOV DX,OFFSET CAS_BYTE
        INT 21H
CAS_CLIP1:
        MOV CAS_WRITE,0 ;Reset straggler flag
        RET
CASSETTE_CLIP ENDP

CASS    PROC NEAR       ;Cassette port output: screen mode switching,
    MOV AH,CASSTAT      ;sound would go here.  OUT 255 value stored in AL
    MOV CASSTAT,AL
    XOR AH,AL
    TEST AH,8           ;Check for 32/64-column toggle
    JZ CASS1
    call colchg
CASS1:  
    test ah,3
    jz quietA
    PUSH AX             ;Check for the low part of the cycle
    PUSH BX
    AND AL,3
    CMP AL,2
    JNZ NO_CAS_OUT
    CMP CHANDLE,-1      ;If no virtual cassette open, don't do anything
    JZ NO_CAS_OUT
    MOV BX,REGSP
    CMP WORD PTR ES:[BX+2],26EH  ;If 026EH was the calling routine, it's a clock cycle
    JZ CAS_CLOCK
    CMP WORD PTR ES:[BX+2],0FB0H ;If 0FB0H, then it's a Level I clock cycle
    JZ CAS_CLOCK
    CMP WORD PTR ES:[BX+2],276H  ;If 0276H was the calling routine, it's a 1 bit
    JZ CAS_1BIT
    CMP WORD PTR ES:[BX+2],0FB7H ;If 0FB7H, then it's a Level I 1-bit
    JNZ NO_CAS_OUT
CAS_1BIT:
    OR CAS_BYTE,1
    JMP NO_CAS_OUT
CAS_CLOCK:
    MOV CAS_WRITE,-1    ;Set flag indicating bytes being constructed
    DEC CAS_BIT_COUNT   ;Clock cycle indicates new bit
    JNZ CAS_CLOCK1
    MOV CAS_BIT_COUNT,8
    CMP BYTE PTR CAS_PLAYREC,'R'        ;Save only if in record mode
    JNZ CAS_CLOCK1
    PUSH CX             ;If 8 bits, a byte is ready to be written
    PUSH DX
    MOV AH,40H
    MOV BX,CHANDLE
    MOV CX,1
    MOV DX,OFFSET CAS_BYTE
    INT 21H
    POP DX
    POP CX
CAS_CLOCK1:
    SHL CAS_BYTE,1      ;Shift bit fields for next bit (lowest bit defaults 0)
NO_CAS_OUT:
    POP BX
    POP AX
sound:
QUIETA:
quiet:
    ret
CASS    ENDP

COLCHG  PROC NEAR       ;Toggle between 32 and 64 column mode
    PUSH AX
    PUSH CX
    PUSH SI
    PUSH ES
    PUSH DS
    MOV SI,0
    MOV ES,CS:VIDWIDE
    MOV DS,CS:VIDPAGE
    MOV CS:VIDPAGE,ES
    MOV CS:VIDWIDE,DS
    MOV CH,100
CASS3:  MOV CL,32
    ADD SI,8
CASS2:  MOV AX,ES:[SI]
    XCHG AX,[SI]
    MOV ES:[SI],AX
    MOV AX,ES:[SI+2000H]
    XCHG AX,[SI+2000H]
    MOV ES:[SI+2000H],AX
    INC SI
    INC SI
    DEC CL
    JNZ CASS2
    ADD SI,8
    DEC CH
    JNZ CASS3
    POP DS
    POP ES
    POP SI
    POP CX
    POP AX
    RET
COLCHG  ENDP

VIDEO   PROC NEAR       ;Character generator
    ADD DI,DI
    MOV SI,[DI+OFFSET VIDPOS-7800H]
    MOV BL,12
    MUL BL
    MOV BX,AX
    MOV CX,6
    PUSH ES
    PUSH DS
    MOV ES,VIDWIDE
    MOV DS,VIDPAGE
    TEST SI,1                   ;Even colums display in 32 and 64 col. mode
    JZ VIDEO2                   ;Odd columns display in 64 only.
    ADD BX,OFFSET CHARSET
VIDEO1: MOV AX,CS:[BX]
    INC BX
    INC BX
    MOV [SI],AL
    MOV [SI+2000H],AH
    ADD SI,80
    LOOP VIDEO1
    POP DS
    POP ES
    RET
VIDEO2: 
    MOV DI,BX
    ADD DI,OFFSET CHARSET
    ADD BX,BX
    ADD BX,OFFSET WIDESET
VIDEO3:    
    MOV DX,CS:[BX]
    MOV AX,CS:[BX+2]
    MOV ES:[SI],DH
    MOV ES:[SI+1],DL
    MOV ES:[SI+2000H],AH
    MOV ES:[SI+2001H],AL
    MOV AX,WORD PTR CS:[DI]
    MOV [SI],AL
    MOV [SI+2000H],AH
    ADD SI,80   
    ADD BX,4
    INC DI
    INC DI
    LOOP VIDEO3
    POP DS
    POP ES
    RET
VIDEO ENDP

;The Z-80 Instruction Set

ZLSSNN:             ;LD ss,nn
    getss
    mov ax,es:[bp]
    MOV [SI],AX
    INC BP
    INC BP
ZNOP:   RET         ;NOP
ZLSSA   PROC NEAR   ;LD (ss),A
    getss
    MOV DI,[SI]
    MOV AL,REGA
    MEM_W8
    RET
ZLSSA   ENDP
ZINCSS  PROC NEAR   ;INC ss
    getss
    INC WORD PTR [SI]
    RET
ZINCSS  ENDP
ZINCR   PROC NEAR   ;INC r
    GETR1
    GETFLAG
    INC BYTE PTR [SI]
    CALL PUTFLAGV
    RET
ZINCR   ENDP
ZINCHL  PROC NEAR   ;INC (HL)
    CALL GETPTR
    MEM_R8
    GETFLAG
    INC AL
    CALL PUTFLAGV
    MEM_W8
    RET
ZINCHL  ENDP
ZDECR   PROC NEAR   ;DEC r
    GETR1
    GETFLAG
    DEC BYTE PTR [SI]
    CALL PUTFLAGV
    SUBOPER
    RET
ZDECR   ENDP
ZDECHL  PROC NEAR   ;DEC (HL)
    CALL GETPTR
    MEM_R8
    GETFLAG
    DEC AL
    CALL PUTFLAGV
    MEM_W8
    SUBOPER
    RET
ZDECHL  ENDP
ZLRN    PROC NEAR   ;LD r,n
    MOV AL,ES:[BP]
    INC BP
    GETR1
    MOV [SI],AL
    RET
ZLRN    ENDP
ZLHLN   PROC NEAR   ;LD (HL),n
    CALL GETPTR
    mov al,es:[bp]
    INC BP
    MEM_W8
    RET
ZLHLN   ENDP
ZRLCA   PROC NEAR   ;RLCA
    ROL BYTE PTR REGA,1
    JB ZRLCA1
    AND BYTE PTR REGF,254
    RET
ZRLCA1: OR BYTE PTR REGF,1
    RET
ZRLCA   ENDP
ZEXAF   PROC NEAR   ;EX AF,AF'
    MOV AX,WORD PTR REGF
    XCHG AFPRIME,AX
    MOV WORD PTR REGF,AX
    RET
ZEXAF   ENDP
ZADHLSS PROC NEAR   ;ADD HL,ss
    getss
    mov di,indexreg
    MOV AX,[DI]
    ADD AX,[SI]
    MOV [DI],AX
    JB ZADDHLSS1
    AND BYTE PTR REGF,254
    RET
ZADDHLSS1:  OR BYTE PTR REGF,1
    RET
ZADHLSS     ENDP
ZLASS   PROC NEAR   ;LD A,(ss)
    getss
    MOV DI,[SI]
    MEM_R8
    MOV REGA,AL
    RET
ZLASS   ENDP
ZDECSS  PROC NEAR   ;DEC ss
    getss
    DEC WORD PTR [SI]
    RET
ZDECSS  ENDP
ZRRCA   PROC NEAR   ;RRCA
    ROR BYTE PTR REGA,1
    JB ZRRCA1
    AND BYTE PTR REGF,254
    RET
ZRRCA1: OR BYTE PTR REGF,1
    RET
ZRRCA   ENDP
ZDJNZ   PROC NEAR   ;DJNZ offset
    INC BP
    DEC REGB
    JZ ZDJNZ1
    mov al,es:[bp-1]
    CBW
    ADD BP,AX
ZDJNZ1: RET
ZDJNZ   ENDP
ZRLA    PROC NEAR   ;RLA
    GETFLAG
    RCL BYTE PTR REGA,1
    JB ZRLA1
    AND BYTE PTR REGF,254
    RET
ZRLA1:  OR BYTE PTR REGF,1
    RET
ZRLA    ENDP
ZJR PROC NEAR       ;JR offset
    mov al,es:[bp]
    INC BP
    CBW
    ADD BP,AX
    RET
ZJR ENDP
ZRRA    PROC NEAR   ;RRA
    GETFLAG
    RCR BYTE PTR REGA,1
    JB ZRRA1
    AND BYTE PTR REGF,254
    RET
ZRRA1:  OR BYTE PTR REGF,1
    RET
ZRRA    ENDP
ZJRC    PROC NEAR   ; JR c,offset
    and dl,18h
    INC BP
    CALL GETC
    JNZ ZJRC1
    mov al,es:[bp-1]
    CBW
    ADD BP,AX
ZJRC1:  RET
ZJRC    ENDP
ZLMHL   PROC NEAR   ;LD (nn),HL
    mov di,es:[bp]
    INC BP
    INC BP
    mov si,indexreg
    MOV AX,[si]
    MEM_W16
    RET
ZLMHL   ENDP
ZDAA    PROC NEAR   ;DAA
    TEST BYTE PTR REGF,2
    MOV AL,REGA
    JNZ ZDAA1
    GETFLAG
    DAA
    MOV REGA,AL
    CALL PUTFLAGV
    RET
ZDAA1:  GETFLAG
    DAS
    MOV REGA,AL
    CALL PUTFLAGV
    SUBOPER
    RET
ZDAA    ENDP
ZLHLM   PROC NEAR   ;LD HL,(nn)
    mov di,es:[bp]
    INC BP
    INC BP
    MEM_R16
    mov di,indexreg
    MOV [DI],AX
    RET
ZLHLM   ENDP
ZCPL    PROC NEAR   ;CPL
    NOT REGA
    RET
ZCPL    ENDP
ZLMA    PROC NEAR   ;LD (nn),A
    mov di,es:[bp]
    INC BP
    INC BP
    MOV AL,REGA
    MEM_W8
    RET
ZLMA    ENDP
ZLAM    PROC NEAR   ;LD A,(nn)
    mov di,es:[bp]
    INC BP
    INC BP
    MEM_R8
    MOV REGA,AL
    RET
ZLAM    ENDP
ZSCF    PROC NEAR   ;SCF
    OR BYTE PTR REGF,1
    RET
ZSCF    ENDP
ZCCF    PROC NEAR   ;CCF
    XOR BYTE PTR REGF,1
    RET
ZCCF    ENDP
ZLRR    PROC NEAR   ;LD r,r'
    GETR2
    MOV AL,[SI]
    GETR1
    MOV [SI],AL
    RET
ZLRR    ENDP
ZLHLR   PROC NEAR   ;LD (HL),r
    GETR2
    MOV AL,[SI]
    PUSH AX
    CALL GETPTR
    POP AX
    MEM_W8
    RET
ZLHLR   ENDP
ZLRHL   PROC NEAR   ;LD r,(HL)
    GETR1
    PUSH SI
    CALL GETPTR
    MEM_R8
    POP SI
    MOV [SI],AL
    RET
ZLRHL   ENDP
ZADDAR  PROC NEAR   ;ADD A,r
    GETR2
    MOV AL,[SI]
    GETFLAG
    ADD REGA,AL
    CALL PUTFLAGV
    RET
ZADDAR  ENDP
ZADDAHL PROC NEAR   ;ADD A,(HL)
    CALL GETPTR
    MEM_R8
    GETFLAG
    ADD REGA,AL
    CALL PUTFLAGV
    RET
ZADDAHL ENDP
ZADCAR  PROC NEAR   ;ADC A,r
    GETR2
    MOV AL,[SI]
    GETFLAG
    ADC REGA,AL
    CALL PUTFLAGV
    RET
ZADCAR  ENDP
ZADCAHL PROC NEAR   ;ADC A,(HL)
    CALL GETPTR
    MEM_R8
    GETFLAG
    ADC REGA,AL
    CALL PUTFLAGV
    RET
ZADCAHL ENDP
ZSUBAR  PROC NEAR   ;SUB r
    GETR2
    MOV AL,[SI]
    GETFLAG
    SUB REGA,AL
    CALL PUTFLAGV
    SUBOPER
    RET
ZSUBAR  ENDP
ZSUBAHL PROC NEAR   ;SUB (HL)
    CALL GETPTR
    MEM_R8
    GETFLAG
    SUB REGA,AL
    CALL PUTFLAGV
    SUBOPER
    RET
ZSUBAHL ENDP
ZSBCAR  PROC NEAR   ;SBC A,r
    GETR2
    MOV AL,[SI]
    GETFLAG
    SBB REGA,AL
    CALL PUTFLAGV
    SUBOPER
    RET
ZSBCAR  ENDP
ZSBCAHL PROC NEAR   ;SBC A,(HL)
    CALL GETPTR
    MEM_R8
    GETFLAG
    SBB REGA,AL
    CALL PUTFLAGV
    SUBOPER
    RET
ZSBCAHL ENDP
ZANDR   PROC NEAR   ;AND r
    GETR2
    MOV AL,[SI]
    GETFLAG
    AND REGA,AL
    PUTFLAGP
    RET
ZANDR   ENDP
ZANDHL  PROC NEAR   ;AND (HL)
    CALL GETPTR
    MEM_R8
    GETFLAG
    AND REGA,AL
    PUTFLAGP
    RET
ZANDHL  ENDP
ZXORR   PROC NEAR   ;XOR r
    GETR2
    MOV AL,[SI]
    GETFLAG
    XOR REGA,AL
    PUTFLAGP
    RET
ZXORR   ENDP
ZXORHL  PROC NEAR   ;XOR (HL)
    CALL GETPTR
    MEM_R8
    GETFLAG
    XOR REGA,AL
    PUTFLAGP
    RET
ZXORHL  ENDP
ZORR    PROC NEAR   ;OR r
    GETR2
    MOV AL,[SI]
    GETFLAG
    OR REGA,AL
    PUTFLAGP
    RET
ZORR    ENDP
ZORHL   PROC NEAR   ;OR (HL)
    CALL GETPTR
    MEM_R8
    GETFLAG
    OR REGA,AL
    PUTFLAGP
    RET
ZORHL   ENDP
ZCPR    PROC NEAR   ;CP r
    GETR2
    MOV AL,[SI]
    GETFLAG
    CMP REGA,AL
    CALL PUTFLAGV
    SUBOPER
    RET
ZCPR    ENDP
ZCPHL   PROC NEAR   ;CP (HL)
    CALL GETPTR
    MEM_R8
    GETFLAG
    CMP REGA,AL
    CALL PUTFLAGV
    SUBOPER
    RET
ZCPHL   ENDP
ZHALT   PROC NEAR   ;HALT
    MOV BP,0
    RET
ZHALT   ENDP
ZRETC   PROC NEAR   ;RET c
    CALL GETC
    JNZ ZRETC1
    MOV DI,REGSP
    ADD REGSP,2
    mov bp,es:[di]
ZRETC1: RET
ZRETC   ENDP
ZPOPSS  PROC NEAR   ;POP ss
    getss
    MOV DI,REGSP
    ADD REGSP,2
    mov ax,es:[di]
    MOV [SI],AX
    RET
ZPOPSS  ENDP
ZJPC    PROC NEAR   ;JP c,nn
    INC BP
    INC BP
    CALL GETC
    JNZ ZJPC1
    mov bp,es:[bp-2]
ZJPC1:  RET
ZJPC    ENDP
ZJP PROC NEAR       ;JP nn
    mov bp,es:[bp]
    RET
ZJP ENDP
ZCALLC  PROC NEAR   ;CALL c,nn
    INC BP
    INC BP
    CALL GETC
    JNZ ZCALLC1
    MOV AX,BP
    SUB REGSP,2
    MOV DI,REGSP
    MEM_W16
    mov bp,es:[bp-2]
ZCALLC1: RET
ZCALLC  ENDP
ZPUSHSS PROC NEAR   ;PUSH ss
    getss
    MOV AX,[SI]
    SUB REGSP,2
    MOV DI,REGSP
    MEM_W16
    RET
ZPUSHSS ENDP
ZADDAN  PROC NEAR   ;ADD A,n
    mov al,es:[bp]
    INC BP
    GETFLAG
    ADD REGA,AL
    CALL PUTFLAGV
    RET
ZADDAN  ENDP
ZRST    PROC NEAR   ;RST n
    SUB REGSP,2
    MOV DI,REGSP
    MOV AX,BP
    MEM_W16
    AND DX,38H
    MOV BP,DX
    RET
ZRST    ENDP
ZRET    PROC NEAR   ;RET
    MOV DI,REGSP
    ADD REGSP,2
    mov bp,es:[di]
    RET
ZRET    ENDP
ZCALL   PROC NEAR   ;CALL nn
    INC BP
    INC BP
    mov ax,bp
    SUB REGSP,2
    MOV DI,REGSP
    MEM_W16
    mov bp,es:[bp-2]
    RET
ZCALL   ENDP
ZADCAN  PROC NEAR   ;ADC A,n
    mov al,es:[bp]
    INC BP
    GETFLAG
    ADC REGA,AL
    CALL PUTFLAGV
    RET
ZADCAN  ENDP
ZOUTNA  PROC NEAR   ;OUT n,A
    mov dl,es:[bp]
    INC BP
    MOV AL,REGA
    CALL PORTOUT
    RET
ZOUTNA  ENDP
ZSUBN   PROC NEAR   ;SUB n
    mov al,es:[bp]
    INC BP
    GETFLAG
    SUB REGA,AL
    CALL PUTFLAGV
    SUBOPER
    RET
ZSUBN   ENDP
ZEXX    PROC NEAR   ;EXX
    MOV AX,WORD PTR REGC
    XCHG AX,BCPRIME
    MOV WORD PTR REGC,AX
    MOV AX,WORD PTR REGE
    XCHG AX,DEPRIME
    MOV WORD PTR REGE,AX
    MOV AX,WORD PTR REGL
    XCHG AX,HLPRIME
    MOV WORD PTR REGL,AX
;    MOV AX,WORD PTR REGF
;    XCHG AX,AFPRIME
;    MOV WORD PTR REGF,AX
    RET
ZEXX    ENDP
ZINNA   PROC NEAR   ;IN A,n
    mov dl,es:[bp]
    INC BP
    CALL PORTIN
    MOV REGA,AL
    RET
ZINNA   ENDP
ZSBCAN  PROC NEAR   ;SBC A,n
    mov al,es:[bp]
    INC BP
    GETFLAG
    SBB REGA,AL
    CALL PUTFLAGV
    SUBOPER
    RET
ZSBCAN  ENDP
ZEXSPHL PROC NEAR   ;EX (SP),HL
    MOV DI,REGSP
    mov ax,es:[di]
    PUSH DI
    mov di,indexreg
    XCHG AX,[DI]
    POP DI
    MEM_W16
    RET
ZEXSPHL ENDP
ZANDN   PROC NEAR   ;AND n
    mov al,es:[bp]
    INC BP
    GETFLAG
    AND REGA,AL
    PUTFLAGP
    RET
ZANDN   ENDP
ZJPHL   PROC NEAR   ;JP (HL)
    mov di,indexreg
    mov bp,[di]
    RET
ZJPHL   ENDP
ZEXDEHL PROC NEAR   ;EX DE,HL
    mov di,indexreg
    MOV AX,[DI]
    XCHG AX,WORD PTR REGE
    MOV [DI],AX
    RET
ZEXDEHL ENDP
ZXORN   PROC NEAR   ;XOR n
    mov al,es:[bp]
    INC BP
    GETFLAG
    XOR REGA,AL
    PUTFLAGP
    RET
ZXORN   ENDP
ZPOPAF  PROC NEAR   ;POP AF
    MOV DI,REGSP
    mov ax,es:[di]
    MOV WORD PTR REGF,AX
    ADD REGSP,2
    RET
ZPOPAF  ENDP
ZPUSHAF PROC NEAR   ;PUSH AF
    SUB REGSP,2
    MOV DI,REGSP
    MOV AX,WORD PTR REGF
    MEM_W16
    RET
ZPUSHAF ENDP
ZDI PROC NEAR       ;DI
    AND BYTE PTR SYSSTAT,254
    RET
ZDI ENDP
ZORN    PROC NEAR   ;OR n
    mov al,es:[bp]
    INC BP
    GETFLAG
    OR REGA,AL
    PUTFLAGP
    RET
ZORN    ENDP
ZLDSPHL PROC NEAR   ;LD SP,HL
    mov di,indexreg
    MOV AX,[DI]
    MOV REGSP,AX
    RET
ZLDSPHL ENDP
ZEI PROC NEAR       ;EI
    OR BYTE PTR SYSSTAT,1
    RET
ZEI ENDP
ZCPN    PROC NEAR   ;CP n
    mov al,es:[bp]
    INC BP
    GETFLAG
    CMP REGA,AL
    CALL PUTFLAGV
    SUBOPER
    RET
ZCPN    ENDP
ZRLCR   PROC NEAR   ;RLC r
    AND DL,7
    CMP DL,6
    JZ ZRLCHL
    GETR2
    GETFLAG
    ROL BYTE PTR [SI],1
    MOV AL,[SI]
    CALL FIXSIGN
    CALL PUTFLAGV
    TEST BYTE PTR [SI],-1
    CALL FIXZERO
    RET
ZRLCR   ENDP
ZRLCHL  PROC NEAR   ;RLC (HL)
    MOV DI,WORD PTR REGL
    PUSH DI
    MEM_R8
    POP DI
    GETFLAG
    ROL AL,1
    CALL FIXSIGN
    CALL PUTFLAGV
    MEM_W8
    TEST AL,-1
    CALL FIXZERO
    RET
ZRLCHL  ENDP
ZRRCR   PROC NEAR   ;RRC r
    AND DL,7
    CMP DL,6
    JZ ZRRCHL
    GETR2
    GETFLAG
    ROR BYTE PTR [SI],1
    MOV AL,[SI]
    CALL FIXSIGN
    CALL PUTFLAGV
    TEST BYTE PTR [SI],-1
    CALL FIXZERO
    RET
ZRRCR   ENDP
ZRRCHL  PROC NEAR   ;RRC (HL)
    MOV DI,WORD PTR REGL
    PUSH DI
    MEM_R8
    POP DI
    GETFLAG
    ROR AL,1
    CALL FIXSIGN
    CALL PUTFLAGV
    MEM_W8
    TEST AL,-1
    CALL FIXZERO
    RET
ZRRCHL  ENDP
ZRLR    PROC NEAR   ;RL r
    AND DL,7
    CMP DL,6
    JZ ZRLHL
    GETR2
    GETFLAG
    RCL BYTE PTR [SI],1
    MOV AL,[SI]
    CALL FIXSIGN
    CALL PUTFLAGV
    TEST BYTE PTR [SI],-1
    CALL FIXZERO
    RET
ZRLR    ENDP
ZRLHL   PROC NEAR   ;RL (HL)
    MOV DI,WORD PTR REGL
    PUSH DI
    MEM_R8
    POP DI
    GETFLAG
    RCL AL,1
    CALL FIXSIGN
    CALL PUTFLAGV
    MEM_W8
    TEST AL,-1
    CALL FIXZERO
    RET
ZRLHL   ENDP
ZRRR    PROC NEAR   ;RR r
    AND DL,7
    CMP DL,6
    JZ ZRRHL
    GETR2
    GETFLAG
    RCR BYTE PTR [SI],1
    MOV AL,[SI]
    CALL FIXSIGN
    CALL PUTFLAGV
    TEST BYTE PTR [SI],-1
    CALL FIXZERO
    RET
ZRRR    ENDP
ZRRHL   PROC NEAR   ;RR (HL)
    MOV DI,WORD PTR REGL
    PUSH DI
    MEM_R8
    POP DI
    GETFLAG
    RCR AL,1
    CALL FIXSIGN
    CALL PUTFLAGV
    MEM_W8
    TEST AL,-1
    CALL FIXZERO
    RET
ZRRHL   ENDP
ZSLAR   PROC NEAR   ;SLA r
    AND DL,7
    CMP DL,6
    JZ ZSLAHL
    GETR2
    GETFLAG
    SHL BYTE PTR [SI],1
    MOV AL,[SI]
    CALL FIXSIGN
    CALL PUTFLAGV
    TEST BYTE PTR [SI],-1
    CALL FIXZERO
    RET
ZSLAR   ENDP
ZSLAHL  PROC NEAR   ;SLA (HL)
    MOV DI,WORD PTR REGL
    PUSH DI
    MEM_R8
    POP DI
    GETFLAG
    SHL AL,1
    CALL FIXSIGN
    CALL PUTFLAGV
    MEM_W8
    TEST AL,-1
    CALL FIXZERO
    RET
ZSLAHL  ENDP
ZSRAR   PROC NEAR   ;SRA r
    AND DL,7
    CMP DL,6
    JZ ZSRAHL
    GETR2
    GETFLAG
    SAR BYTE PTR [SI],1
    MOV AL,[SI]
    CALL FIXSIGN
    CALL PUTFLAGV
    TEST BYTE PTR [SI],-1
    CALL FIXZERO
    RET
ZSRAR   ENDP
ZSRAHL  PROC NEAR   ;SRA (HL)
    MOV DI,WORD PTR REGL
    PUSH DI
    MEM_R8
    POP DI
    GETFLAG
    SAR AL,1
    CALL FIXSIGN
    CALL PUTFLAGV
    MEM_W8
    TEST AL,-1
    CALL FIXZERO
    RET         
ZSRAHL  ENDP
ZSRLR   PROC NEAR   ;SRL r
    AND DL,7
    CMP DL,6
    JZ ZSRLHL
    GETR2
    GETFLAG
    SHR BYTE PTR [SI],1
    MOV AL,[SI]
    CALL FIXSIGN
    CALL PUTFLAGV
    TEST BYTE PTR [SI],-1
    CALL FIXZERO
    RET
ZSRLR   ENDP
ZSRLHL  PROC NEAR   ;SRL (HL)
    MOV DI,WORD PTR REGL
    PUSH DI
    MEM_R8
    POP DI
    GETFLAG
    SHR AL,1
    CALL FIXSIGN
    CALL PUTFLAGV
    MEM_W8
    TEST AL,-1
    CALL FIXZERO
    RET
ZSRLHL  ENDP
ZBIT    PROC NEAR   ;BIT b,r
    GETB
    MOV CH,1
    SHL CH,CL
    AND DL,7
    CMP DL,6
    JZ ZBITHL
    GETR2
    MOV BL,REGF
    AND BL,1
    MOV CL,[SI]
    AND CH,CL
    JZ ZBIT1
ZBIT2:  OR CL,CL
    PUTFLAGP
    AND BYTE PTR REGF,190
    OR REGF,BL
    RET
ZBIT1:  OR CL,CL
    PUTFLAGP
    OR BL,64
    AND BYTE PTR REGF,254
    OR REGF,BL
    RET
ZBITHL: PUSH CX
    MOV DI,WORD PTR REGL
    MEM_R8
    POP CX
    MOV BL,REGF
    AND BL,1
    AND AL,CH
    JZ ZBIT1
    JMP ZBIT2
ZBIT    ENDP
ZRES    PROC NEAR   ;RES b,r
    GETB
    MOV CH,254
    ROL CH,CL
    AND DL,7
    CMP DL,6
    JZ ZRESHL
    GETR2
    AND BYTE PTR [SI],CH
    RET
ZRESHL: MOV DI,WORD PTR REGL
    MOV AL,ES:[DI]
    AND AL,CH
    MEM_W8
    RET
ZRES    ENDP
ZSET    PROC NEAR   ;SET b,r
    GETB
    MOV CH,1
    ROL CH,CL
    AND DL,7
    CMP DL,6
    JZ ZSETHL
    GETR2
    OR BYTE PTR [SI],CH
    RET
ZSETHL: MOV DI,WORD PTR REGL
    MOV AL,ES:[DI]
    OR AL,CH
    MEM_W8
    RET
ZSET    ENDP
ZINRC   PROC NEAR   ;IN r,(C)
    PUSH DX
    MOV DL,REGC
    CALL PORTIN
    POP DX
    GETR1
    MOV [SI],AL
    GETFLAG
    OR AL,AL
    PUTFLAGP
    RET
ZINRC   ENDP
ZOUTRC  PROC NEAR   ;OUT (C),r
    GETR1
    MOV AL,[SI]
    MOV DL,REGC
    CALL PORTOUT
    RET
ZOUTRC  ENDP
ZSBCHL  PROC NEAR   ;SBC HL,ss
    getss
    mov di,indexreg
    GETFLAG
    MOV AX,[SI]
    SBB [DI],AX
    CALL PUTFLAGV
    SUBOPER
    RET
ZSBCHL  ENDP
ZLMSS   PROC NEAR   ;LD (nn),ss
    getss
    mov di,es:[bp]
    INC BP
    INC BP
    MOV AX,[SI]
    MEM_W16
    RET
ZLMSS   ENDP
ZNEG    PROC NEAR   ;NEG
    GETFLAG
    NEG REGA
    CALL PUTFLAGV
    RET
ZNEG    ENDP
ZRETN   PROC NEAR   ;RETN - Not implemented in TRS-80.  NMI=Reset
    JMP ZRET
ZRETN   ENDP
ZIMN    PROC NEAR   ;IM n - Not implemented in TRS-80.  Architecture makes
    RET             ;IM 0 and IM 1 equivalent.  IM 2 is just plain dangerous
                    ;and will crash the system in all but the most contrived
                    ;situations.
ZIMN    ENDP
ZLDIA   PROC NEAR   ;LD I,A
    MOV AL,REGA
    MOV REGI,AL
    RET
ZLDIA   ENDP
ZADCHL  PROC NEAR   ;ADC HL,ss
    getss
    mov di,indexreg
    GETFLAG
    MOV AX,[SI]
    ADC [DI],AX
    CALL PUTFLAGV
    RET
ZADCHL  ENDP
ZLSSM   PROC NEAR   ;LD ss,(nn)
    getss
    mov di,es:[bp]
    INC BP
    INC BP
    MEM_R16
    MOV [SI],AX
    RET
ZLSSM   ENDP
ZRETI   PROC NEAR   ;RETI - Not implemented in TRS-80.  Architecture makes
    JMP ZRET        ;this indistinguishable from RET.
ZRETI   ENDP
ZLDRA   PROC NEAR   ;LD R,A
    MOV AL,REGA
    MOV REGR,AL
    RET
ZLDRA   ENDP
ZLDAI   PROC NEAR   ;LD A,I
    MOV AL,REGI
    MOV REGA,AL
    RET
ZLDAI   ENDP
ZLDAR   PROC NEAR   ;LD A,R
    MOV AL,REGR
    mov ah,al
    inc al
    and ax,807fh
    or al,ah
    mov regr,al
    push es
    mov bx,64
    mov es,bx
    xor al,es:[6Ch]
    xor al,es:[6dh]
    pop es
    and al,127
    or al,ah
    MOV REGA,AL
    and byte ptr regf,0bbh
    cmp al,0
    jnz zldar1
    or byte ptr regf,40h
zldar1:
    test byte ptr sysstat,1
    jz zldar2
    or byte ptr regf,4
zldar2:
    RET
ZLDAR   ENDP
ZRRD    PROC NEAR   ;RRD
    MOV DI,WORD PTR REGL
    MEM_R8
    MOV AH,REGA
    MOV CL,4
    ROR AX,CL
    ROR AH,CL
    MOV REGA,AH
    CALL FIXSIGN
    PUTFLAGP
    MEM_W8
    TEST AH,-1
    CALL FIXZERO
    RET
ZRRD    ENDP
ZRLD    PROC NEAR   ;RLD
    MOV DI,WORD PTR REGL
    MEM_R8
    MOV AH,REGA
    MOV CL,4
    ROL AH,CL
    ROL AX,CL
    MOV REGA,AH
    CALL FIXSIGN
    PUTFLAGP
    MEM_W8
    TEST AH,-1
    CALL FIXZERO
    RET
ZRLD    ENDP
ZLDI    PROC NEAR   ;LDI
    MOV DI,WORD PTR REGL
    INC WORD PTR REGL
    MEM_R8
    MOV DI,WORD PTR REGE
    INC WORD PTR REGE
    MEM_W8
    DEC WORD PTR REGC
    MOV AX,WORD PTR REGC
    OR AX,AX
    JNZ LDI1
    AND BYTE PTR REGF,251
    RET
LDI1:   OR BYTE PTR REGF,4
    RET
ZLDI    ENDP
ZCPI    PROC NEAR   ;CPI
    MOV DI,WORD PTR REGL
    INC WORD PTR REGL
    MEM_R8
    GETFLAG
    MOV AH,REGF
    CMP REGA,AL
    PUTFLAGP
    AND AH,1
    AND BYTE PTR REGF,250
    OR REGF,AH
    DEC WORD PTR REGC
    MOV AX,WORD PTR REGC
    OR AX,AX
    JZ ZCPI1
    OR BYTE PTR REGF,4
ZCPI1:  RET
ZCPI    ENDP
ZLDD    PROC NEAR   ;LDD
    MOV DI,WORD PTR REGL
    DEC WORD PTR REGL
    MEM_R8
    MOV DI,WORD PTR REGE
    DEC WORD PTR REGE
    MEM_W8
    DEC WORD PTR REGC
    MOV AX,WORD PTR REGC
    OR AX,AX
    JNZ LDD1
    AND BYTE PTR REGF,251
    RET
LDD1:   OR BYTE PTR REGF,4
    RET
ZLDD    ENDP
ZCPD    PROC NEAR   ;CPD
    MOV DI,WORD PTR REGL
    DEC WORD PTR REGL
    MEM_R8
    GETFLAG
    MOV AH,REGF
    CMP REGA,AL
    PUTFLAGP
    AND AH,1
    AND BYTE PTR REGF,250
    OR REGF,AH
    DEC WORD PTR REGC
    MOV AX,WORD PTR REGC
    OR AX,AX
    JZ ZCPD1
    OR BYTE PTR REGF,4
ZCPD1:  RET
ZCPD    ENDP
ZLDIR   PROC NEAR   ;LDIR
    MOV bx,WORD PTR REGL
    MOV di,WORD PTR REGE
    MOV CX,WORD PTR REGC
ZLDIR1: PUSH CX
    PUSH BX
    mov al,es:[bx]
    MEM_W8
    POP BX
    POP CX
    INC BX
    INC DI
    LOOP ZLDIR1
    MOV WORD PTR REGL,bx
    MOV WORD PTR REGE,di
    MOV WORD PTR REGC,CX
    AND BYTE PTR REGF,251
    RET
ZLDIR   ENDP
ZCPIR   PROC NEAR   ;CPIR
    MOV DI,WORD PTR REGL
    MOV CX,WORD PTR REGC
ZCPIR1: 
    mov al,es:[di]
    INC DI
    CMP AL,REGA
    JZ ZCPIR2
    LAHF
    AND AH,128
    AND BYTE PTR REGF,127
    OR REGF,AH
    LOOP ZCPIR1
    AND BYTE PTR REGF,187
ZCPIR3: MOV WORD PTR REGL,DI
    MOV WORD PTR REGC,CX
    RET
ZCPIR2: LAHF
    AND AH,128
    AND BYTE PTR REGF,59
    OR BYTE PTR REGF,64
    OR REGF,AH
    DEC CX
    OR CX,CX
    JZ ZCPIR3
    OR BYTE PTR REGF,4
    JMP ZCPIR3
ZCPIR   ENDP
ZLDDR   PROC NEAR   ;LDDR
    MOV bx,WORD PTR REGL
    MOV di,WORD PTR REGE
    MOV CX,WORD PTR REGC
ZLDDR1: PUSH CX
    PUSH BX
    mov al,es:[bx]
    MEM_W8
    POP BX
    POP CX
    DEC DI
    DEC BX
    LOOP ZLDDR1
    MOV WORD PTR REGL,bx
    MOV WORD PTR REGE,di
    MOV WORD PTR REGC,CX
    AND BYTE PTR REGF,251
    RET
ZLDDR   ENDP
ZCPDR   PROC NEAR   ;CPDR
    MOV DI,WORD PTR REGL
    MOV CX,WORD PTR REGC
ZCPDR1: 
    mov al,es:[di]
    DEC DI
    CMP AL,REGA
    JZ ZCPDR2
    LAHF
    AND AH,128
    AND BYTE PTR REGF,127
    OR REGF,AH
    LOOP ZCPDR1
    AND BYTE PTR REGF,187
ZCPDR3: MOV WORD PTR REGL,DI
    MOV WORD PTR REGC,CX
    RET
ZCPDR2: LAHF
    AND AH,128
    AND BYTE PTR REGF,59
    OR BYTE PTR REGF,64
    OR REGF,AH
    DEC CX
    OR CX,CX
    JZ ZCPDR3
    OR BYTE PTR REGF,4
    JMP ZCPDR3
ZCPDR   ENDP
ZINI    PROC NEAR   ;INI
    mov dl,regc
    call portin
    mov di,word ptr regl
    MEM_W8
    inc di
    mov word ptr regl,di
    dec regb
    call fixzero
    RET
ZINI    ENDP
ZIND    PROC NEAR   ;IND
    mov dl,regc
    call portin
    mov di,word ptr regl
    MEM_W8
    dec di
    mov word ptr regl,di
    dec regb
    call fixzero
    RET
ZIND    ENDP
ZINIR   PROC NEAR   ;INIR
    mov di,word ptr regl
zinir1:     
    mov dl,regc
    push di
    call portin
    pop di
    MEM_W8
    inc di
    dec regb
    jnz zinir1
    mov word ptr regl,di
    call fixzero
    RET
ZINIR   ENDP
ZINDR   PROC NEAR   ;INDR
    mov di,word ptr regl
zindr1:     
    mov dl,regc
    push di
    call portin
    pop di
    MEM_W8
    dec di
    dec regb
    jnz zindr1
    mov word ptr regl,di
    call fixzero
    RET
ZINDR   ENDP
ZOUTI   PROC NEAR   ;OUTI
    mov di,word ptr regl
    MEM_R8
    mov dl,regc
    call portout
    inc di
    dec regb
    mov word ptr regl,di
    call fixzero
    RET
ZOUTI   ENDP
ZOUTD   PROC NEAR   ;OUTD
    mov di,word ptr regl
    MEM_R8
    mov dl,regc
    call portout
    dec di
    dec regb
    mov word ptr regl,di
    call fixzero
    RET
ZOUTD   ENDP
ZOTIR   PROC NEAR   ;OTIR
    mov di,word ptr regl
zotir1:
    MEM_R8
    mov dl,regc
    push di
    call portout
    pop di
    inc di
    dec regb
    jnz zotir1
    mov word ptr regl,di
    call fixzero
    RET
ZOTIR   ENDP
ZOTDR   PROC NEAR   ;OTDR
    mov di,word ptr regl
zotdr1:
    MEM_R8
    mov dl,regc
    push di
    call portout
    pop di
    dec di
    dec regb
    jnz zotdr1
    mov word ptr regl,di
    call fixzero
    RET
ZOTDR   ENDP

;End of instruction set.
;Start of setup sequence.

BASE_SEGMENT DW 0               ;PSP segment for memory reallocation

START:  MOV CS:BASE_SEGMENT,DS
        MOV AX,ES:[2CH]
    mov si,128          ;Check for preload *.IMG request
    mov di,offset dta
    mov byte ptr cs:[di],0
    mov al,[si]
    cmp al,0
    jz preload2
preload:                ;Skip leading spaces
    inc si
    mov al,[si]
    cmp al,' '
    jz preload
    CMP WORD PTR [SI],312FH
    JNZ PRELOAD0        ;If "/1" option included, load Level I ROMs
    MOV CS:ROMSWITCH,OFFSET L1ROMIMAGE
    INC SI
    JMP PRELOAD
PRELOAD0:
preload2:
    PUSH CS
    POP DS
    mov ax,offset ramstart
    mov cl,4
    shr ax,cl
    push cs
    pop bx
    add ax,bx
    inc ax
    mov pseudoram,ax    ;Segment of TRS-80 RAM
    ADD AX,1000H        ;32-column mode CGA segment
    MOV VIDWIDE,AX
    MOV AX,3
    MOV BH,0
    INT 10H
    MOV AX,3D00H        ;Read character set
    MOV DX,OFFSET TEXTFONT
    INT 21H
    MOV BX,AX
    JNB START1
ERROR:  MOV AH,3EH
    INT 21H
    MOV DX,OFFSET ERRMSG
    MOV AH,9
    INT 21H
    MOV AX,4C00H
    INT 21H
START1: MOV AH,3FH
    MOV DX,OFFSET CHARSET
    MOV CX,2
    INT 21H
    JB ERROR
    MOV AH,3FH
    MOV CX,3072
    INT 21H
    JB ERROR
    MOV AH,3EH
    INT 21H
    MOV AX,6            ;Select CGA mode
    MOV BH,0
    INT 10H
    call expand         ;Generate 32-column character set
    push es
    mov es,vidwide      ;Clear 32-column screen
    mov di,0
    mov al,0
    mov cx,4000h        ;Clear TRS-80 RAM
    rep stosb
    mov es,pseudoram
    mov di,3c00h
    mov si,0
screen: mov al,msg6[si] ;Display startup message
    push si
    call putbyte
    pop si
    inc di
    inc si
    cmp si,1024
    jb screen
    pop es
    MOV AX,3D00H
    MOV DX,OFFSET CONFIG ;Read configurations (LOOKUP, Disknames, switches)
    INT 21H
    MOV BX,AX
    JB START1A
    MOV AH,3FH
    MOV DX,OFFSET LOOKUP
    MOV CX,OFFSET CONFIG_END-OFFSET LOOKUP
    INT 21H
    JB ERRORA
    MOV AH,3FH                  ;This byte is separate to preserve
    MOV DX,OFFSET CAS_PLAYREC   ;snapshot compatibility
    MOV CX,5
    INT 21H
    MOV AX,CONFIG_DELAY
    MOV DELAY,AX
ERRORA:
    MOV AH,3EH
    INT 21H
START1A:
    MOV AX,3D00H
    MOV DX,ROMSWITCH            ;Read ROM image
    INT 21H
    MOV BX,AX
    JNB START2
ERROR2: MOV AH,3EH
    INT 21H
    mov ax,3
    MOV BH,0
    int 10h
    MOV DX,OFFSET ERRMSG2
    MOV AH,9
    INT 21H
    MOV AX,4C00H
    INT 21H
START2: PUSH DS
    MOV CX,12288
    MOV DX,0
    MOV ds,pseudoram
    MOV AH,3FH
    INT 21H
    POP DS
    JB ERROR2
    MOV AH,3EH
    INT 21H
    MOV AX,3509H        ;Store old PC interrupt handler addresses
    INT 21H
    MOV OLDLOW,BX
    MOV OLDHI,ES
    mov ax,3523h
    int 21h
    mov ctrlclo,bx
    mov ctrlchi,es
    MOV AX,3524H
    INT 21H
    MOV OLDFL,BX
    MOV OLDFH,ES
    mov ax,3508h
    int 21h
    mov oldcl,bx
    mov oldch,es
    mov ax,350bh
    int 21h
    mov irq3lo,bx
    mov irq3hi,es
    mov ax,350ch
    int 21h
    mov irq4lo,bx
    mov irq4hi,es
    MOV ES,pseudoram
    MOV CX,800H
    MOV DI,3000H
    MOV AL,-1
    REP STOSB
    MOV CX,400H
    MOV AL,CL
    REP STOSB
    add di,400h
    MOV CX,0C000H
    MOV AL,CL
    REP STOSB
    MOV AX,2509H
    MOV DX,OFFSET KEYDMA        ;Install new interrupt handlers
    INT 21H
    MOV AX,2524H
    MOV DX,OFFSET FATAL
    INT 21H
    mov ax,2523h
    mov dx,offset ctrlc
    int 21h
    mov ax,2508h
    mov dx,offset clock
    int 21h                     ;Enable clock if selected
    MOV AX,3D00H
    MOV DX,OFFSET DRVSEL
    INT 21H
    MOV HANDLE,AX
    CALL COMINIT        ;Initialise comm ports
    PUSH ES
    MOV AX,CS
    MOV ES,AX
    MOV AX,14H          ;Add interrupt to detect right button
    MOV CX,8            ;Interrupt when right button pressed
    MOV DX,OFFSET MOUSE_SCAN
    INT 33H
    MOV OLDMOUSELO,DX
    MOV OLDMOUSEHI,ES
    MOV OLDMOUSEMASK,CX
    POP ES
    mov timer,0
    call resetbranch
    MOV BP,0            ;Set PC=0
    JMP MAIN            ;Start up emulation

COMINIT PROC NEAR       ;Initialise comm port
    mov ax,250ch        ;Define serial port interrupts
    mov dl,switches     ;COM1:=IRQ4, COM2:=IRQ3
    and dl,1
    sub al,dl
    mov dx,offset comint
    int 21h
    mov dx,3fdh
    mov cl,switches
    and cl,1
    sub dh,cl
    mov comstat,dx      ;COM1:=3FDH, COM2:=2FDH
    in al,33            ;Enable IRQ3 or 4
    mov ah,0efh
    ror ah,cl
    mov oldmask,al
    and al,ah
    out 33,al
    sub dl,4
    in al,dx             ;Enable receive interrupt on RS-232 for buffering
    mov mdmmask,al 
    mov al,1
    out dx,al
    add dl,2
    mov al,mdmset        ;Reset COM port
    or al,128
    OUT DX,AL
    mov ax,baud
    sub dl,3
    out dx,al
    mov al,ah
    inc dx
    out dx,al
    inc dx
    inc dx
    mov al,mdmset
    out dx,al
    inc dx
    mov al,11
    out dx,al
    MOV AX,0            ;Test for presence of the mouse and reset mouse's
    INT 33H             ;COM port to avoid conflict
    MOV BYTE PTR MOUSE_HERE,AL
    RET
COMINIT ENDP
INST    PROC NEAR       ;Z-80 instruction lookup
    MOV DL,ES:[BP]
    INC BP
    MOV BL,DL
    MOV BH,0            ;SET1 starts at segment boundary
    ADD BX,BX
    JMP WORD PTR [BX]
INST    ENDP

ZBAD    PROC NEAR
        RET
ZBAD    ENDP

CBNORM  PROC NEAR   ;CBh-prefixed instruction lookup
    MOV DL,ES:[BP]      ;(IX or IY not selected)
    INC BP
    MOV BL,DL
    MOV BH,16           ;BH is divided by 4 below giving address 400-43EH
    SHR BX,1            ;which is SET2
    SHR BX,1
    AND BL,3EH
    JMP WORD PTR [BX]
CBNORM  ENDP

CBPREF  PROC NEAR       
    CMP BYTE PTR GETPTR1,0C3H
    JZ CBNORM
    MOV AL,ES:[BP]      ;CBh-prefixed inst. lookup when IX or IY selected
    INC BP
    CBW
    MOV DI,INDEXREG
    MOV DI,[DI]
    ADD DI,AX
    PUSH WORD PTR REGL
    MOV WORD PTR REGL,DI
    CALL CBNORM
    POP WORD PTR REGL
    RET
CBPREF  ENDP

EDPREF: MOV DL,ES:[BP]  ;EDh-prefixed instruction lookup
    INC BP
    MOV BL,DL
    MOV BH,1            ;BH is multiplied by 2 giving 200H-3FEH which is SET3
    ADD BX,BX
    JMP WORD PTR [BX]

IXPREF:                      ;Handler for IX selected
    MOV INDEXREG,OFFSET REGIX
    MOV BYTE PTR GETPTR1,90H
    CALL INST                   ;index displacement byte
    MOV BYTE PTR GETPTR1,0C3H
    mov ax,offset regl
    mov indexreg,ax
    RET

IYPREF:                      ;Handler for IY selected
    MOV INDEXREG,OFFSET REGIY
    MOV BYTE PTR GETPTR1,90H
    CALL INST
    MOV BYTE PTR GETPTR1,0C3H
    mov ax,offset regl
    mov indexreg,ax
    RET

MAIN:                   ;Main interpreter loop
    mov cx,delay
hold: loop hold
main1:    
    call inst
    db 0ebh             ;Short JMP instruction
branch db offset main1-offset branch1   ;Branch to contents+offset branch1
branch1: jmp debug
branch2: jmp newfile
branch3: jmp vircas
branch4: jmp break_test
branch5: jmp clock_int
BRANCH6:
        JMP TAPE
BRANCH7:
        JMP HELP
BRANCH8:
        JMP RESET

RESET:  MOV TIMER,0     ;CTRL-F1 reset handler
        MOV INTDMA,3FH
        MOV STATUS,80H
        AND BYTE PTR SYSSTAT,240
        MOV BP,66H
        CALL RESETBRANCH
        JMP MAIN

break_test:             ;If BREAK enabled, is PC at breakpoint?
    cmp bp,brkpt
    jnz main
    jmp debug

clock_int:              ;A TRS-80 clock interrupt was requested
    mov al,old_branch
    mov branch,al
    mov timer,0
    shl cl,1
    shl cl,1
    test byte ptr sysstat,1      ;Do not interrupt if DI last issued
    jz main
    mov dx,38h
    call zrst
    jmp main

resetbranch proc near           ;Reset main loop branch to "MAIN" or 
    mov ah,offset main-offset branch1
    cmp delay,1
    jnz resetbranch0
    mov ah,offset main1-offset branch1
resetbranch0:
    mov cs:branch,ah
    mov cs:old_branch,ah
    ret
resetbranch endp
    
;Debugger main selection mouse translations (see VDM_MOUSE for explanation)
DBG_MOUSE DB 3,1,6,128
        DB 4,1,6,128
        DB 5,1,6,129
        DB 6,1,6,129
        DB 7,1,6,130
        DB 8,1,6,130
        DB 9,1,6,131
        DB 10,1,6,131
        DB 11,1,6,132
        DB 12,1,6,132
        DB 13,1,6,133
        DB 14,1,6,133
        DB 15,1,6,134
        DB 16,1,6,134
        DB 17,1,6,135
        DB 18,1,6,135
        DB 19,1,6,136
        DB 20,1,6,136
DBG2_MOUSE DB 16,73,78,137
        DB 17,73,78,137
        DB 18,73,78,138
        DB 19,73,78,138
        DB 20,73,78,139
        DB 21,73,78,139
        DB 22,73,78,140
        DB 23,73,78,140
        DB 3,73,78,'B'
        DB 4,73,78,'C'
        DB 5,73,78,'E'
        DB 6,73,78,'K'
        DB 7,73,78,'L'
        DB 8,73,78,'M'
        DB 9,73,78,'Q'
        DB 10,73,78,'R'
        DB 11,73,78,'S'
        DB -1
DBG_QUIT_MOUSE DB 13,73,74,'Y'
        DB 13,75,76,'N'
        DB -1

DEBUG:  ;Debugger entry point
    call resetbranch
    MOV TIMER,128               ;Shut off time clock interrupt
    AND BYTE PTR SYSSTAT,143 ;Turn off break, single step, and mem display
    MOV BYTE PTR LASTSCAN,0
    MOV AX,2509H        ;Restore normal keyboard
    MOV BYTE PTR LASTOPT,0
    PUSH DS
    MOV DX,OLDLOW
    MOV DS,OLDHI
    INT 21H
    POP DS
FLUSH:  MOV AH,1
    INT 16H
    JZ FLUSH1
    MOV AH,0
    INT 16H
    JMP FLUSH
FLUSH1: MOV DL,0
    MOV DI,OFFSET MSG1
    CALL COL
    MOV DL,72
    MOV DI,OFFSET MSG3
    CALL COL
    CALL MAINREG
    JMP DEBUG1
SINGLE: TEST BYTE PTR SYSSTAT,16
    JZ SINGLE1
    CALL MEMMAP
    JMP DEBUG1
SINGLE1:    CALL MAINREG
DEBUG1: CALL PRIMEREG
DEBUG2: CALL HILITE
    MOV LASTOPT,0
    PUSH BP
    MOV BP,OFFSET DBG_MOUSE
    TEST BYTE PTR SYSSTAT,16
    JZ DEBUG2A
    MOV BP,OFFSET DBG2_MOUSE
DEBUG2A:
        CALL KEYMOUSE
        POP BP
        CMP AL,27
        JNZ DEBUG2B
        MOV AL,'C'
DEBUG2B:
        AND AL,223
    CMP AL,'B'
    JNZ DEBUG3
    MOV LASTOPT,3
    CALL HILITE
    MOV AX,BRKPT
    CALL ADDRESS
    JZ DEBUG2
    MOV BRKPT,AX        ;Break
    OR BYTE PTR SYSSTAT,64
    MOV DI,OFFSET MSG5
    MOV DL,0
    CALL COL
    MOV AX,BRKPT
    MOV DX,202H
    CALL HEX
    mov ah,offset branch4-offset branch1 ;Set breakpoint check interpreter
    mov old_branch,ah                    ;branch
    mov branch,ah
    mov timer,0
    JMP CONT
DEBUG3: CMP AX,4000H            ;F6=abort
    JZ CONT1
    CMP AL,'C'
    JNZ DEBUG4   
CONT1:  MOV LASTOPT,4
    CALL HILITE
CONT2:  MOV DI,OFFSET MSG4  ;Continue (normal re-entry into emulation)
    MOV DL,0            ;Clear left margin of screen
    CALL COL
CONT:   MOV DI,OFFSET MSG4
    MOV DL,72
    CALL COL            ;Clear right margin
    MOV AX,2509H
    MOV DX,OFFSET KEYDMA
    INT 21H
    and byte ptr sysstat,239
    mov timer,0                 ;Restart real time clock
    JMP MAIN
DEBUG4: CMP AL,'S'
    JNZ DEBUG5
    MOV LASTOPT,11
    CALL HILITE
    CALL INST       ;Step
    JMP SINGLE
DEBUG5: CMP AL,'K'
    JNZ DEBUG7
    MOV LASTOPT,6       ;Key
    CALL HILITE
    MOV AX,2509H
    MOV DX,OFFSET KEYDMA
    INT 21H
DEBUG6: MOV AH,LASTSCAN
    CMP AH,0
    JNG DEBUG6
    MOV DX,OLDLOW
    MOV AX,2509H
    PUSH DS
    MOV DS,OLDHI
    INT 21H
    POP DS
    MOV LASTSCAN,0
DEBUG8: JMP DEBUG2
DEBUG7: CMP AL,'R'      ;Reset
    JNZ DEBUG9
    MOV LASTOPT,10
    CALL HILITE
    mov timer,0
    mov intdma,3fh
    MOV STATUS,80H
    AND byte ptr SYSSTAT,240
    MOV BP,66H
    JMP CONT2
DEBUG9: CMP AL,'Q'
    JZ DEBUG10a
    jmp debug10
debug10a:
    MOV LASTOPT,9       ;Quit
    CALL HILITE
    MOV AH,2
    MOV BH,0
    MOV DX,0D49H
    INT 10H
    MOV AX,0E59H
    MOV BL,1
    INT 10H
    MOV AL,'/'
    INT 10H
    MOV AL,'N'
    INT 10H
    MOV AL,'?'
    INT 10H
QUIT1:  PUSH BP
        MOV BP,OFFSET DBG_QUIT_MOUSE
        CALL KEYMOUSE
        POP BP
        CMP AL,27
        JZ QUIT1B
        AND AL,223
    CMP AL,'Y'
    JZ QUIT2
    CMP AL,'N'
    JNZ QUIT1
QUIT1B:
    MOV DX,0D49H
    MOV AH,2
    MOV BH,0
    INT 10H
    MOV CX,6
    MOV AX,920H
    MOV BL,1
    INT 10H
    JMP DEBUG2
QUIT2:  
        CALL CASSETTE_CLOSE
    MOV AX,2524H
    PUSH DS
    MOV DS,OLDFH
    MOV DX,OLDFL
    INT 21H
    mov ax,2508h
    mov ds,cs:oldch
    mov dx,cs:oldcl
    int 21h
    mov ax,2523h
    mov ds,cs:ctrlchi
    mov dx,cs:ctrlclo
    int 21h
    mov ax,250bh
    mov ds,cs:irq3hi
    mov dx,cs:irq3lo
    int 21h
    mov ax,250ch
    mov ds,cs:irq4hi
    mov dx,cs:irq4lo
    int 21h
    POP DS
    mov dx,comstat
    sub dx,4
    mov al,mdmmask
    out dx,al
    mov al,oldmask
    out 33,al
        MOV AX,0                ;Reset mouse
        INT 33H
        PUSH ES
        MOV AX,14H              ;Restore original mouse interrupt
        MOV ES,OLDMOUSEHI
        MOV CX,OLDMOUSEMASK
        MOV DX,OLDMOUSELO
        INT 33H
        POP ES
    MOV AX,3
    MOV BH,0
    INT 10H
    cli
    mov al,36h
    out 43h,al
    mov al,255
    out 40h,al
    out 40h,al
    sti
        MOV AH,3CH ;Write new config file
        MOV DX,OFFSET CONFIG
        mov cx,0
        INT 21H
        MOV BX,AX
        JB SAVE_ERROR
        MOV AH,40H
        MOV DX,OFFSET LOOKUP
        MOV CX,OFFSET CONFIG_END-OFFSET LOOKUP
        INT 21H
        JB SAVE_ERROR
        MOV AX,DELAY
        MOV CONFIG_DELAY,AX
        MOV AH,40H
        MOV DX,OFFSET CAS_PLAYREC
        MOV CX,5        ;This byte is separate to preserve snapshot 
        INT 21H         ;compatibility
SAVE_ERROR: MOV AH,3EH
        INT 21H
    call fixclock       ;Attempt to correct clock for acceleration
    MOV AX,4C00H
    INT 21H
DEBUG10:    CMP AL,'M'
    JNZ DEBUG11
    MOV LASTOPT,8       ;Memory
    CALL HILITE
    MOV AX,MEMPAGE
    CALL ADDRESS
    JZ DEBUG8A
    MOV MEMPAGE,AX
    OR BYTE PTR SYSSTAT,16
    CALL MEMMAP
DEBUG8A:    JMP DEBUG2
DEBUG11:    CMP AL,'E'
    JNZ DEBUG14
    MOV LASTOPT,5       ;Edit
    CALL HILITE
    MOV AX,MEMPAGE
    DEC AX
    MOV MEMPAGE,AX
    OR BYTE PTR SYSSTAT,16
DEBUG12:    CALL MEMMAP
    MOV DX,205H
    MOV BH,0
    MOV AH,2
    INT 10H
    MOV CX,2
    MOV BL,129
    MOV AX,09DBH
    INT 10H
    INC MEMPAGE
    MOV DI,MEMPAGE
    MEM_R8
    MOV AH,0
    CALL ADDRESS
    JZ DEBUG13
    MOV DI,MEMPAGE
    MOV ES:[DI],AL
    CMP DI,4000H
    JNB DEBUG12
    CMP DI,3C00H
    JB DEBUG12
    CALL VIDEO
    JMP DEBUG12
DEBUG13:    CALL MEMMAP
DEBUG13A:
        SUB AL,128
        JB DEBUG13B
        MOV REGPC,BP
        MOV CL,AL
        PUSH CX
        JMP DEBUG14B
DEBUG13B:
        JMP DEBUG2
DEBUG14:    CMP AL,'L'
    JNZ DEBUG13A
    MOV LASTOPT,7       ;Load
    CALL HILITE
    TEST BYTE PTR SYSSTAT,16
    MOV CL,0
    PUSH CX
    JZ DEBUG14A
DEBUG14B:
    MOV DI,OFFSET MSG1
    MOV DL,0
    CALL COL
    CALL MAINREG
    AND BYTE PTR SYSSTAT,239
DEBUG14A:   
        MOV REGPC,BP
        POP CX
DEBUG15:    MOV DH,CL
    SHL DH,1
    ADD DH,4
    MOV DL,1
    CMP DH,21
    JB DEBUG16
    SUB DH,5
    MOV DL,73
DEBUG16:    MOV AH,2
    MOV BH,0
    INT 10H
    MOV AX,910H
    PUSH CX
    MOV CX,1
    MOV BX,CX
    INT 10H
    ADD DL,5
    MOV AH,2
    INT 10H
    MOV AX,911H
    INT 10H
    POP CX
    MOV CH,0
    MOV SI,CX
    SHL SI,1
    MOV AX,WORD PTR REGC[SI]
    PUSH SI
    PUSH CX
    PUSH DX
    OR BYTE PTR SYSSTAT,32
    CALL ADDRESS
    POP DX
    PUSHF
    PUSH AX
    MOV AH,2
    INT 10H
    MOV AX,920H
    MOV CX,1
    MOV BX,CX
    INT 10H
    SUB DL,5
    MOV AH,2
    INT 10H
    MOV AX,920H
    INT 10H
    POP AX
    POPF
    POP CX
    POP SI
    JNZ DEBUG17
    JMP DEBUG2
DEBUG17:    JB  DEBUG18
    MOV WORD PTR REGC[SI],AX
    MOV BP,REGPC
    PUSH DX
    PUSH CX
    CALL MAINREG
    CALL PRIMEREG
    POP CX
    POP DX
    JMP DEBUG16
DEBUG18:    CMP AX,5000H
    JZ DEBUG19
    CMP AX,4800H
    JNZ DEBUG20
    SUB CL,1
    JNB DEBUG20
    MOV CL,12
DEBUG20:    JMP DEBUG15
DEBUG19:    INC CL
    CMP CL,13
    JB DEBUG20
    MOV CL,0
    JMP DEBUG15

MOUSE_HERE DB 0         ;Non-zero indicates mouse driver installed

HILITE_LINE DB -1       ;Line currently highlighted by mouse
HILITE_COL DW 0         ;Start/end column of mouse highlight
HILITE_CMD DB 0         ;Command key associated with highlighted area

HILITE_MOUSE PROC NEAR  ;Toggle highlight of current mouse field
        PUSH AX
        PUSH BX
        PUSH CX
        PUSH DX
        MOV AH,3
        MOV BX,129
        INT 10H
        PUSH DX
        MOV CL,BYTE PTR HILITE_COL[1]
        MOV DH,HILITE_LINE
        AND DH,127
        MOV DL,BYTE PTR HILITE_COL
        SUB CL,DL
        MOV CH,0
        INC CL
        CMP DH,127
        JZ HILITEM1
        MOV AH,2
        INT 10H
        MOV AX,2
        INT 33H
        MOV AX,95FH
        INT 10H
        MOV AX,1
        INT 33H
HILITEM1:
        POP DX
        MOV AH,2
        INT 10H
        POP DX
        POP CX
        POP BX
        POP AX
        RET
HILITE_MOUSE ENDP

KEYMOUSE PROC NEAR      ;Scan keyboard and mouse for options
        MOV HILITE_LINE,-1
        CMP MOUSE_HERE,0
        JNZ KEYMOUSE1   ;If no mouse present, just wait for a key
        MOV AH,0
        INT 16H
        RET
KEYMOUSE1:
        MOV AX,1        ;else, turn on mouse pointer
        INT 33H
KEYMOUSE2:
        MOV AH,1
        INT 16H
        JZ KEYMOUSE3
        MOV AX,2        ;If key pressed, turn off pointer
        INT 33H
        CALL HILITE_MOUSE ;remove highlight
        MOV HILITE_LINE,-1
        MOV AH,0        ;and retrieve key
        INT 16H
        RET
KEYMOUSE3:              ;Test mouse
        MOV AX,3
        INT 33H
        TEST BL,2       ;Right button is always ESC key
        JZ KEYMOUSE4
        MOV BYTE PTR HILITE_CMD,27
        JMP KEYMOUSE5
KEYMOUSE4:
        SHR CX,1        ;Calculate character coordinate of mouse
        SHR CX,1
        SHR CX,1
        SHR DX,1
        SHR DX,1
        SHR DX,1
        MOV AL,HILITE_LINE
        AND AL,127
        CMP DL,AL
        JNZ KEYMOUSE6   ;Check to make sure we are in last highlighted zone
        CMP CL,BYTE PTR HILITE_COL
        JB KEYMOUSE6
        CMP CL,BYTE PTR HILITE_COL[1]
        JA KEYMOUSE6
        TEST BL,1
        JZ KEYMOUSE2
KEYMOUSE5:              ;If a key pressed, wait for it to be released
        CMP HILITE_LINE,-1
        JL KEYMOUSE5A   ;Unless HILITE_LINE has bit 7 set and is not -1.
        PUSH CX
        MOV AX,3
        INT 33H
        POP CX
        TEST BL,3
        JNZ KEYMOUSE5
KEYMOUSE5A:
        CALL HILITE_MOUSE ;Remove highlight on current line
        MOV HILITE_LINE,-1
        MOV AX,2        ;Turn off mouse pointer
        INT 33H
        MOV AL,HILITE_CMD
        RET             ;Return selected key    
KEYMOUSE6:              ;Pointer moved
        CALL HILITE_MOUSE ;Shut off current highlighted zone
        MOV HILITE_LINE,-1
        MOV SI,BP       ;Scan mouse-to-key translations
KEYMOUSE7:
        CMP BYTE PTR [SI],-1
        JZ KEYMOUSE2A   ;None found, resume scan
        MOV AL,[SI]     ;If correct row
        AND AL,127
        CMP DL,AL
        JNZ KEYMOUSE8
        CMP CL,[SI+1]
        JB KEYMOUSE8    ;and within column margins
        CMP CL,[SI+2]
        JA KEYMOUSE8
        MOV AX,[SI]     ;then copy into highlight fields
        MOV WORD PTR HILITE_LINE,AX
        MOV AX,[SI+2]
        MOV WORD PTR HILITE_COL[1],AX
        CALL HILITE_MOUSE ;and highlight it
KEYMOUSE2A:
        JMP KEYMOUSE2
KEYMOUSE8:
        ADD SI,4
        JMP KEYMOUSE7
KEYMOUSE ENDP

;Virtual disk menu mouse command table
;(Format: row,start_column,end_column,ASCII_key)
VDM_MOUSE DB 24,72,79,'D'       ;Lower right-hand corner is "D"
        DB 4,10,14,')'          ;SHIFT-0
        DB 5,10,14,'!'          ;SHIFT-1
        DB 6,10,14,'@'          ;SHIFT-2
        DB 7,10,14,'#'          ;SHIFT-3
        DB 4,16,23,'0'          ;"0"
        DB 5,16,23,'1'          ;"1"
        DB 6,16,23,'2'          ;"2"
        DB 7,16,23,'3'          ;"3"
        DB 5,26,54,13           ;ENTER
        DB 6,26,54,'R'          ;"R"
        DB 7,26,54,'Q'          ;"Q"
        DB -1

;Quit option of Virtual Disk Menu
VDM_QUIT_MOUSE DB 7,37,38,'Y'   ;"Y"
        DB 7,40,41,'N'          ;"N"
        DB -1

DIR_TOP DW 0
DIR_BOTTOM DW 0
DIR_NEXT DW 0

;Options while waiting for new snapshot name
SN_MOUSE DB 5,18,25,13          ;"ENTER" if on field, also includes below...
;Options while waiting for new virtual disk name
VDN_MOUSE DB 4,26,48,177        ;"`D' for Directory" zone
        DB 0,0,7,128
        DB 1,0,7,129
        DB 2,0,7,130
        DB 3,0,7,131
        DB 4,0,7,132
        DB 5,0,7,133
        DB 6,0,7,134
        DB 7,0,7,135
        DB 8,0,7,136
        DB 9,0,7,137
        DB 10,0,7,138
        DB 11,0,7,139
        DB 12,0,7,140
        DB 13,0,7,141
        DB 14,0,7,142
        DB 15,0,7,143
        DB 16,0,7,144
        DB 17,0,7,145
        DB 18,0,7,146
        DB 19,0,7,147
        DB 20,0,7,148
        DB 21,0,7,149
        DB 22,0,7,150
        DB 23,0,7,151
        DB 24,0,7,152
        DB 0,72,79,153
        DB 1,72,79,154
        DB 2,72,79,155
        DB 3,72,79,156
        DB 4,72,79,157
        DB 5,72,79,158
        DB 6,72,79,159
        DB 7,72,79,160
        DB 8,72,79,161
        DB 9,72,79,162
        DB 10,72,79,163
        DB 11,72,79,164
        DB 12,72,79,165
        DB 13,72,79,166
        DB 14,72,79,167
        DB 15,72,79,168
        DB 16,72,79,179
        DB 17,72,79,170
        DB 18,72,79,171
        DB 19,72,79,172
        DB 20,72,79,173
        DB 21,72,79,174
        DB 22,72,79,175
        DB 23,72,79,176
        DB 24,72,79,177
        DB -1

DIR     PROC NEAR       ;Create a dir. listing for search key in DX
        PUSH BP
        MOV BP,DX       ;and show first 49 files
        PUSH ES
        MOV AX,DS
        MOV ES,AX
        MOV AH,1AH
        MOV DX,OFFSET DTA
        INT 21H
        MOV DIR_TOP,0
        MOV BX,OFFSET PC_DIR    ;BX will contain current end of table
        MOV DX,BP
        MOV AH,11H
        INT 21H
        MOV DX,0
DIR1:   CMP AL,255
        JZ DIR4
        MOV DI,OFFSET PC_DIR-8  ;Search table for entry's pos. alphabetically
        MOV SI,OFFSET DTA+1
DIR2:   MOV CX,8
        ADD DI,CX
        CMP DI,BX               ;If at end of list add entry there
        JZ DIR3
        PUSH SI
        PUSH DI
        REPZ CMPSB
        POP DI
        POP SI
        JNB DIR2
        PUSH DI
        MOV CX,BX               ;Calculate number of bytes to move
        SUB CX,DI
        MOV SI,BX
        DEC SI
        MOV DI,SI               ;Move table after entry 8 bytes to create a
        ADD DI,8                ;blank
        STD
        REP MOVSB
        CLD
        POP DI
DIR3:   MOV SI,OFFSET DTA+1     ;Move entry into table
        MOV CX,8
        REP MOVSB
        MOV DX,BP
        MOV AH,12H
        INT 21H
        ADD BX,8
        CMP BX,OFFSET PC_DIR+4000 ;500 8-byte entries maximum
        JB DIR1
DIR4:   POP ES
        POP BP
        MOV DIR_BOTTOM,BX
        RET
DIR     ENDP

SHOW_DIR PROC NEAR              ;Show directory entries starting with DIR_TOP
        CMP DIR_TOP,-1          ;Read a new directory if necessary
        JNZ SHOW_DIR0
        CALL DIR
SHOW_DIR0:
        MOV DI,OFFSET MSG4
        MOV DL,0                ;Clear margins
        CALL COL
        MOV DI,OFFSET MSG4
        MOV DL,72
        CALL COL
        MOV DX,0
SHOW_DIR1:                      ;Calculate offset in PC_DIR
        PUSH DX
        MOV AX,8
        MUL DIR_TOP
        ADD AX,OFFSET PC_DIR
        MOV SI,AX
        POP DX
SHOW_DIR2:                      ;Display names, stop when DIR_BOTTOM reached
        CMP SI,DIR_BOTTOM
        JZ SHOW_DIR4
        MOV AH,2
        MOV BH,0
        INT 10H
        PUSH DX
        MOV CX,8
SHOW_DIR3:
        MOV DL,[SI]
        INC SI
        MOV AH,2
        INT 21H
        LOOP SHOW_DIR3
        POP DX
        INC DH
        CMP DH,24               ;Always 24 lines available
        JB SHOW_DIR2
        CMP DX,1800H            ;25th line also available in left column
        JZ SHOW_DIR2
        CMP DL,72               ;If not in right column go to top of it
        MOV DX,72
        JNZ SHOW_DIR2
        MOV SI,OFFSET MSG9
        MOV CX,8
        MOV DX,1848H
SHOW_MORE:
        MOV AH,2                ;Otherwise, there is "(more)"
        MOV BH,0
        PUSH SI
        INT 10H
        POP SI
        LODSB
        PUSH SI
        PUSH CX
        MOV AH,9
        MOV BX,1
        MOV CX,1
        INT 10H
        POP CX
        POP SI
        INC DL
        LOOP SHOW_MORE
        MOV AX,DIR_TOP          ;Set NEXT pointer to next file to display
        ADD AX,49
        MOV DIR_NEXT,AX
        RET
SHOW_DIR4:
        MOV DIR_NEXT,0          ;If end reached, reset NEXT pointer
        RET
SHOW_DIR ENDP

MENU_ENTRY PROC NEAR            ;Routine to initialise system for menus
    call resetbranch
    MOV DIR_TOP,-1              ;Reset directory listings
    MOV DIR_NEXT,-1
    MOV TIMER,128               ;Shut off time clock interrupt
    AND BYTE PTR SYSSTAT,143 ;Turn off break, single step, and mem display
    MOV BYTE PTR LASTSCAN,0
    MOV AX,2509H        ;Restore normal keyboard
    MOV BYTE PTR LASTOPT,0
    PUSH DS
    MOV DX,OLDLOW
    MOV DS,OLDHI
    INT 21H
    POP DS
    MOV AH,3EH  ;Close current virtual drive
    MOV BX,HANDLE
    INT 21H
    MOV HANDLE,-1
    PUSH ES ;Roll back counter to convince disk manager that file has timed
    MOV AX,64 ;out
    MOV ES,AX
    MOV ax,ES:[6CH]
    sub ah,4
    AND BYTE PTR ES:[17H],251   ;Reset CTRL key bit in case it got stuck
    POP ES
    MOV LASTDSK,AX
FLUSH2:  MOV AH,1
    INT 16H
    JZ FLUSH0
    MOV AH,0
    INT 16H
    JMP FLUSH2
FLUSH0:
        MOV CTRL_KEY,9DH        ;Clear CTRL key flag in KEYDMA
        MOV DI,OFFSET MSG26     ;Clear margin message if possible
        CALL NOTE
        MOV MARGIN,0
        MOV DI,3800H            ;Clear TRS-80's keyboard map
        MOV CX,200H
        MOV AX,0
        REP STOSW
        MOV WORD PTR KEY_MATRIX,0
        MOV WORD PTR KEY_MATRIX[2],0
        MOV WORD PTR KEY_MATRIX[4],0
        MOV WORD PTR KEY_MATRIX[6],0
        MOV SHIFT_STATE,0
        RET
MENU_ENTRY ENDP

NEWFILE: ;Virtual disk menu entry point
        CALL MENU_ENTRY
        MOV DX,OFFSET SEARCH
        CALL SHOW_DIR
FLUSH3: 
    MOV SI,OFFSET MSG7
    MOV DX,8
    MOV BX,0A39H
    CALL SHOW_MENU
    MOV SI,OFFSET DRIVES
    MOV DX,410H
NEWFILE2: MOV AH,2      ;Display current file names
    MOV BH,0
    INT 10H
    MOV AH,10
    MOV CX,1
    MOV BX,1
    MOV AL,CS:[SI]
    INC SI
    INT 10H
    INC DL
    CMP DL,24
    JB NEWFILE2
    MOV DL,16
    INC DH
    CMP DH,8
    JB NEWFILE2
    mov al,switches
    mov cx,4
    mov dx,80Bh
chprot1:
    dec dh
    push ax
    mov ah,2
    int 10h
    pop ax
    rol al,1
    push ax
    push cx
    jnb chprot2
    mov ax,9dbh
    mov bx,129
    mov cx,3
    int 10h
chprot2:
    pop cx
    pop ax
    loop chprot1
    JMP NEWFILE3
NEWFILE4:
        JMP VIRCAS4
NEWFILE3: ;Keyscan
    PUSH BP
    MOV BP,OFFSET VDM_MOUSE
    CALL KEYMOUSE
    POP BP
    CMP AX,3C00H
    JZ NEWFILE4
    CMP AL,13
    JZ NEWFILE4
    cmp al,27
    jz newfile4
    MOV AH,AL
    AND AL,223
    CMP AL,'D'
    JNZ NEWFILE10
    MOV AX,DIR_NEXT
    MOV DIR_TOP,AX
    MOV DX,OFFSET SEARCH
    CALL SHOW_DIR
    JMP NEWFILE3
NEWFILE10:
    CMP AL,'R'
    JZ NEWFILE6
    CMP AL,'Q'
    JNZ NEWFILE9A
    jmp newfile9
newfile9a:
    cmp ah,')'
    mov al,16
    jz chprot
    cmp ah,'!'
    mov al,32
    jz chprot
    cmp ah,'@'
    mov al,64
    jz chprot
    cmp ah,'#'
    mov al,128
    jz chprot
    CMP AH,'0'
    JB NEWFILE3
    CMP AH,'4'
    JNB NEWFILE3
    JMP NEWFILE13
chprot: xor switches,al ;Change write protect status 
    mov dx,80Bh
chprot0:
    dec dh
    rol al,1
    jnb chprot0
    jmp FLUSH3
NEWFILE6: MOV BP,66H  ;Reset
    mov timer,0
    mov intdma,3fh
    MOV STATUS,80H
    AND byte ptr SYSSTAT,240
    MOV BP,66H
    JMP VIRCAS4
NEWFILE9: ;Quit, with confirmation
    MOV DX,71BH
    MOV AH,2
    MOV BH,0
    INT 10H
    MOV AH,9
    MOV CX,9
    MOV AL,219
    MOV BL,81H
    INT 10H
    MOV DX,724H
    MOV AH,2
    MOV BH,0
    INT 10H
    MOV AX,0E2CH
    MOV BL,1
    INT 10H
    MOV AL,' '
    INT 10H
    MOV AL,'Y'
    INT 10H
    MOV AL,'/'
    INT 10H
    MOV AL,'N'
    INT 10H
    MOV AL,'?'
    INT 10H
QUIT1A: PUSH BP
        MOV BP,OFFSET VDM_QUIT_MOUSE
        CALL KEYMOUSE
        POP BP
        CMP AL,27
        JZ QUIT1C
        AND AL,223
    CMP AL,'Y'
    JZ QUIT2A
    CMP AL,'N'
    JNZ QUIT1A
QUIT1C:
    JMP FLUSH3
QUIT2A: JMP QUIT2
NEWFILE13: ;Change virtual drive
        SUB AH,'0'
        MOV DH,AH
        ADD DH,4
        ADD AH,AH
        ADD AH,AH
        ADD AH,AH
        MOV BL,AH
        MOV BH,0
        PUSH BX
        MOV DL,16
        MOV AH,2
        MOV BX,1
        INT 10H
        MOV AX,0920H ;Clear old displayed field
        MOV CX,8
        INT 10H
        MOV SI,OFFSET NEWNAME
        MOV WORD PTR [SI],2020H
        MOV WORD PTR [SI+2],2020H
        MOV WORD PTR [SI+4],2020H
        MOV WORD PTR [SI+6],2020H
        JMP NEWFILE14
NEWFILE11:              ;The mouse has selected a file from the directory
        CMP AL,177      ;This code indicates the lower, right-hand "(more)"
        JNZ NEWFILE12   ;zone or "`D' for Directory" zone
        PUSH SI
        PUSH DX
        PUSH BP
        MOV AX,DIR_NEXT
        MOV DIR_TOP,AX
        MOV DX,OFFSET SEARCH
        CALL SHOW_DIR
        POP BP
        POP DX
        POP SI
        JMP NEWFILE14
NEWFILE12:
        CMP DIR_TOP,-1  ;If no directory displayed, ignore it
        JZ NEWFILE14
        AND AX,127      ;Otherwise, it's a potential file name.
        ADD AX,DIR_TOP  ;Calculate its position
        PUSH DX
        MOV DX,8
        MUL DX
        POP DX
        ADD AX,OFFSET PC_DIR
        CMP AX,DIR_BOTTOM ;If past end of directory, forget it
        JNB NEWFILE14
        PUSH ES
        MOV SI,AX       ;Otherwise move name into "NEWNAME" field
        MOV AX,DS
        MOV ES,AX
        MOV DI,OFFSET NEWNAME
        MOV CX,8
        REP MOVSB
        POP ES
        JMP NEWFILE15   ;and pretend ENTER was pressed
NEWFILE14: 
        MOV AH,2
        MOV BX,1
        INT 10H
        MOV AX,9DBH
        MOV CX,1
        INT 10H
        PUSH DX
        PUSH SI
        PUSH BP
        MOV BP,OFFSET VDN_MOUSE
        CALL KEYMOUSE
        POP BP
        POP SI
        POP DX
        CMP AL,13
        JZ NEWFILE15
        CMP AL,27
        JZ NEWFILE16
        CMP AL,128
        JNB NEWFILE11
        CMP AL,8
        JNZ NEWFILE17
        CMP SI,OFFSET NEWNAME
        JZ NEWFILE14
        DEC SI
        MOV BYTE PTR [SI],20H
        MOV AH,2
        MOV BL,1
        DEC DL
        INT 10H
        MOV AX,920H
        MOV CX,2
        INT 10H
        JMP NEWFILE14
NEWFILE17:
        CMP AL,33
        JB NEWFILE14
        CMP SI,OFFSET NEWNAME+8
        JNB NEWFILE14
        MOV [SI],AL
        INC SI
        MOV AH,9
        MOV BX,1
        MOV CX,1
        INT 10H
        INC DL
        JMP NEWFILE14
NEWFILE15:
        MOV SI,OFFSET NEWNAME
        POP BX
NEWFILE18:
        MOV AL,[SI]
        MOV DRIVES[BX],AL
        INC BX
        INC SI
        CMP SI,OFFSET NEWNAME+8
        JB NEWFILE18
        JMP FLUSH3
NEWFILE16:
        POP BX
        JMP FLUSH3

;Snapshot menu mouse translations
SM_MOUSE DB 3,17,17,'-' 
        DB 3,18,49,128  ;This byte indicates mouse on speed slider
        DB 3,50,50,'+'
        DB -1
    
SHOW_MENU PROC NEAR     ;Display menu with upper-left at DX, lower-right at BX
        PUSH DX
SHOW_MENU1:
        MOV AH,2      ;Display pop-up window
        PUSH BX
        MOV BH,0
        INT 10H
        MOV AH,10
        MOV CX,1
        MOV BL,1
        MOV AL,CS:[SI]
        INC SI
        INT 10H
        INC DL
        POP BX
        CMP DL,BL
        JB SHOW_MENU1
        POP DX
        INC DH
        PUSH DX
        CMP DH,BH
        JB SHOW_MENU1
        POP DX
        RET
SHOW_MENU ENDP

REFRESH_SCREEN PROC NEAR        ;Redraws screen
    PUSH DS
    MOV AX,0B800H
    MOV DS,AX
    MOV BX,0
VIRCAS7:
    MOV BYTE PTR [BX],0
    MOV BYTE PTR [BX+2000H],0
    INC BX
    CMP BX,160
    JB VIRCAS7
    POP DS
    MOV DI,3C00H    
VIRCAS5:
    MOV AL,ES:[DI]
    CALL PUTBYTE
    INC DI
    CMP DI,4000H
    JB VIRCAS5
    RET
REFRESH_SCREEN ENDP

vircas: ;Snapshot menu entry point (mislabelled "VIRtual CASsette")
        CALL MENU_ENTRY
VIRCAS1:    
    MOV SI,OFFSET MSG8
    MOV DX,8
    MOV BX,635H         ;Right-hand corner
        CALL SHOW_MENU
    call slider
    JMP VIRCAS3
MOUSE_SLIDER:           ;Calculate mouse position on slider
        MOV AL,49
        SUB AL,CL
        CMP AL,32       ;Safeguard against somebody trying ALT-128
        JA VIRCAS3
        MOV AH,4
        MUL AH
        INC AX
        MOV DELAY,AX
        CALL RESETBRANCH
        CALL SLIDER
        JMP VIRCAS3
slower: cmp delay,128
    jnb vircas3
    add delay,4
    call resetbranch
    call slider
    jmp vircas3
faster: cmp delay,5
    jb vircas3
    sub delay,4
    call slider
VIRCAS3: ;Keyscan
    PUSH BP
    MOV BP,OFFSET SM_MOUSE
    CALL KEYMOUSE
    POP BP
    CMP AX,3D00H
    JZ VIRCAS4
    CMP AL,13
    JZ VIRCAS4
    CMP AL,27
    JZ VIRCAS4
    cmp al,'+'
    jz faster
    cmp al,'-'
    jz slower
    CMP AL,128
    JZ MOUSE_SLIDER
    jmp vircas3
VIRCAS4:   ;Return, restore emulated screen
    CALL REFRESH_SCREEN
    CALL CASSETTE_OPEN
    jmp cont2

;Virtual cassette menu mouse translations
VCM_MOUSE DB 3,10,23,'N'
        DB 3,33,49,'N'
        DB 4,10,23,'M'
        DB 4,33,49,'M'
        DB 5,33,49,'S'
        DB 86H,33,49,'-'        ;Because mouse is so fast, "R" and "F" are
        DB 87H,33,49,'+'        ;linked to "-" and "+" for mouse
        DB 8,33,49,'E'
        DB 9,33,49,13
        DB 8,11,13,'-'
        DB 8,20,22,'+'
        DB -1

LAST_POS DW 0                   ;Last displayed position of tape counter

SHOW_COUNTER PROC NEAR          ;Display file position of currently open
        CMP CHANDLE,-1
        MOV AX,0
        JZ SHOWC1
        MOV AX,4201H            ;Move pointer by offset 0 and find result
        MOV BX,CHANDLE
        MOV CX,0
        MOV DX,0
        INT 21H
SHOWC1: MOV DX,813H
        MOV LAST_POS,AX
SHOWC2: PUSH DX                 ;Convert AX to decimal and display
        PUSH AX
        MOV AH,2
        INT 10H
        POP AX
        MOV DX,0
        MOV BX,10
        DIV BX
        PUSH AX
        MOV AL,DL
        OR AL,30H
        MOV AH,9
        MOV BX,1
        MOV CX,1
        INT 10H
        POP AX
        POP DX
        DEC DL
        CMP DL,14
        JNB SHOWC2
        RET
SHOW_COUNTER ENDP

TAPE:   CALL MENU_ENTRY         ;Virtual Cassette Menu
        MOV DX,OFFSET TSEARCH
        CALL SHOW_DIR
TAPE1:  MOV SI,OFFSET MSG10
        MOV DX,8
        MOV BX,0C35H            ;Right-hand corner
        CALL SHOW_MENU
        MOV SI,OFFSET CAS_NAME  ;Display current virtual cassette name
        MOV DX,0310H
        MOV BX,1
TAPE2:  LODSB
        CMP AL,'.'
        JZ TAPE3
        CMP AL,0
        JZ TAPE3
        MOV AH,2
        INT 10H
        MOV AH,9
        MOV CX,1
        INT 10H
        INC DL
        CMP DL,24
        JB TAPE2
TAPE3:  MOV AH,2                ;Display current mode
        MOV DX,410H
        INT 10H
        MOV AH,9
        MOV DX,OFFSET MSG11A
        CMP BYTE PTR CAS_PLAYREC,'R'
        JNZ TAPE4
        MOV DX,OFFSET MSG11B
TAPE4:  INT 21H
        CALL SHOW_COUNTER
TAPE5:  PUSH BP
        MOV BP,OFFSET VCM_MOUSE
        CALL KEYMOUSE
        POP BP
        CMP AL,27               ;If ESC...
        JZ TAPE6
        CMP AL,13               ;ENTER...
        JZ TAPE6
        CMP AX,3E00H            ;or F4...
        JNZ TAPE7
TAPE6:  JMP VIRCAS4             ;then remove menu and resume emulation
TAPE7:  CMP AL,'a'
        JB TAPE7A
        CMP AL,'z'
        JA TAPE7A
        AND AL,223
TAPE7A: CMP AL,'D'
        JNZ TAPE8
        MOV AX,DIR_NEXT         ;Directory
        MOV DIR_TOP,AX
        MOV DX,OFFSET TSEARCH
        CALL SHOW_DIR
        JMP TAPE5
TAPE8:  CMP AL,'M'              ;Mode
        JNZ TAPE9
        CALL CASSETTE_CLIP
        CMP CAS_PLAYREC,'P'
        MOV CAS_PLAYREC,'R'
        JZ TAPE3
        MOV CAS_PLAYREC,'P'
        JMP TAPE3
TAPE15A:
        JMP TAPE15
TAPE9:  MOV BX,CHANDLE          ;Tape positioning works only if something
        CMP BX,-1               ;is open
        JZ TAPE15A
        CMP AL,'S'
        JNZ TAPE10
        CALL CASSETTE_CLIP
TAPE9A: MOV AX,4200H            ;Start
        MOV CX,0
        MOV DX,CX
        INT 21H
        CALL SHOW_COUNTER
        JMP TAPE5
TAPE10: CMP AL,'E'
        JNZ TAPE11
        CALL CASSETTE_CLIP
        MOV AX,4202H            ;End
        MOV CX,0
        MOV DX,CX
        INT 21H
        CALL SHOW_COUNTER
        JMP TAPE5
TAPE11: CMP AL,'R'
        JNZ TAPE12
        CALL CASSETTE_CLIP
        MOV DX,LAST_POS         ;Rewind
        SUB DX,64
        JB TAPE9A
        MOV CX,0
        MOV AX,4200H
        INT 21H
        CALL SHOW_COUNTER
        JMP TAPE5
TAPE12: CMP AL,'F'
        JNZ TAPE13
        CALL CASSETTE_CLIP
        MOV AX,4202H            ;Fast forward
        MOV CX,0
        MOV DX,0
        INT 21H
        MOV DX,64
TAPE12A:
        ADD DX,LAST_POS
        CMP DX,AX
        JNB TAPE12B
        MOV CX,0
        MOV AX,4200H
        INT 21H
TAPE12B:
        CALL SHOW_COUNTER
        JMP TAPE5
TAPE13: CMP AL,'+'
        JNZ TAPE14
        CALL CASSETTE_CLIP
        MOV AX,4202H            ;Increment
        MOV CX,0
        MOV DX,0
        INT 21H
        MOV DX,1
        JMP TAPE12A
TAPE14: CMP AL,'-'
        JNZ TAPE15
        CALL CASSETTE_CLIP
        MOV DX,LAST_POS         ;Decrement
        CMP DX,0
        JZ TAPE15
        DEC DX
        MOV CX,0
        MOV AX,4200H
        INT 21H
        CALL SHOW_COUNTER
        JMP TAPE5
TAPE15: CMP AL,'N'
        JNZ TAPE17
        CALL CASSETTE_CLIP
        CALL TAPE_NAME
        JNZ TAPE16
        CALL CASSETTE_CLOSE
        MOV SI,OFFSET CAS_TEMP
        MOV DI,OFFSET CAS_NAME
        MOV CX,13
        PUSH ES
        MOV AX,DS
        MOV ES,AX
        REP MOVSB
        POP ES
        CALL CASSETTE_OPEN
        MOV CAS_PLAYREC,'P'     ;Default to playback
        CMP CHANDLE,-1
        JNZ TAPE16
        MOV CAS_PLAYREC,'R'     ;Default to record if opening a new file
        MOV AH,3CH              ;If file couldn't be opened, try creating it
        MOV CX,0
        MOV DX,OFFSET CAS_NAME
        INT 21H
        MOV CHANDLE,AX
        JNB TAPE16
        MOV CHANDLE,-1          ;Otherwise...
        MOV BYTE PTR CAS_NAME,'.'
        MOV AH,2                ;Beep and clear field if virtual cassette
        MOV DL,7                ;name bad
        INT 21H
TAPE16: JMP TAPE1
TAPE17: JMP TAPE5

TAPE_KEYMOUSE PROC NEAR
        PUSH BP                 ;Get key pressed for tape name input
        PUSH SI
        PUSH DX
        MOV BP,OFFSET SN_MOUSE
        MOV BYTE PTR DS:[BP],3
        MOV WORD PTR DS:[BP+1],1710H
        MOV BYTE PTR VDN_MOUSE,5
        MOV WORD PTR VDN_MOUSE[1],3121H
        CALL KEYMOUSE
        MOV BYTE PTR DS:[BP],5
        MOV WORD PTR DS:[BP+1],1912H
        MOV BYTE PTR VDN_MOUSE,4
        MOV WORD PTR VDN_MOUSE[1],301AH
        POP DX
        POP SI
        POP BP
        RET
TAPE_KEYMOUSE ENDP

CAS_TEMP DB 13 DUP(?)
TAPE_NAME PROC NEAR             ;Get name of virtual cassette
        MOV SI,OFFSET CAS_NAME
        MOV DI,OFFSET CAS_TEMP
        MOV CX,13
        PUSH ES
        MOV AX,DS
        MOV ES,AX
        REP MOVSB
        POP ES
        MOV AH,2
        MOV BH,0
        MOV DX,310H
        INT 10H
        MOV AH,9                ;Highlight current name
        MOV BX,87H
        MOV CX,8
        MOV AL,219
        INT 10H
        CALL TAPE_KEYMOUSE
        CMP AL,13               ;Return if ENTER pressed
        JNZ TAPNAM2
        XOR AL,AL
TAPNAM1:                        ;Z=accept, NZ=cancel on return
        OR AL,AL
        RET
TAPNAM2:
        CMP AL,27               ;Return if ESC pressed
        JZ TAPNAM1
        PUSH AX                 ;Any other key means replace file name  
        MOV DX,310H
        MOV AH,2
        MOV BX,1
        INT 10H
        MOV AX,0920H            ;Clear old displayed field
        MOV CX,8
        INT 10H
        MOV SI,OFFSET CAS_TEMP
        MOV WORD PTR [SI],2020H
        MOV WORD PTR [SI+2],2020H
        MOV WORD PTR [SI+4],2020H
        MOV WORD PTR [SI+6],2020H
        POP AX
        JMP TAPNAM3             ;Skip to interpret first key pressed
TAPNAM14: 
        MOV AH,2                ;Display cursor
        MOV BX,1
        INT 10H
        MOV AX,9DBH
        MOV CX,1
        INT 10H
        CALL TAPE_KEYMOUSE      ;Read key
        CMP AL,13
        JZ TAPNAM4A
        CMP AL,27
        JZ TAPNAM1
        JMP TAPNAM3
TAPNAM4A:
        JMP TAPNAM4
TAPNAM11:                       ;Mouse "directory" zone
        CMP AL,177
        JNZ TAPNAM12
        PUSH DX
        PUSH SI
        PUSH BP
        MOV AX,DIR_NEXT
        MOV DIR_TOP,AX
        MOV DX,OFFSET TSEARCH
        CALL SHOW_DIR
        POP BP
        POP SI
        POP DX
        JMP TAPNAM14
TAPNAM12:                       ;If in file zone, make sure there is a dir.
        CMP DIR_TOP,-1
        JZ TAPNAM14
        AND AX,127
        ADD AX,DIR_TOP
        PUSH DX
        MOV DX,8
        MUL DX
        POP DX
        ADD AX,OFFSET PC_DIR
        CMP AX,DIR_BOTTOM
        JNB TAPNAM14            ;Make sure not beyond end of list
        MOV SI,AX
        MOV DI,OFFSET CAS_TEMP
        MOV CX,8
        PUSH ES
        MOV AX,DS
        MOV ES,AX
        REP MOVSB
        POP ES
        JMP TAPNAM4
TAPNAM3:                        ;Check for BACKSPACE
        CMP AL,128
        JNB TAPNAM11
        CMP AL,8
        JNZ TAPNAM17
        CMP SI,OFFSET CAS_TEMP
        JZ TAPNAM14A
        DEC SI
        MOV BYTE PTR [SI],20H
        MOV AH,2
        MOV BL,1
        DEC DL
        INT 10H
        MOV AX,920H
        MOV CX,2
        INT 10H
TAPNAM14A:
        JMP TAPNAM14
TAPNAM17:               ;Ignore all other control codes and SPACE bar
        CMP AL,33
        JB TAPNAM14A
        CMP SI,OFFSET CAS_TEMP+8
        JNB TAPNAM14A   ;Maximum 8 characters
        MOV [SI],AL
        INC SI
        MOV AH,9
        MOV BX,1
        MOV CX,1
        INT 10H
        INC DL
        JMP TAPNAM14
TAPNAM4:                ;Tag on ".CAS" if return pressed
        MOV SI,OFFSET CAS_TEMP
TAPNAM5:
        MOV AL,[SI]
        CMP AL,' '
        JZ TAPNAM6
        INC SI
        CMP SI,OFFSET CAS_TEMP+8
        JB TAPNAM5
TAPNAM6:
        MOV WORD PTR [SI],432EH
        MOV WORD PTR [SI+2],5341H
        MOV BYTE PTR [SI+4],0
        XOR AL,AL
        RET
TAPE_NAME ENDP

HELP_MOUSE DB 5,10,23,'C'
        DB 6,10,23,'C'
        DB 7,10,23,'P'
        DB 8,10,23,'P'
        DB 9,10,23,'T'
        DB 10,10,23,'T'
        DB 11,10,23,'K'
        DB 12,10,23,'K'
        DB 5,27,56,128
        DB 6,27,56,163
        DB 7,27,56,129
        DB 8,27,56,130
        DB 9,27,56,131
        DB 10,27,56,133
        DB 11,27,56,134
        DB 15,36,45,'Q'
        DB -1

HELP_QUIT_MOUSE DB 15,46,47,'Y'
        DB 15,49,50,'N'
        DB -1

HELP_FKEYS DW VIRCAS4
        DW NEWFILE
        DW VIRCAS
        DW TAPE
        DW HELP1
        DW DEBUG
        DW HELP10
        
HELP:   CMP BYTE PTR MOUSE_HERE,0
        JZ HELP0
        MOV AX,3                ;If there is a mouse, make sure right button
        INT 33H                 ;released before displaying a menu
        TEST BL,2
        JNZ HELP
HELP0:  CALL MENU_ENTRY         ;Help screen
        MOV SI,OFFSET MSG12
        MOV DX,8
        MOV BX,123CH
        CALL SHOW_MENU
HELP1:  MOV AL,SWITCHES         ;Display current settings
        MOV CX,7
        MOV SI,OFFSET MSG13
        MOV DX,60CH
HELP2:  MOV BX,WORD PTR CYCLES
        AND BX,3
        SHL BX,1
        SHL BX,1
        SHL BX,1
        CMP CX,3
        JZ HELP3
        JNB HELP2A
        CMP CX,1
        JA HELP2B
        MOV BL,KEY_MODE
        AND BX,1
        SHL BX,1
        SHL BX,1
        SHL BX,1
        JMP HELP3
HELP2B: ADD SI,16
        MOV BX,0
        MOV AL,SWITCHES2
        JZ HELP3
        MOV BX,8
        JMP HELP3
HELP2A: ROR AL,1
        MOV BX,0
        JNB HELP3
        MOV BX,8
HELP3:  PUSH AX
        PUSH CX
        TEST CL,1
        JZ HELP_SKIPPED
HELP4:  MOV AH,2
        INT 10H
        MOV AL,[SI+BX]
        INC BX
        PUSH BX
        MOV AH,9
        MOV BX,1
        MOV CX,BX
        INT 10H
        POP BX
        INC DL
        TEST BL,7
        JNZ HELP4
        SUB DL,8
        ADD DH,2
HELP_SKIPPED:
        ADD SI,16
        POP CX
        POP AX
        LOOP HELP2
        MOV AH,2
        MOV DX,0A2EH
        INT 10H
HELP4A: PUSH BP
        MOV BP,OFFSET HELP_MOUSE
        CALL KEYMOUSE
        POP BP
        CMP AL,0
        JNZ HELP5
        MOV AL,AH               ;Translate function key scancodes to mouse
        ADD AL,69               ;codes
HELP5:  CMP AL,'a'
        JB HELP6
        CMP AL,'z'
        JA HELP6
        AND AL,223
HELP6:  CMP AL,27
        JNZ HELP7
        JMP VIRCAS4
HELP6A: XOR BYTE PTR SWITCHES2,2
        JMP HELP1
HELP7:  CMP AL,128
        JB HELP8
        CMP AL,132
        JZ HELP6A
        CMP AL,134
        JZ HELP10
        CMP AL,135
        JA HELP8
        AND AX,15
        ADD AX,AX
        MOV SI,AX
        PUSH SI
        CALL REFRESH_SCREEN
        POP SI
        JMP HELP_FKEYS[SI]
HELP8:  
HELP9:  CMP AL,'K'
        JNZ HELP10B
HELP10: INC BYTE PTR KEY_MODE
        AND BYTE PTR KEY_MODE,1
HELP10A:
        JMP HELP1
HELP10B:
HELP12: CMP AL,'P'
        JNZ HELP13
        XOR BYTE PTR SWITCHES,4
        JMP HELP1
HELP13: CMP AL,'T'
        JNZ HELP15
        MOV AL,CYCLES
        AND AL,127
        INC AL
        CMP AL,3
        JB HELP14
        MOV AL,0
HELP14: MOV CYCLES,AL
        JMP HELP1
HELP15: CMP AL,163
        JNZ HELP16
        PUSH ES
        MOV AX,64
        MOV ES,AX
        AND BYTE PTR ES:[23],251
        POP ES
        MOV TIMER,0
        MOV INTDMA,3FH
        MOV STATUS,80H
        AND BYTE PTR SYSSTAT,240
        MOV BP,66H
        JMP VIRCAS4
HELP16: 
HELP21: CMP AL,'C'
        JNZ HELP22
        XOR BYTE PTR SWITCHES,1
        MOV AX,3                ;Save mouse coordinate before reset
        INT 33H
        PUSH CX
        PUSH DX
        CALL COMINIT
        POP DX                  ;Restore mouse coordinate after reset
        POP CX
        MOV AX,4
        INT 33H
        PUSH ES
        MOV AX,CS
        MOV ES,AX
        MOV AX,14H              ;Add interrupt to detect right button
        MOV CX,8                ;Interrupt when right button pressed
        MOV DX,OFFSET MOUSE_SCAN
        INT 33H
        POP ES
        JMP HELP1
HELP22: CMP AL,'Q'
        JNZ HELP25
        MOV AH,2
        MOV BH,0
        MOV DX,0F24H
        INT 10H
        MOV AX,9DBH
        MOV BX,129
        MOV CX,9
        INT 10H
        MOV AH,2
        MOV BH,0
        MOV DX,0F2DH
        INT 10H
        MOV AH,9
        MOV DX,OFFSET MSG15A
        INT 21H
HELP23: PUSH BP
        MOV BP,OFFSET HELP_QUIT_MOUSE
        CALL KEYMOUSE
        POP BP
        CMP AL,27
        JZ HELP24
        AND AL,223
        CMP AL,'N'
        JZ HELP24
        CMP AL,'Y'
        JNZ HELP23
        JMP QUIT2
HELP24: JMP HELP
HELP25: JMP HELP4A

CLS     PROC NEAR
        PUSH ES
        MOV AX,0B800H
        MOV ES,AX
        MOV AH,AL
        MOV DI,AX
        MOV CX,8096
        REP STOSW
        POP ES
        RET
CLS     ENDP

;Miscellaneous text, messages, and data

TEXTFONT DB 'MODEL1.FNT',0
CONFIG DB 'MODEL1.SAV',0
ROMIMAGE DB 'ROMIMAGE',0
L1ROMIMAGE DB 'LEVEL1.ROM',0
ERRMSG DB 'Cannot load MODEL1.FNT',10,13,'$'
ERRMSG2 DB 'Cannot load ROMIMAGE',10,13,'$'

MSG1 DB 'Ŀ',' Z-80 ','      ','  BC  ','      '
     DB '  DE  ','      ','  HL  ','      ','  AF  '
     DB '      ','  SP  ','      ','  IR  ','      '
     DB '  IX  ','      ','  IY  ','      ','  PC  '
     DB '      ','      ','<    >','<    >',''
MSG3 DB 'ͻ','SELECT','Ķ','Break ','Cont. '
     DB 'Edit  ','Key   ','Load  ','Memory','Quit  '
     DB 'Reboot','Step  ','      ','      ','ͼ'
     DB 'Ŀ','  BC',39,' ','      ','  DE',39,' '
     DB '      ','  HL',39,' ','      ','  AF',39,' '
     DB '      ',''
MSG4 DB 200 DUP (32)
MSG5 DB 'Ŀ','Break@','      ','',168 DUP(32)
MSG6    db '                '
        db '                           '
        db '          (R)       '
        db '                          '
        db '                                      '
        db '                                   '
        db '                         Version 3.02u                          '
        db '                                                                '
        db '  Z-80 and architectural emulation (C) 1990-1997 Jeff Vavasour  '
        db '  (Official website at http://www.vavasour.ca/jeff/trs80.html)  '
        db ''
        db 'This package is freeware, distributed as-is without warranty or '
        db 'support, though copyright remains with the author.  Distribution'
        db 'of the TRS-80 ROMs with this package is EXPRESSLY FORBIDDEN.    '
        db ''
        db '*TRS-80 is a registered trademark of Tandy.    PRESS F1 FOR HELP'
MSG7 DB 'ͻ '
     db ' TRS-80 MODEL I EMULATOR Virtual Drives       '
     db '͹'
     db ' Drive Diskname  Select drive 0-3,           '
     db '   0             SHIFT+0-3 to write protect, '
     db '   1             ENTER to return,            '
     db '   2             R to reboot, or             '
     db '   3             Q to quit.                  '
     db 'ͼ'
     db ' '
MSG8 DB 'ͻ '
     db ' TRS-80 MODEL I EMULATOR Speed Control    '
     db '͹'
     db ' Speed: -+'
     db 'ͼ'
     db ' '
MSG9 db '(D=more)'
MSG10 DB 'ͻ '
      db ' TRS-80 MODEL I EMULATOR Virtual Cassette '
      db '͹'
      db ' Name:           Press N to change name  '
      db ' Mode:                 M to change mode  '
      db '                       S to go to start  '
      db ' Ŀ        R to rewind       '
      db ' Tape counter        F to fast forward '
      db '  - 000000 +         E to go to end    '
      db '      or ENTER to return.  '   
      db 'ͼ'
      db ' '
MSG11A DB 'PLAYBACK$'
MSG11B DB '*RECORD*$'
MSG12 DB 'ͻ '
      db ' TRS-80 MODEL I EMULATOR Setup and Help          '
      db '͹'
      db ' OPTIONS:        FUNCTION KEYS:                 '
      db 'Ķ'
      db ' Com port:       F1 to toggle help screen       '
      db '                 CTRL-F1 to reboot              '
      db ' Printer mode:   F2 for Virtual Disk Menu       '
      db '                 F3 for Speed Menu              '
      db ' Timer speed:    F4 for Virtual Tape Menu       '
      db '                 F6 for debugger                '
      db ' Key layout:     F7 to select keyboard layout   '
      db '                                                '
      db 'Ķ'
      db ' Change option by pressing its first letter,     '
      db ' select a function key, or Q to quit.            '
      db 'ͼ'
      db ' '
MSG13 DB 'COM1    COM2                    CR ONLY CR/LF                   '
      DB 'DISABLED18.2Hz  40Hz    ERROR   '
      DB '                '
      DB 'PC      TRS-80  '
MSG15A DB ', Y/N?$'
MSG15B DB '.     $'
MSG25   DB 'PC      layout  TRS-80  layout  '
MSG26   DB '                '

;System-specific configurations.  Not to be saved.

baud    dw 900h,600h,417h,359h,300h,180h,0c0h,060h,040h,03ah,030h,020h
        dw 018h,010h,00ch,006h    ;Baud rate divisor latch count for COM port
VIDPAGE DW 0B800H
VIDWIDE DW ?
OLDFL   DW ?
OLDFH   DW ?
irq3lo  dw ?
irq3hi  dw ?
irq4lo  dw ?
irq4hi  dw ?
OLDMOUSELO DW ?
OLDMOUSEHI DW ?
OLDMOUSEMASK DW ?
ctrlclo dw ?
ctrlchi dw ?
oldmask db ?
mdmmask db ?
pseudoram dw ?
HANDLE  DW -1
SEARCH  DB 0,'????????DSK                           '
TSEARCH DB 0,'????????CAS                           '
old_branch db offset main-offset branch1
ROMSWITCH DW ROMIMAGE
DRVSEL  DB 'filename.DSK',0
NEWNAME DB '        '

CHANDLE DW -1

LOOKUP  EQU $
KEY_MODE DB 0
DRIVES db 'TRSDOS  PUBLIC  '
       db '                '
cycles db 1
switches db 4 ;Bit 0 set=COM2:, 1=directories, 2=printer CR/LF, 3=green screen
CONFIG_END EQU $

wrprot db 0
LASTSCAN DB 0
CASSTAT DB 0
SYSSTAT DB 0       ;Processor/emulator flags:
    ;bit 0 = Interrupts enabled, 1 = Clock int. pending, 2 = Sector write,
    ;3 = Sector read, 4 = Debug displaying MEMMAP, 5 = Arrow keys
    ;enabled (in debug), 6 = Breakpoint enabled, 7 = Index operation
    ;(IX or IY)
NOISE   DB -1
CAS_PLAYREC DB 'P'      ;"R" for record, "P" for play
SWITCHES2 DB 2          ;Bit 1 set: Sound on, 2: SoundBlaster
CONFIG_DELAY DW 1       ;Copy of delay count saved in config
        db 3 dup(?)     ;For compatibility
CAS_NAME DB '.........CAS',0
SIDE    DB 0
STATUS  DB 128
delay  dw 1
baudset dw 30h
MDMSET  DB 03H
mdmbufptr dw 0
mdmlast dw 0
comstat dw ?
REGC    DB ?
REGB    DB ?
REGE    DB ?
REGD    DB ?
REGL    DB ?
REGH    DB ?
REGF    DB ?    ;Flag register: 76543210
                ;               SZ?H?PNC
REGA    DB ?
REGSP   DW ?
REGR    DB ?
REGI    DB ?
REGIX   DW ?
REGIY   DW ?
REGPC   DW ?
BCPRIME DW ?
DEPRIME DW ?
HLPRIME DW ?
AFPRIME DW ?
BRKPT   DW ?
MEMPAGE DW ?
LASTOPT DB ?
SECTOR  DB ?
TRACK   DB ?
SECOFF  DB ?
SECMSB  DB ?
FDCDATA DB ?
IDXHOLE DB ?
LASTDSK DW ?
intdma db 3fh
timer db ?
cache   EQU $           ;Modem cache, 1024 bytes
DTA     EQU $+1024      ;Disk Transfer Address, 512 bytes
CHARSET EQU $+1536      ;64 column character set, 3072 bytes
WIDESET EQU $+4608      ;32 column character set, 4096 bytes
vidpos  equ $+10752     ;TRS-80 to PC video address converter
PC_DIR EQU $+12800      ;Storage area for PC directory (500 files max.)
ramstart equ $+16800    ;Beginning of free memory
PROG    ENDS
    END START

