        PUBLIC FLAGS_TO_6809,FLAGS_TO_8086

VBANK0R  DW ?                    ;CoCo 32K bank 0 segment for read
VBANK0W  DW ?                    ;CoCo 32K bank 0 segment for write
VSVIDEO0 DW 0400H                ;Start address within bank of video RAM
VEVIDEO0 DW 0600H                ;End address within bank of video RAM

VROMBANK DW ?                    ;PC segment for 32K ROM
VRAMBANK DW ?                    ;PC segment for 64K RAM

;Borders, etc. for debugger screen
VFRAME   DB 84,10,82,10,83,10,45,10,56,10,48,10,32,10,67,10,79,10,76,10,79,10
        DB 85,10,82,10,32,10,67,10,79,10,77,10,80,10,85,10,84,10,69,10,82,10
        DB 32,10,51,10,32,10,69,10,77,10,85,10,76,10,65,10,84,10,79,10,82,10
        DB 32,10,32,10,32,10,32,10,32,10,32,10,32,10,32,10,32,10,32,10,32,10
        DB 32,10,32,10,32,10,32,10,32,10,54,10,56,10,48,10,57,10,32,10,77,10
        DB 111,10,110,10,105,10,116,10,111,10,114,10,32,10,97,10,110,10,100
        DB 10,32,10,68,10,101,10,98,10,117,10,103,10,32,10,70,10,97,10,99,10
        DB 105,10,108,10,105,10,116,10,121,10,196,10,196,10,196,10,196,10,196
        DB 10,196,10,196,10,196,10,196,10,196,10,196,10,196,10,196,10,196,10
        DB 196,10,196,10,196,10,196,10,196,10,196,10,196,10,196,10,196,10,196
        DB 10,196,10,196,10,196,10,196,10,196,10,196,10,196,10,196,10,196,10
        DB 196,10,196,10,196,10,196,10,196,10,196,10,196,10,196,10,196,10,196
        DB 10,196,10,196,10,196,10,196,10,196,10,196,10,196,10,196,10,196,10
        DB 196,10,196,10,196,10,196,10,196,10,196,10,196,10,196,10,196,10,196
        DB 10,196,10,196,10,196,10,196,10,196,10,196,10,196,10,196,10,196,10
        DB 196,10,196,10,196,10,196,10,196,10,196,10,196,10,196,10,196,10,201
        DB 11,205,11,205,11,205,11,205,11,205,11,205,11,205,11,205,11,205,11
        DB 205,11,205,11,205,11,205,11,205,11,205,11,187,11,32,7,77,11,101,11
        DB 109,11,111,11,114,11,121,11,32,7,100,11,117,11,109,11,112,11,58,11
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,186,11,82
        DB 11,101,11,103,11,105,11,115,11,116,11,101,11,114,11,115,11,58,11
        DB 32,7,32,7,32,7,32,7,32,7,186,11,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,186,11,68,11,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,40,11,65,11,47,11,66,11,41,11,32,7,32,7,186,11,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,186,11,88,11,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,186,11
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,186,11,89
        DB 11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,186,11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,186,11,85,11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,186,11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,186,11,83,11,32,11,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,186,11,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,186,11,80,11,67,11,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,186,11,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,186,11,68,11,80,11
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 186,11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,199
        DB 11,196,11,196,11,196,11,196,11,196,11,196,11,196,11,196,11,196,11
        DB 196,11,196,11,196,11,196,11,196,11,196,11,182,11,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,201,9,205,9,205,9,205,9,205,9,205,9,205,9,205,9,205,9,205
        DB 9,205,9,205,9,205,9,205,9,205,9,205,9,205,9,187,9,186,11,70,11,108
        DB 11,97,11,103,11,115,11,58,11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,186,11,32,7,68,11,105,11,115,11,97,11,115,11,115,11,101,11
        DB 109,11,98,11,108,11,121,11,58,11,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,186,9,32,9,66,11,114,9,101,9,97,9,107,9,112,9,111,9,105,9
        DB 110,9,116,9,32,9,32,9,32,9,32,9,32,9
        DB 186,9,186,11,69,11,32,7,70,11,32,7,72
        DB 11,32,7,73,11,32,7,78,11,32,7,90,11,32,7,86,11,32,7,67,11,186,11
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,186,9,32,9,67,11,111,9,110
        DB 9,116,9,105,9,110,9,117,9,101,9,32,9,32,9,32,9,32,9
        DB 32,9,32,9,32,9,186,9,186
        DB 11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,186,11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,186,9,32
        DB 9,68,11,105,9,115,9,97,9,115,9,115,9,101,9,109,9,98,9,108,9,101,9
        DB 32,9,32,9,32,9,32,9,186,9
        DB 200,11,205,11,205,11,205,11,205,11,205,11,205,11
        DB 205,11,205,11,205,11,205,11,205,11,205,11,205,11,205,11,205,11,188
        DB 11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,9,186,9,32,9,69,11,100,9
        DB 105,9,116,9,32,9,109,9,101,9,109,9,111,9,114,9,121,9,32,9
        DB 32,9,32,9,32,9,186
        DB 9,218,11,196,11,196,11,196,11,196,11,196,11,196,11,196,11,196,11
        DB 196,11,196,11,196,11,196,11,196,11,196,11,196,11,191,11,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,186,9,32,9,70,11,108,9,97,9,103,9,115
        DB 9,'/',9,'H',11,'e',9,'x',9,32,9,'m',9,'a',9,'t',9,'h',9,' ',9
        DB 186,9,179,11,83,11,116
        DB 11,97,11,99,11,107,11,32,7,85,11,32,7,32,7,32,7,32,7,83,11,32,11
        DB 32,7,32,7,179,11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,186,9,32
        DB 9,'L',11,'o',9,'c',9,'a',9,'t',9,'e',9,' ',9,'w',9,'o',9,'r',9
        DB 'd',9,32,9,32,9,32
        DB 9,32,9,186,9,179,11,32,7,43,11,48,11,48,11,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,179,11,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,186,9,32,9,77,11,101,9,109,9,111,9,114,9,121,9,32,9,100
        DB 9,117,9,109,9,112,9,32,9
        DB 32,9,32,9,32,9,186,9,179,11,32,7,43,11,48,11,50,11
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,179,11,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,186,9,32,9,81,11,117,9,105,9
        DB 116,9,32,9,32,9,32,9,32,9,32,9,32,9,32,9,32,9,32,9,32,9
        DB 32,9,186,9,179,11,32
        DB 7,43,11,48,11,52,11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,179,11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,186,9,32
        DB 9,82,11,101,9,103,9,105,9,115,9,116,9,101,9,114,9,115,9,32,9
        DB 32,9,32,9,32,9
        DB 32,9,32,9,186,9,179,11,32,7,43,11,48,11,54,11,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,179,11,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,186,9,32,9,83,11,'t',9,'e',9,'p',9,32,9,'i',9,'n'
        DB 9,'/',9,'O',11,'v',9,'e',9,'r',9,32,9,32,9,32,9
        DB 186,9,179,11,32,7,43,11,48,11
        DB 56,11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,179
        DB 11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,186,9,32,9,86,11,105,9
        DB 101,9,119,9,32,9,118,9,105,9,100,9,101,9,111,9,32,9,32,9,32,9
        DB 32,9,32,9,186
        DB 9,192,11,196,11,196,11,196,11,196,11,196,11,196,11,196,11,196,11
        DB 196,11,196,11,196,11,196,11,196,11,196,11,196,11,217,11,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,200,9,205,9,205,9,205,9,205,9,205,9,205,9
        DB 205,9
        DB 205,9,205,9,205,9,205,9,205,9,205,9,205,9,205,9,205,9,188,9,32,14
        DB 32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14
        DB 32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14
        DB 32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14
        DB 32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14
        DB 32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14
        DB 32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14
        DB 32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14,32,14
        DB 32,14,32,10

;Keyboard binding list (PC mode)
VKEY_LIST DB 62H,62H         ;ESC => BREAK
        DB 41H,41H          ;Direct binding (d.b.): "1"
        DB 42H,80H          ;"2" d.b., SHIFT-2 => @ key
        DB 43H,43H          ;"3"
        DB 44H,44H          ;"4"
        DB 45H,45H          ;"5"
        DB 46H,0B3H         ;"6" d.b., SHIFT-6 => Up-arrow
        DB 47H,46H          ;"7" d.b., SHIFT-7 => SHIFT-6
        DB 50H,52H          ;"8" d.b., SHIFT-8 => SHIFT-:
        DB 51H,50H          ;"9" d.b., SHIFT-9 => SHIFT-8
        DB 40H,51H          ;"0" d.b., SHIFT-0 => SHIFT-9
        DB 55H,33H          ;"-" d.b., SHIFT-"-" => SHIFT-Up arrow
        DB 0D5H,53H         ;"=" => SHIFT-"-", "+" => SHIFT-;
        DB 35H,35H          ;Backspace => Left-arrow
        DB 36H,36H          ;Tab => RIght-arrow
        DB 21H,21H          ;"Q"
        DB 27H,27H          ;"W"
        DB 05H,05H          ;"E"
        DB 22H,22H          ;"R"
        DB 24H,24H          ;"T"
        DB 31H,31H          ;"Y"
        DB 25H,25H          ;"U"        
        DB 11H,11H          ;"I"
        DB 17H,17H          ;"O"
        DB 20H,20H          ;"P"
        DB 0B4H,34H         ;"[" => SHIFT-Down arrow
        DB 0B6H,36H         ;"]" => SHIFT-Right arrow
        DB 60H,60H          ;ENTER
        DB 64H,64H          ;CTRL
        DB 01H,01H          ;"A"
        DB 23H,23H          ;"S"
        DB 04H,04H          ;"D"
        DB 06H,06H          ;"F"
        DB 07H,07H          ;"G"
        DB 10H,10H          ;"H"
        DB 12H,12H          ;"J"
        DB 13H,13H          ;"K"
        DB 14H,14H          ;"L"
        DB 53H,0D2H         ;";" d.b., SHIFT-; => ":"
        DB 0C7H,42H         ;"'" => SHIFT-7, SHIFT-' => SHIFT-2
        DB  8 , 8           ;"`"
        DB 67H,67H          ;Left shift => SHIFT
        DB  8 , 8           ;"\"
        DB 32H,32H          ;"Z"
        DB 30H,30H          ;"X"
        DB 03H,03H          ;"C"
        DB 26H,26H          ;"V"
        DB 02H,02H          ;"B"
        DB 16H,16H          ;"N"
        DB 15H,15H          ;"M"
        DB 54H,54H          ;","
        DB 56H,56H          ;"."
        DB 57H,57H          ;"/"
        DB 67H,67H          ;Right shift => SHIFT
        DB 0D2H,8           ;PRINT SCREEN
        DB 63H,63H          ;ALT
        DB 37H,37H          ;SPACE BAR
        DB 0C0H,40H         ;CAPS LOCK => SHIFT-0
        DB  8 , 8           ;F1    
        DB  8 , 8           ;F2
        DB  8 , 8           ;F3
        DB  8 , 8           ;F4
        DB  8 , 8           ;F5
        DB  8 , 8           ;F6
        DB  8 , 8           ;F7
        DB  8 , 8           ;F8
        DB  8 , 8           ;F9
        DB  8 , 8           ;F10
        DB  8 , 8           ;NUM LOCK
        DB 80H,00H          ;SCROLL LOCK => SHIFT-@
;With NUM LOCK off        
        DB 61H,61H          ;HOME => CLEAR
        DB 33H,33H          ;Up arrow d.b.
        DB  8 , 8           ;PG-UP => nothing
        DB 55H,0D5H         ;Keypad "-" => "-"
        DB 35H,35H          ;Left-arrow d.b.
        DB  8 , 8           ;Keypad "5" => nothing
        DB 36H,36H          ;Right arrow d.b.
        DB 0D3H,53H         ;Keypad "+" => "+"
        DB  8 , 8           ;END => nothing
        DB 34H,34H          ;Down-arrow d.b.
        DB  8 , 8           ;PG-DN => nothing
        DB  8 , 8           ;INSERT => nothing
        DB  8 , 8           ;DELETE => nothing
;With NUM LOCK on
        DB 47H,47H          ;Keypad 7 => "7"
        DB 50H,50H          ;Keypad 8 => "8"
        DB 51H,51H          ;Keypad 9 => "9"
        DB 55H,0D5H         ;Keypad "-" => "-"
        DB 44H,44H          ;Keypad 4 => "4"
        DB 45H,45H          ;Keypad 5 => "5"
        DB 46H,46H          ;Keypad 6 => "6"
        DB 0D3H,53H         ;Keypad "+" => SHIFT-;
        DB 41H,41H          ;Keypad 1 => "1"
        DB 42H,42H          ;Keypad 2 => "2"
        DB 43H,43H          ;Keypad 3 => "3"
        DB 40H,40H          ;Keypad 0 => "0"
        DB 56H,56H          ;Keypad . => "."
        DB 65H,65H          ;F11
        DB 66H,66H          ;F12

;Alternate layout keyboard binding list (CoCo mode)
VALT_LIST DB 62H,62H         ;ESC => BREAK
        DB 41H,41H          ;"1"
        DB 42H,42H          ;"2"
        DB 43H,43H          ;"3"
        DB 44H,44H          ;"4"
        DB 45H,45H          ;"5"
        DB 46H,46H          ;"6"
        DB 47H,47H          ;"7"
        DB 50H,50H          ;"8"
        DB 51H,51H          ;"9"
        DB 40H,40H          ;"0"
        DB 52H,52H          ;"-" => ":"
        DB 55H,55H          ;"=" => "-"
        DB 35H,35H          ;Backspace => Left-arrow
        DB 36H,36H          ;Tab => RIght-arrow
        DB 21H,21H          ;"Q"
        DB 27H,27H          ;"W"
        DB 05H,05H          ;"E"
        DB 22H,22H          ;"R"
        DB 24H,24H          ;"T"
        DB 31H,31H          ;"Y"
        DB 25H,25H          ;"U"        
        DB 11H,11H          ;"I"
        DB 17H,17H          ;"O"
        DB 20H,20H          ;"P"
        DB 00H,00H          ;"[" => "@"
        DB 61H,61H          ;"]" => CLEAR
        DB 60H,60H          ;ENTER
        DB 64H,64H          ;CTRL
        DB 01H,01H          ;"A"
        DB 23H,23H          ;"S"
        DB 04H,04H          ;"D"
        DB 06H,06H          ;"F"
        DB 07H,07H          ;"G"
        DB 10H,10H          ;"H"
        DB 12H,12H          ;"J"
        DB 13H,13H          ;"K"
        DB 14H,14H          ;"L"
        DB 53H,53H          ;";"
        DB  8 , 8           ;"'"
        DB  8 , 8           ;"`"
        DB 67H,67H          ;Left shift => SHIFT
        DB  8 , 8           ;"\"
        DB 32H,32H          ;"Z"
        DB 30H,30H          ;"X"
        DB 03H,03H          ;"C"
        DB 26H,26H          ;"V"
        DB 02H,02H          ;"B"
        DB 16H,16H          ;"N"
        DB 15H,15H          ;"M"
        DB 54H,54H          ;","
        DB 56H,56H          ;"."
        DB 57H,57H          ;"/"
        DB 67H,67H          ;Right shift => SHIFT
        DB 0D2H,8           ;PRINT SCREEN
        DB 63H,63H          ;ALT
        DB 37H,37H          ;SPACE BAR
        DB 0C0H,40H         ;CAPS LOCK
        DB  8 , 8           ;F1    
        DB  8 , 8           ;F2
        DB  8 , 8           ;F3
        DB  8 , 8           ;F4
        DB  8 , 8           ;F5
        DB  8 , 8           ;F6
        DB  8 , 8           ;F7
        DB  8 , 8           ;F8
        DB  8 , 8           ;F9
        DB  8 , 8           ;F10
        DB  8 , 8           ;NUM LOCK
        DB  8 , 8           ;SCROLL LOCK
;With NUM LOCK off        
        DB 61H,61H          ;HOME => CLEAR
        DB 33H,33H          ;Up arrow d.b.
        DB  8 , 8           ;PG-UP => nothing
        DB 55H,0D5H         ;Keypad "-" => "-"
        DB 35H,35H          ;Left-arrow d.b.
        DB  8 , 8           ;Keypad "5" => nothing
        DB 36H,36H          ;Right arrow d.b.
        DB 0D3H,53H         ;Keypad "+" => "+"
        DB  8 , 8           ;END => nothing
        DB 34H,34H          ;Down-arrow d.b.
        DB  8 , 8           ;PG-DN => nothing
        DB  8 , 8           ;INSERT => nothing
        DB  8 , 8           ;DELETE => nothing
;With NUM LOCK on
        DB 47H,47H          ;Keypad 7 => "7"
        DB 50H,50H          ;Keypad 8 => "8"
        DB 51H,51H          ;Keypad 9 => "9"
        DB 55H,0D5H         ;Keypad "-" => "-"
        DB 44H,44H          ;Keypad 4 => "4"
        DB 45H,45H          ;Keypad 5 => "5"
        DB 46H,46H          ;Keypad 6 => "6"
        DB 0D3H,53H         ;Keypad "+" => SHIFT-;
        DB 41H,41H          ;Keypad 1 => "1"
        DB 42H,42H          ;Keypad 2 => "2"
        DB 43H,43H          ;Keypad 3 => "3"
        DB 40H,40H          ;Keypad 0 => "0"
        DB 56H,56H          ;Keypad . => "."
        DB 65H,65H          ;F11
        DB 66H,66H          ;F12

;Custom keyboard map (default is same as PC mode)
VCUSTOM_LIST DB 62H,62H         ;ESC => BREAK
        DB 41H,41H          ;Direct binding (d.b.): "1"
        DB 42H,80H          ;"2" d.b., SHIFT-2 => @ key
        DB 43H,43H          ;"3"
        DB 44H,44H          ;"4"
        DB 45H,45H          ;"5"
        DB 46H,0B3H         ;"6" d.b., SHIFT-6 => Up-arrow
        DB 47H,46H          ;"7" d.b., SHIFT-7 => SHIFT-6
        DB 50H,52H          ;"8" d.b., SHIFT-8 => SHIFT-:
        DB 51H,50H          ;"9" d.b., SHIFT-9 => SHIFT-8
        DB 40H,51H          ;"0" d.b., SHIFT-0 => SHIFT-9
        DB 55H,33H          ;"-" d.b., SHIFT-"-" => SHIFT-Up arrow
        DB 0D5H,53H         ;"=" => SHIFT-"-", "+" => SHIFT-;
        DB 35H,35H          ;Backspace => Left-arrow
        DB 36H,36H          ;Tab => RIght-arrow
        DB 21H,21H          ;"Q"
        DB 27H,27H          ;"W"
        DB 05H,05H          ;"E"
        DB 22H,22H          ;"R"
        DB 24H,24H          ;"T"
        DB 31H,31H          ;"Y"
        DB 25H,25H          ;"U"        
        DB 11H,11H          ;"I"
        DB 17H,17H          ;"O"
        DB 20H,20H          ;"P"
        DB 0B4H,34H         ;"[" => SHIFT-Down arrow
        DB 0B6H,36H         ;"]" => SHIFT-Right arrow
        DB 60H,60H          ;ENTER
        DB 64H,64H          ;CTRL
        DB 01H,01H          ;"A"
        DB 23H,23H          ;"S"
        DB 04H,04H          ;"D"
        DB 06H,06H          ;"F"
        DB 07H,07H          ;"G"
        DB 10H,10H          ;"H"
        DB 12H,12H          ;"J"
        DB 13H,13H          ;"K"
        DB 14H,14H          ;"L"
        DB 53H,0D2H         ;";" d.b., SHIFT-; => ":"
        DB 0C7H,42H         ;"'" => SHIFT-7, SHIFT-' => SHIFT-2
        DB  8 , 8           ;"`"
        DB 67H,67H          ;Left shift => SHIFT
        DB  8 , 8           ;"\"
        DB 32H,32H          ;"Z"
        DB 30H,30H          ;"X"
        DB 03H,03H          ;"C"
        DB 26H,26H          ;"V"
        DB 02H,02H          ;"B"
        DB 16H,16H          ;"N"
        DB 15H,15H          ;"M"
        DB 54H,54H          ;","
        DB 56H,56H          ;"."
        DB 57H,57H          ;"/"
        DB 67H,67H          ;Right shift => SHIFT
        DB 0D2H,8           ;PRINT SCREEN
        DB 63H,63H          ;ALT
        DB 37H,37H          ;SPACE BAR
        DB 0C0H,40H         ;CAPS LOCK => SHIFT-0
        DB  8 , 8           ;F1    
        DB  8 , 8           ;F2
        DB  8 , 8           ;F3
        DB  8 , 8           ;F4
        DB  8 , 8           ;F5
        DB  8 , 8           ;F6
        DB  8 , 8           ;F7
        DB  8 , 8           ;F8
        DB  8 , 8           ;F9
        DB  8 , 8           ;F10
        DB  8 , 8           ;NUM LOCK
        DB 80H,00H          ;SCROLL LOCK => SHIFT-@
;With NUM LOCK off        
        DB 61H,61H          ;HOME => CLEAR
        DB 33H,33H          ;Up arrow d.b.
        DB  8 , 8           ;PG-UP => nothing
        DB 55H,0D5H         ;Keypad "-" => "-"
        DB 35H,35H          ;Left-arrow d.b.
        DB  8 , 8           ;Keypad "5" => nothing
        DB 36H,36H          ;Right arrow d.b.
        DB 0D3H,53H         ;Keypad "+" => "+"
        DB  8 , 8           ;END => nothing
        DB 34H,34H          ;Down-arrow d.b.
        DB  8 , 8           ;PG-DN => nothing
        DB  8 , 8           ;INSERT => nothing
        DB  8 , 8           ;DELETE => nothing
;With NUM LOCK on
        DB 47H,47H          ;Keypad 7 => "7"
        DB 50H,50H          ;Keypad 8 => "8"
        DB 51H,51H          ;Keypad 9 => "9"
        DB 55H,0D5H         ;Keypad "-" => "-"
        DB 44H,44H          ;Keypad 4 => "4"
        DB 45H,45H          ;Keypad 5 => "5"
        DB 46H,46H          ;Keypad 6 => "6"
        DB 0D3H,53H         ;Keypad "+" => SHIFT-;
        DB 41H,41H          ;Keypad 1 => "1"
        DB 42H,42H          ;Keypad 2 => "2"
        DB 43H,43H          ;Keypad 3 => "3"
        DB 40H,40H          ;Keypad 0 => "0"
        DB 56H,56H          ;Keypad . => "."
        DB 65H,65H          ;F11
        DB 66H,66H          ;F12

VOS9_LIST DB 98,98,65,65,66,128,67,67,68,68,69,69,70,207,71,70,80,82,81,80,64
        DB 81,85,221,213,83,53,53,54,54,33,33,39,39,5,5,34,34,36,36,49,49,37
        DB 37,17,17,23,23,32,32,88,220,89,222,96,96,100,100,1,1,35,35,4,4,6
        DB 6,7,7,16,16,18,18,19,19,20,20,83,210,199,66,8,203,103,103,95,201
        DB 50,50,48,48,3,3,38,38,2,2,22,22,21,21,84,84,86,86,87,87,103,103,210
        DB 8,99,99,55,55,72,200,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
        DB 128,0,97,97,51,51,8,8,85,213,53,53,8,8,54,54,211,83,8,8,52,52,8,8
        DB 8,8,8,8,71,71,80,80,81,81,85,213,68,68,69,69,70,70,211,83,65,65,66
        DB 66,67,67,64,64,86,86,101,101,102,102

        ORG 2000H

VBANK1R  DW 0
VBANK1W  DW 0
VSVIDEO1 DW ?
VEVIDEO1 DW ?

;EGA-compatible DAC settings
VDAC_TABLE DB 0,0,0
        DB 0,0,42,0,42,0,0,42,42,42,0,0,42,0,42,42,42,0,42,42,42,0,0,21
        DB 0,0,63,0,42,21,0,42,63,42,0,21,42,0,63,42,42,21,42,42,63,0,21,0,0
        DB 21,42,0,63,0,0,63,42,42,21,0,42,21,42,42,63,0,42,63,42,0,21,21,0
        DB 21,63,0,63,21,0,63,63,42,21,21,42,21,63,42,63,21,42,63,63,21,0,0
        DB 21,0,42,21,42,0,21,42,42,63,0,0,63,0,42,63,42,0,63,42,42,21,0,21
        DB 21,0,63,21,42,21,21,42,63,63,0,21,63,0,63,63,42,21,63,42,63,21,21
        DB 0,21,21,42,21,63,0,21,63,42,63,21,0,63,21,42,63,63,0,63,63,42,21
        DB 21,21,21,21,63,21,63,21,21,63,63,63,21,21,63,21,63,63,63,21,63,63
        DB 63

;CoCo 1/2 character sets: 0-143 as CoCo 1, 144-159 are left half of SG4 cells
;for 64 column mode, 160-175 are lowercase to replace 0-31 if selected
VFONT12  DB 0,56,68,4,52,76,76,56,0,0,0,0,0,16,40,68,68,124,68,68,0,0,0,0,0,120
        DB 36,36,56,36,36,120,0,0,0,0,0,56,68,64,64,64,68,56,0,0,0,0,0,120,36
        DB 36,36,36,36,120,0,0,0,0,0,124,64,64,112,64,64,124,0,0,0,0,0,124,64
        DB 64,120,64,64,64,0,0,0,0,0,60,64,64,76,68,68,60,0,0,0,0,0,68,68,68
        DB 124,68,68,68,0,0,0,0,0,56,16,16,16,16,16,56,0,0,0,0,0,4,4,4,4,68
        DB 68,56,0,0,0,0,0,68,72,80,96,80,72,68,0,0,0,0,0,64,64,64,64,64,64
        DB 124,0,0,0,0,0,68,108,124,84,68,68,68,0,0,0,0,0,68,68,100,84,76,68
        DB 68,0,0,0,0,0,56,68,68,68,68,68,56,0,0,0,0,0,120,68,68,120,64,64,64
        DB 0,0,0,0,0,56,68,68,68,84,72,52,0,0,0,0,0,120,68,68,120,80,72,68,0
        DB 0,0,0,0,56,68,32,16,8,68,56,0,0,0,0,0,124,16,16,16,16,16,16,0,0,0
        DB 0,0,68,68,68,68,68,68,56,0,0,0,0,0,68,68,68,40,40,16,16,0,0,0,0,0
        DB 68,68,68,84,124,108,68,0,0,0,0,0,68,68,40,16,40,68,68,0,0,0,0,0,68
        DB 68,40,16,16,16,16,0,0,0,0,0,124,4,8,16,32,64,124,0,0,0,0,0,56,32
        DB 32,32,32,32,56,0,0,0,0,0,0,64,32,16,8,4,0,0,0,0,0,0,56,8,8,8,8,8
        DB 56,0,0,0,0,0,16,56,84,16,16,16,16,0,0,0,0,0,0,16,32,124,32,16,0,0
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,16,16,16,16,0,16,0,0,0,0,0,40
        DB 40,0,0,0,0,0,0,0,0,0,0,40,40,124,40,124,40,40,0,0,0,0,0,16,60,64
        DB 56,4,120,16,0,0,0,0,0,100,100,8,16,32,76,76,0,0,0,0,0,32,80,80,32
        DB 84,72,52,0,0,0,0,0,16,16,0,0,0,0,0,0,0,0,0,0,8,16,32,32,32,16,8,0
        DB 0,0,0,0,32,16,8,8,8,16,32,0,0,0,0,0,16,84,56,124,56,84,16,0,0,0,0
        DB 0,0,16,16,124,16,16,0,0,0,0,0,0,0,0,0,0,48,48,16,32,0,0,0,0,0,0,0
        DB 124,0,0,0,0,0,0,0,0,0,0,0,0,0,48,48,0,0,0,0,0,0,4,8,16,32,64,0,0
        DB 0,0,0,0,56,68,76,84,100,68,56,0,0,0,0,0,16,48,16,16,16,16,56,0,0
        DB 0,0,0,56,68,4,56,64,64,124,0,0,0,0,0,56,68,4,56,4,68,56,0,0,0,0,0
        DB 8,24,40,124,8,8,8,0,0,0,0,0,124,64,120,4,4,68,56,0,0,0,0,0,56,64
        DB 64,120,68,68,56,0,0,0,0,0,124,4,8,16,32,64,64,0,0,0,0,0,56,68,68
        DB 56,68,68,56,0,0,0,0,0,56,68,68,60,4,4,56,0,0,0,0,0,0,48,48,0,48,48
        DB 0,0,0,0,0,0,0,48,48,0,48,48,16,32,0,0,0,0,4,8,16,32,16,8,4,0,0,0
        DB 0,0,0,0,124,0,124,0,0,0,0,0,0,0,32,16,8,4,8,16,32,0,0,0,0,0,56,68
        DB 4,8,16,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,15,15
        DB 15,15,15,0,0,0,0,0,0,240,240,240,240,240,240,0,0,0,0,0,0,255,255
        DB 255,255,255,255,15,15,15,15,15,15,0,0,0,0,0,0,15,15,15,15,15,15,15
        DB 15,15,15,15,15,15,15,15,15,15,15,240,240,240,240,240,240,15,15,15
        DB 15,15,15,255,255,255,255,255,255,240,240,240,240,240,240,0,0,0,0
        DB 0,0,240,240,240,240,240,240,15,15,15,15,15,15,240,240,240,240,240
        DB 240,240,240,240,240,240,240,240,240,240,240,240,240,255,255,255,255
        DB 255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255
        DB 15,15,15,15,15,15,255,255,255,255,255,255,240,240,240,240,240,240
        DB 255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255
        DB 0,0,0,0,0,0,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,0,0,0,0,0,0
        DB 255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255
        DB 255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255
        DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
        DB 255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,0,0,0,0,0,0,255,255
        DB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
        DB 255,255,255,255,255,0,16,40,68,0,0,0,0,0,0,0,0,0,0,0,56,4,60,68,60
        DB 0,0,0,0,0,64,64,120,68,68,68,120,0,0,0,0,0,0,0,56,68,64,68,56,0,0
        DB 0,0,0,4,4,60,68,68,68,60,0,0,0,0,0,0,0,56,68,120,64,56,0,0,0,0,0
        DB 24,36,32,112,32,32,32,0,0,0,0,0,0,0,56,68,68,60,4,56,0,0,0,0,64,64
        DB 120,68,68,68,68,0,0,0,0,0,16,0,48,16,16,16,56,0,0,0,0,0,4,0,4,4,4
        DB 4,68,56,0,0,0,0,64,64,68,72,112,72,68,0,0,0,0,0,48,16,16,16,16,16
        DB 56,0,0,0,0,0,0,0,104,124,84,68,68,0,0,0,0,0,0,0,120,68,68,68,68,0
        DB 0,0,0,0,0,0,56,68,68,68,56,0,0,0,0,0,0,0,120,68,68,120,64,64,0,0
        DB 0,0,0,0,60,68,68,60,4,4,0,0,0,0,0,0,88,100,64,64,64,0,0,0,0,0,0,0
        DB 60,64,56,4,120,0,0,0,0,0,0,16,56,16,16,20,8,0,0,0,0,0,0,0,68,68,68
        DB 76,52,0,0,0,0,0,0,0,68,68,40,40,16,0,0,0,0,0,0,0,68,68,68,84,40,0
        DB 0,0,0,0,0,0,68,40,16,40,68,0,0,0,0,0,0,0,68,68,68,60,4,56,0,0,0,0
        DB 0,0,124,8,16,32,124,0,0,0,0,0,12,16,16,96,16,16,12,0,0,0,0,0,16,16
        DB 16,0,16,16,16,0,0,0,0,0,96,16,16,12,16,16,96,0,0,0,0,0,32,84,8,0
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,0,0,0,0

;CoCo 3 character set, chars 0-127.  Chars 128-255 are to be same, but with
;underlines
VFONT3   DB 56,68,64,64,64,68,56,16,0,0,0,0,0,0,0,0,68,0,68,68,68,76,52,0,0,0
        DB 0,0,0,0,0,0,8,16,56,68,120,64,56,0,0,0,0,0,0,0,0,0,16,40,56,4,60
        DB 68,60,0,0,0,0,0,0,0,0,0,40,0,56,4,60,68,60,0,0,0,0,0,0,0,0,0,32,16
        DB 56,4,60,68,60,0,0,0,0,0,0,0,0,0,16,0,56,4,60,68,60,0,0,0,0,0,0,0
        DB 0,0,0,0,56,68,64,68,56,16,0,0,0,0,0,0,0,0,16,40,56,68,120,64,56,0
        DB 0,0,0,0,0,0,0,0,40,0,56,68,120,64,56,0,0,0,0,0,0,0,0,0,32,16,56,68
        DB 120,64,56,0,0,0,0,0,0,0,0,0,40,0,48,16,16,16,56,0,0,0,0,0,0,0,0,0
        DB 16,40,0,48,16,16,56,0,0,0,0,0,0,0,0,0,0,24,36,56,36,36,24,96,0,0
        DB 0,0,0,0,0,0,68,16,40,68,124,68,68,0,0,0,0,0,0,0,0,0,16,16,40,68,124
        DB 68,68,0,0,0,0,0,0,0,0,0,8,16,56,68,68,68,56,0,0,0,0,0,0,0,0,0,0,0
        DB 56,20,56,80,56,0,0,0,0,0,0,0,0,0,60,80,80,124,80,80,76,0,0,0,0,0
        DB 0,0,0,0,16,40,56,68,68,68,56,0,0,0,0,0,0,0,0,0,40,0,56,68,68,68,56
        DB 0,0,0,0,0,0,0,0,0,0,0,56,76,84,100,56,0,0,0,0,0,0,0,0,0,16,40,0,68
        DB 68,76,52,0,0,0,0,0,0,0,0,0,32,16,68,68,68,76,52,0,0,0,0,0,0,0,0,0
        DB 16,40,76,84,100,40,16,0,0,0,0,0,0,0,0,0,68,56,68,68,68,68,56,0,0
        DB 0,0,0,0,0,0,0,40,68,68,68,68,68,56,0,0,0,0,0,0,0,0,0,56,64,56,68
        DB 56,4,56,0,0,0,0,0,0,0,0,0,8,20,16,56,16,20,120,0,0,0,0,0,0,0,0,0
        DB 16,16,124,16,16,0,124,0,0,0,0,0,0,0,0,0,16,40,16,0,0,0,0,0,0,0,0
        DB 0,0,0,0,0,8,20,16,56,16,16,80,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        DB 0,0,0,0,0,0,0,0,16,16,16,16,16,0,16,0,0,0,0,0,0,0,0,0,40,40,0,0,0
        DB 0,0,0,0,0,0,0,0,0,0,0,40,40,124,40,124,40,40,0,0,0,0,0,0,0,0,0,16
        DB 60,64,56,4,120,16,0,0,0,0,0,0,0,0,0,100,100,8,16,32,76,76,0,0,0,0
        DB 0,0,0,0,0,32,80,80,32,84,72,52,0,0,0,0,0,0,0,0,0,16,16,0,0,0,0,0
        DB 0,0,0,0,0,0,0,0,0,8,16,32,32,32,16,8,0,0,0,0,0,0,0,0,0,32,16,8,8
        DB 8,16,32,0,0,0,0,0,0,0,0,0,16,84,56,124,56,84,16,0,0,0,0,0,0,0,0,0
        DB 0,16,16,124,16,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,48,16,32,0,0,0,0
        DB 0,0,0,0,0,0,0,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,48,0,0,0,0
        DB 0,0,0,0,0,0,4,8,16,32,64,0,0,0,0,0,0,0,0,0,0,56,68,76,84,100,68,56
        DB 0,0,0,0,0,0,0,0,0,16,48,16,16,16,16,56,0,0,0,0,0,0,0,0,0,56,68,4
        DB 56,64,64,124,0,0,0,0,0,0,0,0,0,56,68,4,56,4,68,56,0,0,0,0,0,0,0,0
        DB 0,8,24,40,124,8,8,8,0,0,0,0,0,0,0,0,0,124,64,120,4,4,68,56,0,0,0
        DB 0,0,0,0,0,0,56,64,64,120,68,68,56,0,0,0,0,0,0,0,0,0,124,4,8,16,32
        DB 64,64,0,0,0,0,0,0,0,0,0,56,68,68,56,68,68,56,0,0,0,0,0,0,0,0,0,56
        DB 68,68,60,4,4,56,0,0,0,0,0,0,0,0,0,0,48,48,0,48,48,0,0,0,0,0,0,0,0
        DB 0,0,0,48,48,0,48,48,16,32,0,0,0,0,0,0,0,0,4,8,16,32,16,8,4,0,0,0
        DB 0,0,0,0,0,0,0,0,124,0,124,0,0,0,0,0,0,0,0,0,0,0,32,16,8,4,8,16,32
        DB 0,0,0,0,0,0,0,0,0,56,68,4,8,16,0,16,0,0,0,0,0,0,0,0,0,56,68,4,52
        DB 76,76,56,0,0,0,0,0,0,0,0,0,16,40,68,68,124,68,68,0,0,0,0,0,0,0,0
        DB 0,120,36,36,56,36,36,120,0,0,0,0,0,0,0,0,0,56,68,64,64,64,68,56,0
        DB 0,0,0,0,0,0,0,0,120,36,36,36,36,36,120,0,0,0,0,0,0,0,0,0,124,64,64
        DB 112,64,64,124,0,0,0,0,0,0,0,0,0,124,64,64,120,64,64,64,0,0,0,0,0
        DB 0,0,0,0,60,64,64,76,68,68,60,0,0,0,0,0,0,0,0,0,68,68,68,124,68,68
        DB 68,0,0,0,0,0,0,0,0,0,56,16,16,16,16,16,56,0,0,0,0,0,0,0,0,0,4,4,4
        DB 4,68,68,56,0,0,0,0,0,0,0,0,0,68,72,80,96,80,72,68,0,0,0,0,0,0,0,0
        DB 0,64,64,64,64,64,64,124,0,0,0,0,0,0,0,0,0,68,108,124,84,68,68,68
        DB 0,0,0,0,0,0,0,0,0,68,68,100,84,76,68,68,0,0,0,0,0,0,0,0,0,56,68,68
        DB 68,68,68,56,0,0,0,0,0,0,0,0,0,120,68,68,120,64,64,64,0,0,0,0,0,0
        DB 0,0,0,56,68,68,68,84,72,52,0,0,0,0,0,0,0,0,0,120,68,68,120,80,72
        DB 68,0,0,0,0,0,0,0,0,0,56,68,32,16,8,68,56,0,0,0,0,0,0,0,0,0,124,16
        DB 16,16,16,16,16,0,0,0,0,0,0,0,0,0,68,68,68,68,68,68,56,0,0,0,0,0,0
        DB 0,0,0,68,68,68,40,40,16,16,0,0,0,0,0,0,0,0,0,68,68,68,84,124,108
        DB 68,0,0,0,0,0,0,0,0,0,68,68,40,16,40,68,68,0,0,0,0,0,0,0,0,0,68,68
        DB 40,16,16,16,16,0,0,0,0,0,0,0,0,0,124,4,8,16,32,64,124,0,0,0,0,0,0
        DB 0,0,0,56,32,32,32,32,32,56,0,0,0,0,0,0,0,0,0,0,64,32,16,8,4,0,0,0
        DB 0,0,0,0,0,0,0,56,8,8,8,8,8,56,0,0,0,0,0,0,0,0,0,16,56,84,16,16,16
        DB 16,0,0,0,0,0,0,0,0,0,0,16,32,124,32,16,0,0,0,0,0,0,0,0,0,0,16,40
        DB 68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,4,60,68,60,0,0,0,0,0,0,0,0,0
        DB 64,64,120,68,68,68,120,0,0,0,0,0,0,0,0,0,0,0,56,68,64,68,56,0,0,0
        DB 0,0,0,0,0,0,4,4,60,68,68,68,60,0,0,0,0,0,0,0,0,0,0,0,56,68,120,64
        DB 56,0,0,0,0,0,0,0,0,0,24,36,32,112,32,32,32,0,0,0,0,0,0,0,0,0,0,0
        DB 56,68,68,60,4,56,0,0,0,0,0,0,0,0,64,64,120,68,68,68,68,0,0,0,0,0
        DB 0,0,0,0,16,0,48,16,16,16,56,0,0,0,0,0,0,0,0,0,4,0,4,4,4,4,68,56,0
        DB 0,0,0,0,0,0,0,64,64,68,72,112,72,68,0,0,0,0,0,0,0,0,0,48,16,16,16
        DB 16,16,56,0,0,0,0,0,0,0,0,0,0,0,104,124,84,68,68,0,0,0,0,0,0,0,0,0
        DB 0,0,120,68,68,68,68,0,0,0,0,0,0,0,0,0,0,0,56,68,68,68,56,0,0,0,0
        DB 0,0,0,0,0,0,0,120,68,68,120,64,64,0,0,0,0,0,0,0,0,0,0,60,68,68,60
        DB 4,4,0,0,0,0,0,0,0,0,0,0,88,100,64,64,64,0,0,0,0,0,0,0,0,0,0,0,60
        DB 64,56,4,120,0,0,0,0,0,0,0,0,0,0,16,56,16,16,20,8,0,0,0,0,0,0,0,0
        DB 0,0,0,68,68,68,76,52,0,0,0,0,0,0,0,0,0,0,0,68,68,40,40,16,0,0,0,0
        DB 0,0,0,0,0,0,0,68,68,68,84,40,0,0,0,0,0,0,0,0,0,0,0,68,40,16,40,68
        DB 0,0,0,0,0,0,0,0,0,0,0,68,68,68,60,4,56,0,0,0,0,0,0,0,0,0,0,124,8
        DB 16,32,124,0,0,0,0,0,0,0,0,0,12,16,16,96,16,16,12,0,0,0,0,0,0,0,0
        DB 0,16,16,16,0,16,16,16,0,0,0,0,0,0,0,0,0,96,16,16,12,16,16,96,0,0
        DB 0,0,0,0,0,0,0,32,84,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,0
        DB 0,0,0,0,0,0,0,0
        DB 56,68,64,64,64,68,56,16,0,0,0,0,0,0,0,0,68,0,68,68,68,76,52,0,0,0
        DB 0,0,0,0,0,0,8,16,56,68,120,64,56,0,0,0,0,0,0,0,0,0,16,40,56,4,60
        DB 68,60,0,0,0,0,0,0,0,0,0,40,0,56,4,60,68,60,0,0,0,0,0,0,0,0,0,32,16
        DB 56,4,60,68,60,0,0,0,0,0,0,0,0,0,16,0,56,4,60,68,60,0,0,0,0,0,0,0
        DB 0,0,0,0,56,68,64,68,56,16,0,0,0,0,0,0,0,0,16,40,56,68,120,64,56,0
        DB 0,0,0,0,0,0,0,0,40,0,56,68,120,64,56,0,0,0,0,0,0,0,0,0,32,16,56,68
        DB 120,64,56,0,0,0,0,0,0,0,0,0,40,0,48,16,16,16,56,0,0,0,0,0,0,0,0,0
        DB 16,40,0,48,16,16,56,0,0,0,0,0,0,0,0,0,0,24,36,56,36,36,24,96,0,0
        DB 0,0,0,0,0,0,68,16,40,68,124,68,68,0,0,0,0,0,0,0,0,0,16,16,40,68,124
        DB 68,68,0,0,0,0,0,0,0,0,0,8,16,56,68,68,68,56,0,0,0,0,0,0,0,0,0,0,0
        DB 56,20,56,80,56,0,0,0,0,0,0,0,0,0,60,80,80,124,80,80,76,0,0,0,0,0
        DB 0,0,0,0,16,40,56,68,68,68,56,0,0,0,0,0,0,0,0,0,40,0,56,68,68,68,56
        DB 0,0,0,0,0,0,0,0,0,0,0,56,76,84,100,56,0,0,0,0,0,0,0,0,0,16,40,0,68
        DB 68,76,52,0,0,0,0,0,0,0,0,0,32,16,68,68,68,76,52,0,0,0,0,0,0,0,0,0
        DB 16,40,76,84,100,40,16,0,0,0,0,0,0,0,0,0,68,56,68,68,68,68,56,0,0
        DB 0,0,0,0,0,0,0,40,68,68,68,68,68,56,0,0,0,0,0,0,0,0,0,56,64,56,68
        DB 56,4,56,0,0,0,0,0,0,0,0,0,8,20,16,56,16,20,120,0,0,0,0,0,0,0,0,0
        DB 16,16,124,16,16,0,124,0,0,0,0,0,0,0,0,0,16,40,16,0,0,0,0,0,0,0,0
        DB 0,0,0,0,0,8,20,16,56,16,16,80,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        DB 0,0,0,0,0,0,0,0,16,16,16,16,16,0,16,0,0,0,0,0,0,0,0,0,40,40,0,0,0
        DB 0,0,0,0,0,0,0,0,0,0,0,40,40,124,40,124,40,40,0,0,0,0,0,0,0,0,0,16
        DB 60,64,56,4,120,16,0,0,0,0,0,0,0,0,0,100,100,8,16,32,76,76,0,0,0,0
        DB 0,0,0,0,0,32,80,80,32,84,72,52,0,0,0,0,0,0,0,0,0,16,16,0,0,0,0,0
        DB 0,0,0,0,0,0,0,0,0,8,16,32,32,32,16,8,0,0,0,0,0,0,0,0,0,32,16,8,8
        DB 8,16,32,0,0,0,0,0,0,0,0,0,16,84,56,124,56,84,16,0,0,0,0,0,0,0,0,0
        DB 0,16,16,124,16,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,48,16,32,0,0,0,0
        DB 0,0,0,0,0,0,0,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,48,0,0,0,0
        DB 0,0,0,0,0,0,4,8,16,32,64,0,0,0,0,0,0,0,0,0,0,56,68,76,84,100,68,56
        DB 0,0,0,0,0,0,0,0,0,16,48,16,16,16,16,56,0,0,0,0,0,0,0,0,0,56,68,4
        DB 56,64,64,124,0,0,0,0,0,0,0,0,0,56,68,4,56,4,68,56,0,0,0,0,0,0,0,0
        DB 0,8,24,40,124,8,8,8,0,0,0,0,0,0,0,0,0,124,64,120,4,4,68,56,0,0,0
        DB 0,0,0,0,0,0,56,64,64,120,68,68,56,0,0,0,0,0,0,0,0,0,124,4,8,16,32
        DB 64,64,0,0,0,0,0,0,0,0,0,56,68,68,56,68,68,56,0,0,0,0,0,0,0,0,0,56
        DB 68,68,60,4,4,56,0,0,0,0,0,0,0,0,0,0,48,48,0,48,48,0,0,0,0,0,0,0,0
        DB 0,0,0,48,48,0,48,48,16,32,0,0,0,0,0,0,0,0,4,8,16,32,16,8,4,0,0,0
        DB 0,0,0,0,0,0,0,0,124,0,124,0,0,0,0,0,0,0,0,0,0,0,32,16,8,4,8,16,32
        DB 0,0,0,0,0,0,0,0,0,56,68,4,8,16,0,16,0,0,0,0,0,0,0,0,0,56,68,4,52
        DB 76,76,56,0,0,0,0,0,0,0,0,0,16,40,68,68,124,68,68,0,0,0,0,0,0,0,0
        DB 0,120,36,36,56,36,36,120,0,0,0,0,0,0,0,0,0,56,68,64,64,64,68,56,0
        DB 0,0,0,0,0,0,0,0,120,36,36,36,36,36,120,0,0,0,0,0,0,0,0,0,124,64,64
        DB 112,64,64,124,0,0,0,0,0,0,0,0,0,124,64,64,120,64,64,64,0,0,0,0,0
        DB 0,0,0,0,60,64,64,76,68,68,60,0,0,0,0,0,0,0,0,0,68,68,68,124,68,68
        DB 68,0,0,0,0,0,0,0,0,0,56,16,16,16,16,16,56,0,0,0,0,0,0,0,0,0,4,4,4
        DB 4,68,68,56,0,0,0,0,0,0,0,0,0,68,72,80,96,80,72,68,0,0,0,0,0,0,0,0
        DB 0,64,64,64,64,64,64,124,0,0,0,0,0,0,0,0,0,68,108,124,84,68,68,68
        DB 0,0,0,0,0,0,0,0,0,68,68,100,84,76,68,68,0,0,0,0,0,0,0,0,0,56,68,68
        DB 68,68,68,56,0,0,0,0,0,0,0,0,0,120,68,68,120,64,64,64,0,0,0,0,0,0
        DB 0,0,0,56,68,68,68,84,72,52,0,0,0,0,0,0,0,0,0,120,68,68,120,80,72
        DB 68,0,0,0,0,0,0,0,0,0,56,68,32,16,8,68,56,0,0,0,0,0,0,0,0,0,124,16
        DB 16,16,16,16,16,0,0,0,0,0,0,0,0,0,68,68,68,68,68,68,56,0,0,0,0,0,0
        DB 0,0,0,68,68,68,40,40,16,16,0,0,0,0,0,0,0,0,0,68,68,68,84,124,108
        DB 68,0,0,0,0,0,0,0,0,0,68,68,40,16,40,68,68,0,0,0,0,0,0,0,0,0,68,68
        DB 40,16,16,16,16,0,0,0,0,0,0,0,0,0,124,4,8,16,32,64,124,0,0,0,0,0,0
        DB 0,0,0,56,32,32,32,32,32,56,0,0,0,0,0,0,0,0,0,0,64,32,16,8,4,0,0,0
        DB 0,0,0,0,0,0,0,56,8,8,8,8,8,56,0,0,0,0,0,0,0,0,0,16,56,84,16,16,16
        DB 16,0,0,0,0,0,0,0,0,0,0,16,32,124,32,16,0,0,0,0,0,0,0,0,0,0,16,40
        DB 68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,4,60,68,60,0,0,0,0,0,0,0,0,0
        DB 64,64,120,68,68,68,120,0,0,0,0,0,0,0,0,0,0,0,56,68,64,68,56,0,0,0
        DB 0,0,0,0,0,0,4,4,60,68,68,68,60,0,0,0,0,0,0,0,0,0,0,0,56,68,120,64
        DB 56,0,0,0,0,0,0,0,0,0,24,36,32,112,32,32,32,0,0,0,0,0,0,0,0,0,0,0
        DB 56,68,68,60,4,56,0,0,0,0,0,0,0,0,64,64,120,68,68,68,68,0,0,0,0,0
        DB 0,0,0,0,16,0,48,16,16,16,56,0,0,0,0,0,0,0,0,0,4,0,4,4,4,4,68,56,0
        DB 0,0,0,0,0,0,0,64,64,68,72,112,72,68,0,0,0,0,0,0,0,0,0,48,16,16,16
        DB 16,16,56,0,0,0,0,0,0,0,0,0,0,0,104,124,84,68,68,0,0,0,0,0,0,0,0,0
        DB 0,0,120,68,68,68,68,0,0,0,0,0,0,0,0,0,0,0,56,68,68,68,56,0,0,0,0
        DB 0,0,0,0,0,0,0,120,68,68,120,64,64,0,0,0,0,0,0,0,0,0,0,60,68,68,60
        DB 4,4,0,0,0,0,0,0,0,0,0,0,88,100,64,64,64,0,0,0,0,0,0,0,0,0,0,0,60
        DB 64,56,4,120,0,0,0,0,0,0,0,0,0,0,16,56,16,16,20,8,0,0,0,0,0,0,0,0
        DB 0,0,0,68,68,68,76,52,0,0,0,0,0,0,0,0,0,0,0,68,68,40,40,16,0,0,0,0
        DB 0,0,0,0,0,0,0,68,68,68,84,40,0,0,0,0,0,0,0,0,0,0,0,68,40,16,40,68
        DB 0,0,0,0,0,0,0,0,0,0,0,68,68,68,60,4,56,0,0,0,0,0,0,0,0,0,0,124,8
        DB 16,32,124,0,0,0,0,0,0,0,0,0,12,16,16,96,16,16,12,0,0,0,0,0,0,0,0
        DB 0,16,16,16,0,16,16,16,0,0,0,0,0,0,0,0,0,96,16,16,12,16,16,96,0,0
        DB 0,0,0,0,0,0,0,32,84,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,0
        DB 0,0,0,0,0,0,0,0

        ORG 4000H

VBANK2R  DW 0
VBANK2W  DW 0
VSVIDEO2 DW ?
VEVIDEO2 DW ?

;Timing tables for instructions

        ORG 5000H

;Simple instruction
;          0 1 2 3 4 5 6 7 8 9 A B C D E F
        DB 6,?,?,6,6,?,6,6,6,6,6,?,6,6,3,6      ;0
        DB 0,0,2,13,?,?,5,9,?,2,3,?,3,2,8,7     ;1
        DB 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3      ;2
        DB 4,4,4,4,13,13,13,13,?,5,3,6,20,11,?,19;3
        DB 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2      ;4
        DB 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2      ;5
        DB 6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6      ;6
        DB 7,7,7,7,7,7,7,7,7,7,7,7,7,7,4,7      ;7
        DB 2,2,2,4,2,2,2,2,2,2,2,2,4,7,3,2      ;8
        DB 4,4,4,6,4,4,4,4,4,4,4,4,6,7,5,5      ;9
        DB 4,4,4,6,4,4,4,4,4,4,4,4,6,7,5,5      ;A
        DB 5,5,5,7,5,5,5,5,5,5,5,5,7,8,6,6      ;B
        DB 2,2,2,4,2,2,2,2,2,2,2,2,3,3,3,3      ;C
        DB 4,4,4,6,4,4,4,4,4,4,4,4,5,5,5,5      ;D
        DB 4,4,4,6,4,4,4,4,4,4,4,4,5,5,5,5      ;E
        DB 5,5,5,7,5,5,5,5,5,5,5,5,6,6,6,6      ;F

;Post-byte
;          0 1 2 3 4 5 6 7 8 9 A B C D E F
        DB 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1      ;0
        DB 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1      ;1
        DB 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1      ;2
        DB 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1      ;3
        DB 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1      ;4
        DB 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1      ;5
        DB 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1      ;6
        DB 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1      ;7
        DB 2,3,2,3,0,1,1,0,1,4,0,5,1,5,0,2      ;8
        DB 5,6,5,6,3,4,4,0,4,7,0,7,4,8,0,5      ;9
        DB 2,3,2,3,0,1,1,0,1,4,0,4,1,5,0,2      ;A
        DB 5,6,5,6,3,4,4,0,4,7,0,7,4,8,0,5      ;B
        DB 2,3,2,3,0,1,1,0,1,4,0,5,1,5,0,2      ;C
        DB 5,6,5,6,3,4,4,0,4,7,0,7,4,8,0,5      ;D
        DB 2,3,2,3,0,1,1,0,1,4,0,4,1,5,0,2      ;E
        DB 5,6,5,6,3,4,4,0,4,7,0,7,4,8,0,5      ;F

;10h prefix
;          0 1 2 3 4 5 6 7 8 9 A B C D E F
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      ;0
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      ;1
        DB 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5      ;2
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20     ;3
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      ;4
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      ;5
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      ;6
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      ;7
        DB 0,0,0,8,0,0,0,0,0,0,0,0,5,0,4,0      ;8
        DB 0,0,0,7,0,0,0,0,0,0,0,0,6,0,6,6      ;9
        DB 0,0,0,7,0,0,0,0,0,0,0,0,7,0,6,6      ;A
        DB 0,0,0,8,0,0,0,0,0,0,0,0,8,0,7,7      ;B
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0      ;C
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6      ;D
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6      ;E
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7      ;F

;11h prefix
;          0 1 2 3 4 5 6 7 8 9 A B C D E F
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      ;0
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      ;1
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      ;2
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20     ;3
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      ;4
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      ;5
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      ;6
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      ;7
        DB 0,0,0,5,0,0,0,0,0,0,0,0,5,0,0,0      ;8
        DB 0,0,0,7,0,0,0,0,0,0,0,0,7,0,0,0      ;9
        DB 0,0,0,7,0,0,0,0,0,0,0,0,7,0,0,0      ;A
        DB 0,0,0,8,0,0,0,0,0,0,0,0,8,0,0,0      ;B
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      ;C
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      ;D
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      ;E
        DB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      ;F

;Flag translation tables

FLAGS_TO_6809 DB 0
        DB 1,0,1,0,1,0,1,2,3,2,3,2,3,2,3,32,33,32,33,32,33,32,33,34,35,34
        DB 35,34,35,34,35,0,1,0,1,0,1,0,1,2,3,2,3,2,3,2,3,32,33,32,33,32,33
        DB 32,33,34,35,34,35,34,35,34,35,4,5,4,5,4,5,4,5,6,7,6,7,6,7,6,7,36
        DB 37,36,37,36,37,36,37,38,39,38,39,38,39,38,39,4,5,4,5,4,5,4,5,6,7
        DB 6,7,6,7,6,7,36,37,36,37,36,37,36,37,38,39,38,39,38,39,38,39,8,9,8
        DB 9,8,9,8,9,10,11,10,11,10,11,10,11,40,41,40,41,40,41,40,41,42,43,42
        DB 43,42,43,42,43,8,9,8,9,8,9,8,9,10,11,10,11,10,11,10,11,40,41,40,41
        DB 40,41,40,41,42,43,42,43,42,43,42,43,12,13,12,13,12,13,12,13,14,15
        DB 14,15,14,15,14,15,44,45,44,45,44,45,44,45,46,47,46,47,46,47,46,47
        DB 12,13,12,13,12,13,12,13,14,15,14,15,14,15,14,15,44,45,44,45,44,45
        DB 44,45,46,47,46,47,46,47,46,47

FLAGS_TO_8086 DB 0
        DB 1,8,9,64,65,72,73,128,129,136,137,192,193,200,201,0,1,8,9,64,65
        DB 72,73,128,129,136,137,192,193,200,201,16,17,24,25,80,81,88,89,144
        DB 145,152,153,208,209,216,217,16,17,24,25,80,81,88,89,144,145,152,153
        DB 208,209,216,217,0,1,8,9,64,65,72,73,128,129,136,137,192,193,200,201
        DB 0,1,8,9,64,65,72,73,128,129,136,137,192,193,200,201,16,17,24,25,80
        DB 81,88,89,144,145,152,153,208,209,216,217,16,17,24,25,80,81,88,89
        DB 144,145,152,153,208,209,216,217,0,1,8,9,64,65,72,73,128,129,136,137
        DB 192,193,200,201,0,1,8,9,64,65,72,73,128,129,136,137,192,193,200,201
        DB 16,17,24,25,80,81,88,89,144,145,152,153,208,209,216,217,16,17,24
        DB 25,80,81,88,89,144,145,152,153,208,209,216,217,0,1,8,9,64,65,72,73
        DB 128,129,136,137,192,193,200,201,0,1,8,9,64,65,72,73,128,129,136,137
        DB 192,193,200,201,16,17,24,25,80,81,88,89,144,145,152,153,208,209,216
        DB 217,16,17,24,25,80,81,88,89,144,145,152,153,208,209,216,217

        ORG 6000H

VBANK3R  DW 0
VBANK3W  DW 0
VSVIDEO3 DW ?
VEVIDEO3 DW ?

;Keyboard customizer screen
VKEY_FRAME DB 84,10,82,10,83,10,45,10,56,10,48,10,32,10,67,10,79,10,76,10,79,10
        DB 85,10,82,10,32,10,67,10,79,10,77,10,80,10,85,10,84,10,69,10,82,10
        DB 32,10,51,10,32,10,69,10,77,10,85,10,76,10,65,10,84,10,79,10,82,10
        DB 32,10,32,10,32,10,32,10,32,10,32,10,32,10,32,10,32,10,32,10,32,10
        DB 32,10,32,10,32,10,32,10,32,10,32,10,32,10,75,10,101,10,121,10,98
        DB 10,111,10,97,10,114,10,100,10,32,10,76,10,97,10,121,10,111,10,117
        DB 10,116,10,32,10,67,10,117,10,115,10,116,10,111,10,109,10,105,10,122
        DB 10,97,10,116,10,105,10,111,10,110,10,205,10,205,10,205,10,205,10
        DB 205,10,205,10,205,10,205,10,205,10,205,10,205,10,205,10,205,10,205
        DB 10,205,10,205,10,205,10,205,10,205,10,205,10,205,10,205,10,205,10
        DB 205,10,205,10,205,10,205,10,205,10,205,10,205,10,205,10,205,10,205
        DB 10,205,10,205,10,205,10,205,10,205,10,205,10,205,10,205,10,205,10
        DB 205,10,205,10,205,10,205,10,205,10,205,10,205,10,205,10,205,10,205
        DB 10,205,10,205,10,205,10,205,10,205,10,205,10,205,10,205,10,205,10
        DB 205,10,205,10,205,10,205,10,205,10,205,10,205,10,205,10,205,10,205
        DB 10,205,10,205,10,205,10,205,10,205,10,205,10,205,10,205,10,205,10
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,11,32,11,32,11,32,11,218,11,196,11,196
        DB 11,196,11,196,11,196,11,196,11,196,11,191,11,32,7,32,7,32,7,201,9
        DB 205,9,205,9,205,9,205,9,205,9,205,9,205,9,205,9,205,9,205,9,205,9
        DB 205,9,205,9,205,9,205,9,205,9,205,9,205,9,187,9,67,11,111,11,67,11
        DB 111,11,32,11,107,11,101,11,121,11,98,11,111,11,97,11,114,11,100,11
        DB 58,11,32,11,32,11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,11,32,11,32,11,32,11,179,11,78,7,79
        DB 7,84,7,72,7,73,7,78,7,71,7,179,11,32,7,32,7,32,7,186,9,32,7,24,9
        DB 32,9,32,9,32,9,32,9,80,9,67,9,32,9,107,9,101,9,121,9,32,9,32,9,32
        DB 9,32,7,25,9,32,7,186,9,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,11,32,11,32,11
        DB 32,11,192,11,196,11,196,11,196,11,196,11,196,11,196,11,196,11,217
        DB 11,32,7,32,7,32,7,204,9,205,9,205,9,205,9,205,9,205,9,205,9,205,9
        DB 205,9,205,9,205,9,205,9,205,9,205,9,205,9,205,9,205,9,205,9,205,9
        DB 185,9,32,7,32,7,32,7,32,7,218,11,196,11,196,11,196,11,194,11,196
        DB 11,196,11,196,11,194,11,196,11,196,11,196,11,194,11,196,11,196,11
        DB 196,11,194,11,196,11,196,11,196,11,194,11,196,11,196,11,196,11,194
        DB 11,196,11,196,11,196,11,194,11,196,11,196,11,196,11,194,11,196,11
        DB 196,11,196,11,194,11,196,11,196,11,196,11,194,11,196,11,196,11,196
        DB 11,194,11,196,11,196,11,196,11,194,11,196,11,196,11,196,11,191,11
        DB 32,7,32,7,32,7,186,9,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,186
        DB 9,32,7,32,7,32,7,32,7,179,11,49,7,32,7,33,7,179,11,50,7,32,7,34,7
        DB 179,11,51,7,32,7,35,7,179,11,52,7,32,7,36,7,179,11,53,7,32,7,37,7
        DB 179,11,54,7,32,7,38,7,179,11,55,7,32,7,39,7,179,11,56,7,32,7,40,7
        DB 179,11,57,7,32,7,41,7,179,11,32,7,48,7,32,7,179,11,58,7,32,7,42,7
        DB 179,11,45,7,32,7,61,7,179,11,66,7,82,7,75,7,179,11,32,7,32,7,32,7
        DB 186,9,32,11,32,11,32,11,32,11,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,186,9,218,11,196,11,196,11,196
        DB 11,197,11,196,11,196,11,196,11,197,11,196,11,196,11,196,11,197,11
        DB 196,11,196,11,196,11,197,11,196,11,196,11,196,11,197,11,196,11,196
        DB 11,196,11,197,11,196,11,196,11,196,11,197,11,196,11,196,11,196,11
        DB 197,11,196,11,196,11,196,11,197,11,196,11,196,11,196,11,197,11,196
        DB 11,196,11,196,11,197,11,196,11,196,11,196,11,197,11,196,11,196,11
        DB 196,11,197,11,196,11,196,11,196,11,180,11,32,7,32,7,32,7,186,9,32
        DB 7,32,11,32,11,32,11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,186,9,179,11,65,7,76,7,84,7,179,11,32,7
        DB 81,7,32,7,179,11,32,7,87,7,32,7,179,11,32,7,69,7,32,7,179,11,32,7
        DB 82,7,32,7,179,11,32,7,84,7,32,7,179,11,32,7,89,7,32,7,179,11,32,7
        DB 85,7,32,7,179,11,32,7,73,7,32,7,179,11,32,7,79,7,32,7,179,11,32,7
        DB 80,7,32,7,179,11,32,7,64,7,32,7,179,11,67,7,76,7,82,7,179,11,32,7
        DB 24,7,32,7,179,11,32,7,32,7,32,7,186,9,32,7,32,11,32,11,32,11,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 186,9,195,11,196,11,196,11,196,11,197,11,196,11,196,11,196,11,197
        DB 11,196,11,196,11,196,11,197,11,196,11,196,11,196,11,197,11,196,11
        DB 196,11,196,11,197,11,196,11,196,11,196,11,197,11,196,11,196,11,196
        DB 11,197,11,196,11,196,11,196,11,197,11,196,11,196,11,196,11,197,11
        DB 196,11,196,11,196,11,197,11,196,11,196,11,196,11,197,11,196,11,196
        DB 11,196,11,197,11,196,11,196,11,196,11,197,11,196,11,196,11,196,11
        DB 180,11,32,11,32,7,32,7,186,9,32,11,32,11,32,11,32,11,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,186,9,179
        DB 11,67,7,84,7,76,7,179,11,32,7,65,7,32,7,179,11,32,7,83,7,32,7,179
        DB 11,32,7,68,7,32,7,179,11,32,7,70,7,32,7,179,11,32,7,71,7,32,7,179
        DB 11,32,7,72,7,32,7,179,11,32,7,74,7,32,7,179,11,32,7,75,7,32,7,179
        DB 11,32,7,76,7,32,7,179,11,59,7,32,7,43,7,179,11,69,7,78,7,84,7,179
        DB 11,32,7,27,7,32,7,179,11,32,11,26,7,32,11,179,11,32,7,32,7,32,7,186
        DB 9,32,7,32,11,32,7,32,11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,186,9,192,11,196,11,196,11,196,11,197
        DB 11,196,11,196,11,196,11,197,11,196,11,196,11,196,11,197,11,196,11
        DB 196,11,196,11,197,11,196,11,196,11,196,11,197,11,196,11,196,11,196
        DB 11,197,11,196,11,196,11,196,11,197,11,196,11,196,11,196,11,197,11
        DB 196,11,196,11,196,11,197,11,196,11,196,11,196,11,197,11,196,11,196
        DB 11,196,11,197,11,196,11,196,11,196,11,193,11,196,11,196,11,196,11
        DB 197,11,196,11,196,11,196,11,180,11,32,7,32,7,32,7,186,9,32,7,32,11
        DB 32,11,32,11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,186,9,32,7,32,7,32,7,32,7,179,11,32,7,90,7,32,7
        DB 179,11,32,7,88,7,32,7,179,11,32,7,67,7,32,7,179,11,32,7,86,7,32,7
        DB 179,11,32,7,66,7,32,7,179,11,32,7,78,7,32,7,179,11,32,7,77,7,32,7
        DB 179,11,44,7,32,7,60,7,179,11,46,7,32,7,62,7,179,11,47,7,32,7,63,7
        DB 179,11,32,7,32,7,32,7,32,11,32,7,32,7,32,7,179,11,32,7,25,7,32,7
        DB 179,11,32,7,32,7,32,7,186,9,32,7,32,11,32,7,32,11,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,186,9,32,7
        DB 32,7,32,7,32,7,192,11,196,11,196,11,196,11,193,11,196,11,196,11,196
        DB 11,197,11,196,11,196,11,196,11,193,11,196,11,196,11,196,11,193,11
        DB 196,11,196,11,196,11,193,11,196,11,196,11,196,11,193,11,196,11,196
        DB 11,196,11,193,11,196,11,196,11,196,11,197,11,196,11,196,11,196,11
        DB 193,11,196,11,196,11,196,11,217,11,32,7,32,7,32,7,218,11,196,11,196
        DB 11,196,11,197,11,196,11,196,11,196,11,180,11,32,7,32,7,32,7,186,9
        DB 32,7,32,11,32,7,32,11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,186,9,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,11,32,11,32,11,32,11,179,11,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,83,7,80,7,65,7,67,7,69,7,32,7,66,7,65,7,82,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,179,11,32,11,32,11,32,11,32,11,32,11,32,7,32
        DB 7,32,7,32,7,32,7,32,7,179,11,70,7,49,7,32,7,179,11,70,7,50,7,32,7
        DB 179,11,32,7,32,7,32,7,186,9,32,7,32,11,32,7,32,11,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,186,9,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,11,32,11,32,11,32,11,192,11
        DB 196,11,196,11,196,11,196,11,196,11,196,11,196,11,196,11,196,11,196
        DB 11,196,11,196,11,196,11,196,11,196,11,196,11,196,11,196,11,196,11
        DB 196,11,196,11,196,11,196,11,217,11,32,11,32,11,32,11,32,11,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,192,11,196,11,196,11,196,11,193,11,196
        DB 11,196,11,196,11,217,11,32,7,32,7,32,7,186,9,32,7,32,11,32,7,32,11
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,186,9,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11
        DB 32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11
        DB 32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11
        DB 32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11
        DB 32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11
        DB 32,11,32,11,32,11,32,11,32,11,32,11,32,7,186,9,32,7,32,11,32,7,32
        DB 11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,186,9,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11
        DB 32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11
        DB 32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11
        DB 32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11
        DB 32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11
        DB 32,11,32,11,32,11,32,11,32,11,32,11,32,7,186,9,32,7,32,11,32,7,32
        DB 11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,186,9,91,11,70,11,49,11,93,11,32,11,32,15,32,15,32,15,32,15
        DB 32,15,32,15,32,15,32,15,32,15,32,15
        DB 32,15,32,15,32,11,32,11,32,11,32,11,119,11,104,11,101,11,110,11,32
        DB 11,80,11,67,11,32,11,107,11,101,11,121,11,32,11,105,11,115,11,32
        DB 11,117,11,110,11,83,11,72,11,73,11,70,11,84,11,101,11,100,11,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,186,9,32,7,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,186,9,91,11,70,11,50,11,93,11
        DB 32,11,32,11,32,11,32,11,32,11
        DB 32,11,32,11,32,11,32,11,32,11,32,11
        DB 32,11,32,11,32,11,32,11,32,11,32,11,119,11,104,11,101,11,110,11,32
        DB 11,80,11,67,11,32,11,107,11,101,11,121,11,32,11,105,11,115,11,32
        DB 11,83,11,72,11,73,11,70,11,84,11,101,11,100,11,32,11,32,11,32,11
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7
        DB 32,7,32,7,32,7,32,7,32,7,32,7,32,7,186,9,32,7,32,11,32,11,32,11,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,186,9,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,186,9,32,7,32,11,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,186
        DB 9,91,11,70,11,52,11,93,11,'.',15,'.',15,67,11,111,11,112,11,121,11,32,11
        DB 97,11,32,11,112,11,114,11,101,11,112,11,114,11,111,11,103,11,114
        DB 11,97,11,109,11,109,11,101,11,100,11,32,11,108,11,97,11,121,11,111
        DB 11,117,11,116,11,32,11,111,11,118,11,101,11,114,11,32,11,116,11,104
        DB 11,101,11,32,11,99,11,117,11,115,11,116,11,111,11,109,11,32,11,108
        DB 11,97,11,121,11,111,11,117,11,116,11,32,11,32,7,32,7,32,7,186
        DB 9,32,7,32,11,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32,7,32
        DB 7,32,7,32,7,32,7,32,7,32,7,186,9,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,7,32,7,32,7,32,7,32,7,200,9,205
        DB 9,205,9,205,9,205,9,205,9,205,9,205,9,205,9,205,9,205,9,205,9,205
        DB 9,205,9,205,9,205,9,205,9,205,9,205,9,188,9,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32,11,32
        DB 11,32,11,32,11

        ORG 8000H

VBANK4R  DW 0
VBANK4W  DW 0
VSVIDEO4 DW ?
VEVIDEO4 DW ?

VCUR_DIR DB 7000 DUP(?)          ;Current directory listing, 500 entries max.

        ORG 0A000H

VBANK5R  DW 0
VBANK5W  DW 0
VSVIDEO5 DW ?
VEVIDEO5 DW ?

        IF 0

        ORG 0C000H

VBANK6R  DW 0
VBANK6W  DW 0
VSVIDEO6 DW ?
VEVIDEO6 DW ?

        ORG 0E000H

VBANK7R  DW 0
VBANK7W  DW 0
VSVIDEO7 DW ?
VEVIDEO7 DW ?

        DB 32 DUP(?)

        ENDIF
